/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.block;

import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.init.ModBlockEntities;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IndexerControllerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<BlockPos, Boolean> creativeModeBreaks = new ConcurrentHashMap<BlockPos, Boolean>();

    public IndexerControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        CompoundTag nbt;
        super.m_6402_(level, pos, state, placer, stack);
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("UpgradeLevel") && nbt.m_128441_("ItemsPerTransfer") && (blockEntity = level.m_7702_(pos)) instanceof IndexerControllerBlockEntity) {
            IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
            int upgradeLevel = nbt.m_128451_("UpgradeLevel");
            int itemsPerTransfer = nbt.m_128451_("ItemsPerTransfer");
            controller.setCurrentUpgradeLevel(upgradeLevel);
            controller.setItemsPerTransfer(itemsPerTransfer);
            controller.m_6596_();
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        creativeModeBreaks.put(pos, player.m_150110_().f_35937_);
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            boolean isCreativeBreak;
            Boolean wasCreativeBreak = creativeModeBreaks.remove(pos);
            boolean bl = isCreativeBreak = wasCreativeBreak != null && wasCreativeBreak != false;
            if (!isCreativeBreak) {
                BlockEntity blockEntity = level.m_7702_(pos);
                ItemStack itemStack = new ItemStack((ItemLike)this);
                if (blockEntity instanceof IndexerControllerBlockEntity) {
                    IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
                    int upgradeLevel = controller.getCurrentUpgradeLevel();
                    int itemsPerTransfer = controller.getItemsPerTransfer();
                    if (upgradeLevel > 0) {
                        CompoundTag nbt = itemStack.m_41784_();
                        nbt.m_128405_("UpgradeLevel", upgradeLevel);
                        nbt.m_128405_("ItemsPerTransfer", itemsPerTransfer);
                    }
                }
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity;
        if (!level.m_5776_() && (entity = level.m_7702_(pos)) instanceof IndexerControllerBlockEntity) {
            IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)entity;
            controller.openNetworkScreen((ServerPlayer)player, pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new IndexerControllerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return IndexerControllerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.INDEXER_CONTROLLER.get()), IndexerControllerBlockEntity::tick);
    }
}

