/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.block;

import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.block.entity.IndexerManagerBlockEntity;
import com.agustinbenitez.indexer.init.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class IndexerManagerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public IndexerManagerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        this.notifyNearbyControllers(level, pos);
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof IndexerManagerBlockEntity) {
            IndexerManagerBlockEntity manager = (IndexerManagerBlockEntity)be;
            manager.markNetworkChanged();
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        this.notifyNearbyControllers(level, pos);
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof IndexerManagerBlockEntity) {
            IndexerManagerBlockEntity manager = (IndexerManagerBlockEntity)be;
            manager.markNetworkChanged();
        }
    }

    private void notifyNearbyControllers(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        int searchRadius = 16;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    BlockEntity blockEntity = level.m_7702_(checkPos);
                    if (!(blockEntity instanceof IndexerControllerBlockEntity)) continue;
                    IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
                    controller.markNetworkChanged();
                    return;
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity;
        if (!level.m_5776_() && (entity = level.m_7702_(pos)) instanceof IndexerManagerBlockEntity) {
            IndexerManagerBlockEntity be = (IndexerManagerBlockEntity)entity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)be, (BlockPos)pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new IndexerManagerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return IndexerManagerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.INDEXER_MANAGER.get()), (lvl, p, st, be) -> be.tick(lvl, p, st));
    }
}

