/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.block.entity;

import com.agustinbenitez.indexer.block.IndexerControllerBlock;
import com.agustinbenitez.indexer.block.IndexerPipeBlock;
import com.agustinbenitez.indexer.block.entity.IndexerConnectorBlockEntity;
import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.block.entity.IndexerManagerBlockEntity;
import com.agustinbenitez.indexer.init.ModBlockEntities;
import com.agustinbenitez.indexer.util.FilterUtils;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ExtractorBlockEntity
extends BlockEntity {
    private BlockPos connectedContainerPos = null;
    private int extractionCooldown = 0;
    private static final int EXTRACTION_COOLDOWN_MAX = 8;

    public ExtractorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.EXTRACTOR.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("ContainerX") && tag.m_128441_("ContainerY") && tag.m_128441_("ContainerZ")) {
            this.connectedContainerPos = new BlockPos(tag.m_128451_("ContainerX"), tag.m_128451_("ContainerY"), tag.m_128451_("ContainerZ"));
        }
        this.extractionCooldown = tag.m_128451_("ExtractionCooldown");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.connectedContainerPos != null) {
            tag.m_128405_("ContainerX", this.connectedContainerPos.m_123341_());
            tag.m_128405_("ContainerY", this.connectedContainerPos.m_123342_());
            tag.m_128405_("ContainerZ", this.connectedContainerPos.m_123343_());
        }
        tag.m_128405_("ExtractionCooldown", this.extractionCooldown);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ExtractorBlockEntity entity) {
        if (level.m_5776_()) {
            return;
        }
        entity.updateConnectedContainer();
        if (entity.extractionCooldown > 0) {
            --entity.extractionCooldown;
            return;
        }
        boolean didExtract = entity.attemptExtraction(level, pos);
        if (didExtract) {
            entity.extractionCooldown = 8;
        }
    }

    private void updateConnectedContainer() {
        Direction[] directions;
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos oldContainerPos = this.connectedContainerPos;
        this.connectedContainerPos = null;
        for (Direction direction : directions = new Direction[]{Direction.UP, Direction.DOWN}) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockEntity adjacentEntity = this.f_58857_.m_7702_(adjacentPos);
            if (!this.isValidContainer(adjacentEntity)) continue;
            this.connectedContainerPos = adjacentPos;
            this.m_6596_();
            return;
        }
        if (oldContainerPos != null && this.connectedContainerPos == null) {
            this.m_6596_();
        }
    }

    private boolean isValidContainer(BlockEntity entity) {
        if (entity == null) {
            return false;
        }
        String className = entity.getClass().getName();
        if (className.contains("ExtractorBlockEntity") || className.contains("IndexerConnectorBlockEntity") || className.contains("DropBoxBlockEntity")) {
            return false;
        }
        if (entity instanceof Container) {
            return true;
        }
        try {
            if (entity.getClass().getMethod("getContainerSize", new Class[0]) != null || entity.getClass().getMethod("getSlots", new Class[0]) != null || entity.getClass().getMethod("getInventory", new Class[0]) != null) {
                return true;
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return className.contains("BackpackBlockEntity") || className.contains("ChestBlockEntity") || className.contains("BarrelBlockEntity") || className.contains("ShulkerBoxBlockEntity") || className.contains("StorageBlockEntity") || className.contains("InventoryBlockEntity") || className.toLowerCase().contains("storage") || className.toLowerCase().contains("chest") || className.toLowerCase().contains("container") || className.toLowerCase().contains("inventory") || className.toLowerCase().contains("backpack") || className.toLowerCase().contains("bag");
    }

    private boolean attemptExtraction(Level level, BlockPos extractorPos) {
        IndexerManagerBlockEntity manager;
        IndexerControllerBlockEntity managerController;
        if (this.connectedContainerPos == null || this.f_58857_ == null) {
            return false;
        }
        if (!ExtractorBlockEntity.isConnectedToController(level, extractorPos)) {
            return false;
        }
        IndexerControllerBlockEntity controller = this.findConnectedController(level, extractorPos);
        if (controller == null) {
            return false;
        }
        int itemsToExtract = controller.getItemsPerTransfer();
        BlockEntity containerEntity = this.f_58857_.m_7702_(this.connectedContainerPos);
        if (containerEntity == null) {
            this.connectedContainerPos = null;
            return false;
        }
        if (containerEntity instanceof IndexerManagerBlockEntity && (managerController = (manager = (IndexerManagerBlockEntity)containerEntity).findNearestController()) != null && managerController.m_58899_().equals((Object)controller.m_58899_())) {
            return false;
        }
        boolean extractionSuccessful = false;
        extractionSuccessful = containerEntity instanceof Container ? this.extractFromContainer((Container)containerEntity, itemsToExtract, level, extractorPos) : this.extractFromModContainer(containerEntity, itemsToExtract, level, extractorPos);
        if (extractionSuccessful) {
            this.m_6596_();
        }
        return extractionSuccessful;
    }

    private boolean extractFromContainer(Container container, int itemsToExtract, Level level, BlockPos extractorPos) {
        boolean isFurnace;
        boolean bl = isFurnace = container.getClass().getName().contains("FurnaceBlockEntity") || container.getClass().getName().contains("BlastFurnaceBlockEntity") || container.getClass().getName().contains("SmokerBlockEntity");
        if (isFurnace) {
            return this.extractFromFurnace(container, itemsToExtract, level, extractorPos);
        }
        return this.extractFromGenericContainer(container, itemsToExtract, level, extractorPos);
    }

    private boolean extractFromFurnace(Container container, int itemsToExtract, Level level, BlockPos extractorPos) {
        ItemStack stackInSlot;
        ItemStack remainingStack;
        ItemStack extractedStack;
        ItemStack testStack;
        ItemStack fuelSlotStack;
        int FURNACE_RESULT_SLOT = 2;
        boolean FURNACE_FUEL_SLOT = true;
        if (1 < container.m_6643_() && !(fuelSlotStack = container.m_8020_(1)).m_41619_() && fuelSlotStack.m_41720_().m_5524_().equals("item.minecraft.bucket")) {
            testStack = fuelSlotStack.m_41777_();
            testStack.m_41764_(Math.min(itemsToExtract, fuelSlotStack.m_41613_()));
            if (this.canSendBucketToPipeSystem(testStack, level, extractorPos)) {
                extractedStack = fuelSlotStack.m_41777_();
                extractedStack.m_41764_(Math.min(itemsToExtract, fuelSlotStack.m_41613_()));
                fuelSlotStack.m_41774_(extractedStack.m_41613_());
                container.m_6836_(1, fuelSlotStack);
                if (this.sendItemToPipeSystem(extractedStack, level, extractorPos, false)) {
                    return true;
                }
                remainingStack = container.m_8020_(1);
                if (remainingStack.m_41619_()) {
                    container.m_6836_(1, extractedStack);
                } else if (remainingStack.m_41720_() == extractedStack.m_41720_() && remainingStack.m_41613_() + extractedStack.m_41613_() <= remainingStack.m_41741_()) {
                    remainingStack.m_41769_(extractedStack.m_41613_());
                    container.m_6836_(1, remainingStack);
                }
            }
        }
        if (2 < container.m_6643_() && !(stackInSlot = container.m_8020_(2)).m_41619_()) {
            testStack = stackInSlot.m_41777_();
            testStack.m_41764_(Math.min(itemsToExtract, stackInSlot.m_41613_()));
            if (!this.canSendItemToPipeSystem(testStack, level, extractorPos, true)) {
                return false;
            }
            extractedStack = stackInSlot.m_41777_();
            extractedStack.m_41764_(Math.min(itemsToExtract, stackInSlot.m_41613_()));
            stackInSlot.m_41774_(extractedStack.m_41613_());
            container.m_6836_(2, stackInSlot);
            if (this.sendItemToPipeSystem(extractedStack, level, extractorPos, true)) {
                return true;
            }
            remainingStack = container.m_8020_(2);
            if (remainingStack.m_41619_()) {
                container.m_6836_(2, extractedStack);
            } else if (remainingStack.m_41720_() == extractedStack.m_41720_() && remainingStack.m_41613_() + extractedStack.m_41613_() <= remainingStack.m_41741_()) {
                remainingStack.m_41769_(extractedStack.m_41613_());
                container.m_6836_(2, remainingStack);
            }
        }
        return false;
    }

    private boolean extractFromGenericContainer(Container container, int itemsToExtract, Level level, BlockPos extractorPos) {
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stackInSlot = container.m_8020_(slot);
            if (stackInSlot.m_41619_()) continue;
            ItemStack extractedStack = stackInSlot.m_41777_();
            extractedStack.m_41764_(Math.min(itemsToExtract, stackInSlot.m_41613_()));
            stackInSlot.m_41774_(extractedStack.m_41613_());
            container.m_6836_(slot, stackInSlot);
            if (this.sendItemToPipeSystem(extractedStack, level, extractorPos, false)) {
                return true;
            }
            ItemStack remainingStack = container.m_8020_(slot);
            if (remainingStack.m_41619_()) {
                container.m_6836_(slot, extractedStack);
            } else if (remainingStack.m_41720_() == extractedStack.m_41720_() && remainingStack.m_41613_() + extractedStack.m_41613_() <= remainingStack.m_41741_()) {
                remainingStack.m_41769_(extractedStack.m_41613_());
                container.m_6836_(slot, remainingStack);
            }
            return false;
        }
        return false;
    }

    private boolean extractFromModContainer(BlockEntity containerEntity, int itemsToExtract, Level level, BlockPos extractorPos) {
        try {
            Object inventory = null;
            int containerSize = 0;
            try {
                inventory = containerEntity.getClass().getMethod("getInventory", new Class[0]).invoke((Object)containerEntity, new Object[0]);
                containerSize = (Integer)inventory.getClass().getMethod("getSlots", new Class[0]).invoke(inventory, new Object[0]);
            }
            catch (Exception e1) {
                try {
                    containerSize = (Integer)containerEntity.getClass().getMethod("getContainerSize", new Class[0]).invoke((Object)containerEntity, new Object[0]);
                    inventory = containerEntity;
                }
                catch (Exception e2) {
                    try {
                        containerSize = (Integer)containerEntity.getClass().getMethod("getSlots", new Class[0]).invoke((Object)containerEntity, new Object[0]);
                        inventory = containerEntity;
                    }
                    catch (Exception e3) {
                        return false;
                    }
                }
            }
            if (inventory == null || containerSize <= 0) {
                return false;
            }
            for (int slot = 0; slot < containerSize; ++slot) {
                try {
                    ItemStack stackInSlot = null;
                    try {
                        stackInSlot = (ItemStack)inventory.getClass().getMethod("getStackInSlot", Integer.TYPE).invoke(inventory, slot);
                    }
                    catch (Exception e1) {
                        try {
                            stackInSlot = (ItemStack)inventory.getClass().getMethod("getItem", Integer.TYPE).invoke(inventory, slot);
                        }
                        catch (Exception e2) {
                            continue;
                        }
                    }
                    if (stackInSlot == null || stackInSlot.m_41619_()) continue;
                    ItemStack extractedStack = stackInSlot.m_41777_();
                    extractedStack.m_41764_(Math.min(itemsToExtract, stackInSlot.m_41613_()));
                    try {
                        ItemStack extracted = (ItemStack)inventory.getClass().getMethod("extractItem", Integer.TYPE, Integer.TYPE, Boolean.TYPE).invoke(inventory, slot, extractedStack.m_41613_(), false);
                        if (!extracted.m_41619_() && this.sendItemToPipeSystem(extracted, level, extractorPos, false)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        try {
                            stackInSlot.m_41774_(extractedStack.m_41613_());
                            inventory.getClass().getMethod("setStackInSlot", Integer.TYPE, ItemStack.class).invoke(inventory, slot, stackInSlot);
                            if (this.sendItemToPipeSystem(extractedStack, level, extractorPos, false)) {
                                return true;
                            }
                            stackInSlot.m_41769_(extractedStack.m_41613_());
                            inventory.getClass().getMethod("setStackInSlot", Integer.TYPE, ItemStack.class).invoke(inventory, slot, stackInSlot);
                        }
                        catch (Exception e2) {
                            try {
                                inventory.getClass().getMethod("setItem", Integer.TYPE, ItemStack.class).invoke(inventory, slot, stackInSlot);
                                if (this.sendItemToPipeSystem(extractedStack, level, extractorPos, false)) {
                                    return true;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    return false;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean sendItemToPipeSystem(ItemStack stack, Level level, BlockPos extractorPos, boolean requireMatchingFilter) {
        ItemStack remainder;
        IndexerConnectorBlockEntity connector;
        ItemStack filterItem;
        BlockEntity entity;
        BlockPos checkPos;
        int z;
        int y;
        int x;
        int searchRadius = 16;
        for (x = -searchRadius; x <= searchRadius; ++x) {
            for (y = -searchRadius; y <= searchRadius; ++y) {
                for (z = -searchRadius; z <= searchRadius; ++z) {
                    checkPos = extractorPos.m_7918_(x, y, z);
                    entity = level.m_7702_(checkPos);
                    if (!(entity instanceof IndexerConnectorBlockEntity) || (filterItem = (connector = (IndexerConnectorBlockEntity)entity).getFilterItem(0)).m_41619_() || !FilterUtils.passesFilter(stack, filterItem) || !(remainder = connector.insertItem(stack)).m_41619_() && remainder.m_41613_() >= stack.m_41613_()) continue;
                    return true;
                }
            }
        }
        if (requireMatchingFilter) {
            return false;
        }
        for (x = -searchRadius; x <= searchRadius; ++x) {
            for (y = -searchRadius; y <= searchRadius; ++y) {
                for (z = -searchRadius; z <= searchRadius; ++z) {
                    checkPos = extractorPos.m_7918_(x, y, z);
                    entity = level.m_7702_(checkPos);
                    if (!(entity instanceof IndexerConnectorBlockEntity) || !(filterItem = (connector = (IndexerConnectorBlockEntity)entity).getFilterItem(0)).m_41619_() && filterItem.m_41720_() == stack.m_41720_() || !(remainder = connector.insertItem(stack)).m_41619_() && remainder.m_41613_() >= stack.m_41613_()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canSendBucketToPipeSystem(ItemStack stack, Level level, BlockPos extractorPos) {
        int searchRadius = 16;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    IndexerConnectorBlockEntity connector;
                    BlockPos checkPos = extractorPos.m_7918_(x, y, z);
                    BlockEntity entity = level.m_7702_(checkPos);
                    if (!(entity instanceof IndexerConnectorBlockEntity) || !(connector = (IndexerConnectorBlockEntity)entity).canAcceptBuckets()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canSendItemToPipeSystem(ItemStack stack, Level level, BlockPos extractorPos, boolean requireMatchingFilter) {
        Container container;
        boolean isFurnace;
        String name;
        BlockEntity containerEntity;
        BlockPos containerPos;
        IndexerConnectorBlockEntity connector;
        ItemStack filterItem;
        BlockEntity entity;
        BlockPos checkPos;
        int z;
        int y;
        int x;
        int searchRadius = 16;
        for (x = -searchRadius; x <= searchRadius; ++x) {
            for (y = -searchRadius; y <= searchRadius; ++y) {
                for (z = -searchRadius; z <= searchRadius; ++z) {
                    checkPos = extractorPos.m_7918_(x, y, z);
                    entity = level.m_7702_(checkPos);
                    if (!(entity instanceof IndexerConnectorBlockEntity) || (filterItem = (connector = (IndexerConnectorBlockEntity)entity).getFilterItem(0)).m_41619_() || !FilterUtils.passesFilter(stack, filterItem) || (containerPos = connector.getConnectedContainerPos()) == null || !((containerEntity = level.m_7702_(containerPos)) instanceof Container)) continue;
                    name = containerEntity.getClass().getName();
                    boolean bl = isFurnace = name.contains("FurnaceBlockEntity") || name.contains("BlastFurnaceBlockEntity") || name.contains("SmokerBlockEntity");
                    if (isFurnace || !this.hasSpaceFor(container = (Container)containerEntity, stack)) continue;
                    return true;
                }
            }
        }
        if (requireMatchingFilter) {
            return false;
        }
        for (x = -searchRadius; x <= searchRadius; ++x) {
            for (y = -searchRadius; y <= searchRadius; ++y) {
                for (z = -searchRadius; z <= searchRadius; ++z) {
                    checkPos = extractorPos.m_7918_(x, y, z);
                    entity = level.m_7702_(checkPos);
                    if (!(entity instanceof IndexerConnectorBlockEntity) || !(filterItem = (connector = (IndexerConnectorBlockEntity)entity).getFilterItem(0)).m_41619_() && filterItem.m_41720_() == stack.m_41720_() || (containerPos = connector.getConnectedContainerPos()) == null || !((containerEntity = level.m_7702_(containerPos)) instanceof Container)) continue;
                    name = containerEntity.getClass().getName();
                    boolean bl = isFurnace = name.contains("FurnaceBlockEntity") || name.contains("BlastFurnaceBlockEntity") || name.contains("SmokerBlockEntity");
                    if (isFurnace || !this.hasSpaceFor(container = (Container)containerEntity, stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasSpaceFor(Container container, ItemStack stack) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack slotStack = container.m_8020_(i);
            if (slotStack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stack)) continue;
            int maxStackSize = Math.min(container.m_6893_(), slotStack.m_41741_());
            if (slotStack.m_41613_() >= maxStackSize) continue;
            return true;
        }
        return false;
    }

    public boolean hasConnectedContainer() {
        return this.connectedContainerPos != null;
    }

    public BlockPos getConnectedContainerPos() {
        return this.connectedContainerPos;
    }

    private IndexerControllerBlockEntity findConnectedController(Level level, BlockPos pos) {
        if (level == null) {
            return null;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockEntity entity;
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (adjacentState.m_60734_() instanceof IndexerControllerBlock && (entity = level.m_7702_(adjacentPos)) instanceof IndexerControllerBlockEntity) {
                return (IndexerControllerBlockEntity)entity;
            }
            if (!(adjacentState.m_60734_() instanceof IndexerPipeBlock)) continue;
            queue.add(adjacentPos);
            visited.add(adjacentPos);
        }
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = level.m_8055_(currentPos);
            for (Direction direction : Direction.values()) {
                BlockEntity entity;
                BlockPos nextPos = currentPos.m_121945_(direction);
                if (visited.contains(nextPos)) continue;
                BlockState nextState = level.m_8055_(nextPos);
                Block nextBlock = nextState.m_60734_();
                if (nextBlock instanceof IndexerControllerBlock && (entity = level.m_7702_(nextPos)) instanceof IndexerControllerBlockEntity) {
                    return (IndexerControllerBlockEntity)entity;
                }
                if (!(nextBlock instanceof IndexerPipeBlock)) continue;
                boolean currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                boolean nextPipeConnected = (Boolean)nextState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()));
                if (!currentPipeConnected || !nextPipeConnected) continue;
                queue.add(nextPos);
                visited.add(nextPos);
            }
        }
        return null;
    }

    private static boolean isConnectedToController(Level level, BlockPos pos) {
        if (level == null) {
            return false;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (adjacentState.m_60734_() instanceof IndexerControllerBlock) {
                return true;
            }
            if (!(adjacentState.m_60734_() instanceof IndexerPipeBlock)) continue;
            queue.add(adjacentPos);
            visited.add(adjacentPos);
        }
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = level.m_8055_(currentPos);
            for (Direction direction : Direction.values()) {
                BlockPos nextPos = currentPos.m_121945_(direction);
                if (visited.contains(nextPos)) continue;
                BlockState nextState = level.m_8055_(nextPos);
                Block nextBlock = nextState.m_60734_();
                if (nextBlock instanceof IndexerControllerBlock) {
                    return true;
                }
                if (!(nextBlock instanceof IndexerPipeBlock)) continue;
                boolean currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                boolean nextPipeConnected = (Boolean)nextState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()));
                if (!currentPipeConnected || !nextPipeConnected) continue;
                queue.add(nextPos);
                visited.add(nextPos);
            }
        }
        return false;
    }
}

