/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.block.entity;

import com.agustinbenitez.indexer.IndexerMod;
import com.agustinbenitez.indexer.block.IndexerConnectorBlock;
import com.agustinbenitez.indexer.init.ModBlockEntities;
import com.agustinbenitez.indexer.init.ModItems;
import com.agustinbenitez.indexer.inventory.IndexerConnectorMenu;
import com.agustinbenitez.indexer.util.FilterUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class IndexerConnectorBlockEntity
extends RandomizableContainerBlockEntity {
    private static final int BASE_FILTER_SLOTS = 9;
    private static final int UPGRADED_FILTER_SLOTS = 18;
    private int connectorLevel = 1;
    private int tickCounter = 0;
    private List<ItemStack> filterItems = new ArrayList<ItemStack>();
    private BlockPos connectedContainerPos = null;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);

    public IndexerConnectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.INDEXER_CONNECTOR.get(), pos, state);
        this.tickCounter = (int)(Math.random() * 20.0);
        for (int i = 0; i < 9; ++i) {
            this.filterItems.add(ItemStack.f_41583_);
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.indexer.connector");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new IndexerConnectorMenu(id, inventory, (Container)this, this);
    }

    public int m_6643_() {
        return this.getCurrentFilterSlots();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.connectorLevel = tag.m_128441_("ConnectorLevel") ? tag.m_128451_("ConnectorLevel") : 1;
        this.ensureFilterCapacity();
        this.filterItems.clear();
        if (tag.m_128441_("FilterItems")) {
            CompoundTag filterItemsTag = tag.m_128469_("FilterItems");
            int maxRead = 18;
            for (int i = 0; i < maxRead; ++i) {
                if (filterItemsTag.m_128441_("Item" + i)) {
                    this.filterItems.add(ItemStack.m_41712_((CompoundTag)filterItemsTag.m_128469_("Item" + i)));
                    continue;
                }
                this.filterItems.add(ItemStack.f_41583_);
            }
        } else {
            for (int i = 0; i < this.getCurrentFilterSlots(); ++i) {
                this.filterItems.add(ItemStack.f_41583_);
            }
        }
        this.ensureFilterCapacity();
        if (tag.m_128441_("ContainerX") && tag.m_128441_("ContainerY") && tag.m_128441_("ContainerZ")) {
            this.connectedContainerPos = new BlockPos(tag.m_128451_("ContainerX"), tag.m_128451_("ContainerY"), tag.m_128451_("ContainerZ"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("ConnectorLevel", this.connectorLevel);
        CompoundTag filterItemsTag = new CompoundTag();
        for (int i = 0; i < this.filterItems.size() && i < this.getCurrentFilterSlots(); ++i) {
            ItemStack filterItem = this.filterItems.get(i);
            if (filterItem.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            filterItem.m_41739_(itemTag);
            filterItemsTag.m_128365_("Item" + i, (Tag)itemTag);
        }
        tag.m_128365_("FilterItems", (Tag)filterItemsTag);
        if (this.connectedContainerPos != null) {
            tag.m_128405_("ContainerX", this.connectedContainerPos.m_123341_());
            tag.m_128405_("ContainerY", this.connectedContainerPos.m_123342_());
            tag.m_128405_("ContainerZ", this.connectedContainerPos.m_123343_());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, IndexerConnectorBlockEntity entity) {
        if (level.m_5776_()) {
            return;
        }
        ++entity.tickCounter;
        if (entity.tickCounter >= 20) {
            entity.tickCounter = 0;
            boolean isConnected = IndexerConnectorBlock.isConnectedToController(level, pos);
            if ((Boolean)state.m_61143_((Property)IndexerConnectorBlock.CONNECTED) != isConnected) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)IndexerConnectorBlock.CONNECTED, (Comparable)Boolean.valueOf(isConnected)), 3);
            }
        }
        BlockPos previousContainerPos = entity.connectedContainerPos;
        entity.updateConnectedContainer();
    }

    public void updateConnectedContainer() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos oldContainerPos = this.connectedContainerPos;
        this.connectedContainerPos = null;
        for (Direction direction : Direction.values()) {
            BlockPos doubleChestPos;
            BlockPos adjacentPos;
            BlockEntity adjacentEntity;
            if (!direction.m_122434_().m_122479_() || !((adjacentEntity = this.f_58857_.m_7702_(adjacentPos = this.f_58858_.m_121945_(direction))) instanceof Container) || adjacentEntity instanceof IndexerConnectorBlockEntity) continue;
            BlockPos targetContainerPos = this.isChestBlockEntity(adjacentEntity) ? ((doubleChestPos = this.findDoubleChestPartner(adjacentPos)) != null ? this.getMainChestPosition(adjacentPos, doubleChestPos) : adjacentPos) : adjacentPos;
            if (this.isContainerAlreadyConnected(targetContainerPos)) continue;
            this.connectedContainerPos = targetContainerPos;
            this.m_6596_();
            return;
        }
        if (oldContainerPos != null && this.connectedContainerPos == null) {
            this.m_6596_();
        }
    }

    private boolean isChestBlockEntity(BlockEntity entity) {
        return entity.getClass().getName().contains("ChestBlockEntity");
    }

    private BlockPos findDoubleChestPartner(BlockPos chestPos) {
        Direction[] horizontalDirections;
        if (this.f_58857_ == null) {
            return null;
        }
        for (Direction direction : horizontalDirections = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos adjacentPos = chestPos.m_121945_(direction);
            BlockEntity adjacentEntity = this.f_58857_.m_7702_(adjacentPos);
            if (adjacentEntity == null || !this.isChestBlockEntity(adjacentEntity)) continue;
            BlockState chestState = this.f_58857_.m_8055_(chestPos);
            BlockState adjacentState = this.f_58857_.m_8055_(adjacentPos);
            if (!chestState.m_60734_().getClass().equals(adjacentState.m_60734_().getClass())) continue;
            try {
                if (chestState.m_61138_((Property)BlockStateProperties.f_61374_) && adjacentState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    Direction adjacentFacing;
                    Direction chestFacing = (Direction)chestState.m_61143_((Property)BlockStateProperties.f_61374_);
                    if (!chestFacing.equals((Object)(adjacentFacing = (Direction)adjacentState.m_61143_((Property)BlockStateProperties.f_61374_)))) continue;
                    return adjacentPos;
                }
                return adjacentPos;
            }
            catch (Exception e) {
                return adjacentPos;
            }
        }
        return null;
    }

    private boolean isContainerAlreadyConnected(BlockPos containerPos) {
        if (this.f_58857_ == null || containerPos == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            IndexerConnectorBlockEntity other;
            BlockPos neighborPos = containerPos.m_121945_(dir);
            BlockEntity be = this.f_58857_.m_7702_(neighborPos);
            if (!(be instanceof IndexerConnectorBlockEntity) || (other = (IndexerConnectorBlockEntity)be) == this || !containerPos.equals((Object)other.getConnectedContainerPos())) continue;
            return true;
        }
        return false;
    }

    private BlockPos getMainChestPosition(BlockPos pos1, BlockPos pos2) {
        if (pos1.m_123341_() < pos2.m_123341_()) {
            return pos1;
        }
        if (pos1.m_123341_() > pos2.m_123341_()) {
            return pos2;
        }
        return pos1.m_123343_() < pos2.m_123343_() ? pos1 : pos2;
    }

    public boolean canAcceptItem(ItemStack stack) {
        if (this.connectedContainerPos == null) {
            this.updateConnectedContainer();
            if (this.connectedContainerPos == null) {
                return false;
            }
        }
        if (this.f_58857_ == null) {
            return false;
        }
        BlockEntity containerEntity = this.f_58857_.m_7702_(this.connectedContainerPos);
        if (!(containerEntity instanceof Container) || containerEntity instanceof IndexerConnectorBlockEntity) {
            this.connectedContainerPos = null;
            return false;
        }
        boolean isCoalOrCharcoal = stack.m_41720_().m_5524_().equals("item.minecraft.coal") || stack.m_41720_().m_5524_().equals("item.minecraft.charcoal");
        boolean isLavaBucket = stack.m_41720_().m_5524_().equals("item.minecraft.lava_bucket");
        boolean isFurnace = containerEntity.getClass().getName().contains("FurnaceBlockEntity");
        if ((isCoalOrCharcoal || isLavaBucket) && isFurnace) {
            return true;
        }
        if (this.isItemBlocked(stack)) {
            return false;
        }
        boolean hasPositiveFilters = false;
        for (ItemStack filterItem : this.filterItems) {
            if (filterItem.m_41619_() || filterItem.m_41720_() == ModItems.CUSTOM_TAG_BLOCKER.get()) continue;
            hasPositiveFilters = true;
            break;
        }
        if (!hasPositiveFilters) {
            return true;
        }
        boolean hasNameFilters = false;
        boolean passesNameFilter = false;
        for (ItemStack filterItem : this.filterItems) {
            if (filterItem.m_41619_() || filterItem.m_41720_() != ModItems.NAME_FILTER.get()) continue;
            hasNameFilters = true;
            System.out.println("[DEBUG] Evaluando filtro de nombre: " + String.valueOf(filterItem.m_41783_()));
            System.out.println("[DEBUG] Item a evaluar: " + stack.m_41611_().getString());
            boolean passes = FilterUtils.passesFilter(stack, filterItem);
            System.out.println("[DEBUG] \u00bfPasa el filtro? " + passes);
            if (!passes) continue;
            passesNameFilter = true;
            break;
        }
        if (hasNameFilters) {
            System.out.println("[DEBUG] Resultado final filtros de nombre: " + passesNameFilter);
            return passesNameFilter;
        }
        boolean hasAttributeFilters = false;
        boolean passesAttributeFilter = false;
        for (ItemStack filterItem : this.filterItems) {
            if (filterItem.m_41619_() || filterItem.m_41720_() != ModItems.ATTRIBUTE_FILTER.get()) continue;
            hasAttributeFilters = true;
            if (!FilterUtils.passesFilter(stack, filterItem)) continue;
            passesAttributeFilter = true;
            break;
        }
        if (hasAttributeFilters) {
            return passesAttributeFilter;
        }
        boolean hasSpecificFilters = false;
        boolean passesSpecificFilter = false;
        for (ItemStack filterItem : this.filterItems) {
            if (filterItem.m_41619_() || filterItem.m_41720_() != ModItems.TOOLS_FILTER.get() && filterItem.m_41720_() != ModItems.FOOD_FILTER.get() && filterItem.m_41720_() != ModItems.FUEL_FILTER.get()) continue;
            hasSpecificFilters = true;
            System.out.println("[CONNECTOR_DEBUG] Evaluando filtro espec\u00edfico: " + filterItem.m_41720_().m_5524_() + " para item: " + stack.m_41720_().m_5524_());
            if (FilterUtils.passesFilter(stack, filterItem)) {
                passesSpecificFilter = true;
                System.out.println("[CONNECTOR_DEBUG] Item PASA el filtro espec\u00edfico!");
                break;
            }
            System.out.println("[CONNECTOR_DEBUG] Item NO pasa el filtro espec\u00edfico");
        }
        if (hasSpecificFilters) {
            System.out.println("[CONNECTOR_DEBUG] Resultado final filtros espec\u00edficos: " + passesSpecificFilter);
            return passesSpecificFilter;
        }
        boolean hasExactFilters = false;
        boolean passesExactFilter = false;
        for (ItemStack filterItem : this.filterItems) {
            if (filterItem.m_41619_() || filterItem.m_41720_() == ModItems.NAME_FILTER.get() || filterItem.m_41720_() == ModItems.ATTRIBUTE_FILTER.get() || filterItem.m_41720_() == ModItems.TOOLS_FILTER.get() || filterItem.m_41720_() == ModItems.FOOD_FILTER.get() || filterItem.m_41720_() == ModItems.FUEL_FILTER.get() || filterItem.m_41720_() == ModItems.CUSTOM_TAG_BLOCKER.get()) continue;
            hasExactFilters = true;
            if (!FilterUtils.passesFilter(stack, filterItem)) continue;
            passesExactFilter = true;
            break;
        }
        if (hasExactFilters) {
            return passesExactFilter;
        }
        return false;
    }

    public boolean isItemBlocked(ItemStack stack) {
        for (ItemStack filterItem : this.filterItems) {
            if (filterItem.m_41619_() || !FilterUtils.isBlockingFilter(filterItem) || FilterUtils.passesFilter(stack, filterItem)) continue;
            return true;
        }
        return false;
    }

    public boolean canAcceptBuckets() {
        ItemStack bucketStack;
        Container container;
        if (this.connectedContainerPos == null) {
            this.updateConnectedContainer();
            if (this.connectedContainerPos == null) {
                return false;
            }
        }
        if (this.f_58857_ == null) {
            return false;
        }
        BlockEntity containerEntity = this.f_58857_.m_7702_(this.connectedContainerPos);
        if (!(containerEntity instanceof Container) || containerEntity instanceof IndexerConnectorBlockEntity) {
            this.connectedContainerPos = null;
            return false;
        }
        boolean hasAnyFilter = false;
        boolean hasBucketFilter = false;
        for (ItemStack filterItem : this.filterItems) {
            if (filterItem.m_41619_()) continue;
            hasAnyFilter = true;
            if (!filterItem.m_41720_().m_5524_().equals("item.minecraft.bucket")) continue;
            hasBucketFilter = true;
            break;
        }
        if (!hasAnyFilter) {
            container = (Container)containerEntity;
            bucketStack = new ItemStack((ItemLike)Items.f_42446_, 1);
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack slotStack = container.m_8020_(i);
                if (slotStack.m_41619_()) {
                    return true;
                }
                if (slotStack.m_41720_() != bucketStack.m_41720_() || slotStack.m_41613_() >= slotStack.m_41741_()) continue;
                return true;
            }
            return false;
        }
        if (hasBucketFilter) {
            container = (Container)containerEntity;
            bucketStack = new ItemStack((ItemLike)Items.f_42446_, 1);
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack slotStack = container.m_8020_(i);
                if (slotStack.m_41619_()) {
                    return true;
                }
                if (slotStack.m_41720_() != bucketStack.m_41720_() || slotStack.m_41613_() >= slotStack.m_41741_()) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack insertItem(ItemStack stack) {
        int inserted;
        LazyOptional cap;
        if (!this.canAcceptItem(stack) || this.f_58857_ == null) {
            return stack;
        }
        BlockEntity containerEntity = this.f_58857_.m_7702_(this.connectedContainerPos);
        if (!(containerEntity instanceof Container) || containerEntity instanceof IndexerConnectorBlockEntity) {
            return stack;
        }
        Container container = (Container)containerEntity;
        ItemStack remainder = stack.m_41777_();
        int initialCount = remainder.m_41613_();
        if (remainder.m_41613_() > 64) {
            return this.insertItemInBatches(remainder, container, containerEntity);
        }
        boolean isCoalOrCharcoal = stack.m_41720_().m_5524_().equals("item.minecraft.coal") || stack.m_41720_().m_5524_().equals("item.minecraft.charcoal");
        boolean isLavaBucket = stack.m_41720_().m_5524_().equals("item.minecraft.lava_bucket");
        boolean isFurnace = containerEntity.getClass().getName().contains("FurnaceBlockEntity");
        if (isFurnace && (isCoalOrCharcoal || isLavaBucket)) {
            IndexerMod.LOGGER.info("Detected furnace and fuel item (coal/charcoal/lava bucket), attempting to insert into fuel slot");
            boolean FURNACE_FUEL_SLOT = true;
            if (1 < container.m_6643_()) {
                int maxStackSize;
                int space;
                ItemStack fuelSlotStack = container.m_8020_(1);
                if (fuelSlotStack.m_41619_()) {
                    int maxStackSize2 = Math.min(container.m_6893_(), remainder.m_41741_());
                    int toInsert = Math.min(remainder.m_41613_(), maxStackSize2);
                    ItemStack newStack = remainder.m_41777_();
                    newStack.m_41764_(toInsert);
                    container.m_6836_(1, newStack);
                    remainder.m_41774_(toInsert);
                    if (remainder.m_41619_()) {
                        if (containerEntity instanceof BlockEntity) {
                            containerEntity.m_6596_();
                        }
                        return ItemStack.f_41583_;
                    }
                } else if (ItemStack.m_150942_((ItemStack)fuelSlotStack, (ItemStack)remainder) && (space = (maxStackSize = Math.min(container.m_6893_(), fuelSlotStack.m_41741_())) - fuelSlotStack.m_41613_()) > 0) {
                    int toInsert = Math.min(remainder.m_41613_(), space);
                    fuelSlotStack.m_41769_(toInsert);
                    remainder.m_41774_(toInsert);
                    if (remainder.m_41619_()) {
                        if (containerEntity instanceof BlockEntity) {
                            containerEntity.m_6596_();
                        }
                        return ItemStack.f_41583_;
                    }
                }
                if (!remainder.m_41619_()) {
                    if (containerEntity instanceof BlockEntity) {
                        containerEntity.m_6596_();
                    }
                    return remainder;
                }
            }
            if (containerEntity instanceof BlockEntity) {
                containerEntity.m_6596_();
            }
            return remainder;
        }
        if (isFurnace && !isCoalOrCharcoal && !isLavaBucket) {
            IndexerMod.LOGGER.info("Detected furnace and non-fuel item, attempting to insert into input slot");
            boolean FURNACE_INPUT_SLOT = false;
            ItemStack filterItem = this.getFilterItem(0);
            if (filterItem.m_41619_()) {
                return remainder;
            }
            if (!FilterUtils.passesFilter(remainder, filterItem)) {
                return remainder;
            }
            if (0 < container.m_6643_()) {
                int maxStackSize;
                int space;
                ItemStack inputSlotStack = container.m_8020_(0);
                if (inputSlotStack.m_41619_()) {
                    int maxStackSize3 = Math.min(container.m_6893_(), remainder.m_41741_());
                    int toInsert = Math.min(remainder.m_41613_(), maxStackSize3);
                    ItemStack newStack = remainder.m_41777_();
                    newStack.m_41764_(toInsert);
                    container.m_6836_(0, newStack);
                    remainder.m_41774_(toInsert);
                    if (remainder.m_41619_()) {
                        if (containerEntity instanceof BlockEntity) {
                            containerEntity.m_6596_();
                        }
                        return ItemStack.f_41583_;
                    }
                } else if (ItemStack.m_150942_((ItemStack)inputSlotStack, (ItemStack)remainder) && (space = (maxStackSize = Math.min(container.m_6893_(), inputSlotStack.m_41741_())) - inputSlotStack.m_41613_()) > 0) {
                    int toInsert = Math.min(remainder.m_41613_(), space);
                    inputSlotStack.m_41769_(toInsert);
                    remainder.m_41774_(toInsert);
                    if (remainder.m_41619_()) {
                        if (containerEntity instanceof BlockEntity) {
                            containerEntity.m_6596_();
                        }
                        return ItemStack.f_41583_;
                    }
                }
                if (containerEntity instanceof BlockEntity) {
                    containerEntity.m_6596_();
                }
                return remainder;
            }
        }
        if ((cap = containerEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent()) {
            IItemHandler handler = (IItemHandler)cap.resolve().get();
            ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)remainder, (boolean)false);
            if (result.m_41613_() < initialCount && containerEntity instanceof BlockEntity) {
                containerEntity.m_6596_();
            }
            return result;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            int space;
            int maxStackSize;
            if (isFurnace && i == 2) continue;
            ItemStack slotStack = container.m_8020_(i);
            if (slotStack.m_41619_()) {
                maxStackSize = Math.min(container.m_6893_(), remainder.m_41741_());
                int toInsert = Math.min(remainder.m_41613_(), maxStackSize);
                ItemStack newStack = remainder.m_41777_();
                newStack.m_41764_(toInsert);
                container.m_6836_(i, newStack);
                remainder.m_41774_(toInsert);
                if (!remainder.m_41619_()) continue;
                break;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remainder) || (space = (maxStackSize = Math.min(container.m_6893_(), slotStack.m_41741_())) - slotStack.m_41613_()) <= 0) continue;
            int toInsert = Math.min(remainder.m_41613_(), space);
            slotStack.m_41769_(toInsert);
            remainder.m_41774_(toInsert);
            if (remainder.m_41619_()) break;
        }
        if (containerEntity instanceof BlockEntity) {
            containerEntity.m_6596_();
        }
        if ((inserted = initialCount - remainder.m_41613_()) > 0) {
            // empty if block
        }
        return remainder;
    }

    private ItemStack insertIntoDoubleChest(ItemStack stack, BlockPos chest1Pos, BlockPos chest2Pos) {
        int space;
        int toInsert;
        int maxStackSize;
        ItemStack slotStack;
        int i;
        if (this.f_58857_ == null) {
            return stack;
        }
        BlockEntity chest1Entity = this.f_58857_.m_7702_(chest1Pos);
        BlockEntity chest2Entity = this.f_58857_.m_7702_(chest2Pos);
        if (!(chest1Entity instanceof Container) || !(chest2Entity instanceof Container)) {
            return stack;
        }
        Container chest1 = (Container)chest1Entity;
        Container chest2 = (Container)chest2Entity;
        ItemStack remainder = stack.m_41777_();
        for (i = 0; i < chest1.m_6643_(); ++i) {
            slotStack = chest1.m_8020_(i);
            if (slotStack.m_41619_()) {
                maxStackSize = Math.min(chest1.m_6893_(), remainder.m_41741_());
                toInsert = Math.min(remainder.m_41613_(), maxStackSize);
                ItemStack newStack = remainder.m_41777_();
                newStack.m_41764_(toInsert);
                chest1.m_6836_(i, newStack);
                remainder.m_41774_(toInsert);
                if (!remainder.m_41619_()) continue;
                return ItemStack.f_41583_;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remainder) || (space = (maxStackSize = Math.min(chest1.m_6893_(), slotStack.m_41741_())) - slotStack.m_41613_()) <= 0) continue;
            int toInsert2 = Math.min(remainder.m_41613_(), space);
            slotStack.m_41769_(toInsert2);
            remainder.m_41774_(toInsert2);
            if (!remainder.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        if (!remainder.m_41619_()) {
            for (i = 0; i < chest2.m_6643_(); ++i) {
                slotStack = chest2.m_8020_(i);
                if (slotStack.m_41619_()) {
                    maxStackSize = Math.min(chest2.m_6893_(), remainder.m_41741_());
                    toInsert = Math.min(remainder.m_41613_(), maxStackSize);
                    ItemStack newStack = remainder.m_41777_();
                    newStack.m_41764_(toInsert);
                    chest2.m_6836_(i, newStack);
                    remainder.m_41774_(toInsert);
                    if (!remainder.m_41619_()) continue;
                    return ItemStack.f_41583_;
                }
                if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remainder) || (space = (maxStackSize = Math.min(chest2.m_6893_(), slotStack.m_41741_())) - slotStack.m_41613_()) <= 0) continue;
                int toInsert3 = Math.min(remainder.m_41613_(), space);
                slotStack.m_41769_(toInsert3);
                remainder.m_41774_(toInsert3);
                if (!remainder.m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        return remainder;
    }

    private ItemStack insertItemInBatches(ItemStack stack, Container container, BlockEntity containerEntity) {
        ItemStack remainder = stack.m_41777_();
        while (!remainder.m_41619_()) {
            int batchSize = Math.min(remainder.m_41613_(), 64);
            ItemStack batch = remainder.m_41777_();
            batch.m_41764_(batchSize);
            ItemStack batchRemainder = this.insertItemSingle(batch, container, containerEntity);
            int inserted = batchSize - batchRemainder.m_41613_();
            remainder.m_41774_(inserted);
            if (inserted != 0) continue;
            break;
        }
        return remainder;
    }

    private ItemStack insertItemSingle(ItemStack stack, Container container, BlockEntity containerEntity) {
        BlockPos partnerPos;
        ItemStack remainder = stack.m_41777_();
        int initialCount = remainder.m_41613_();
        boolean isCoalOrCharcoal = stack.m_41720_().m_5524_().equals("item.minecraft.coal") || stack.m_41720_().m_5524_().equals("item.minecraft.charcoal");
        boolean isLavaBucket = stack.m_41720_().m_5524_().equals("item.minecraft.lava_bucket");
        boolean isFurnace = containerEntity.getClass().getName().contains("FurnaceBlockEntity");
        if (isFurnace && (isCoalOrCharcoal || isLavaBucket)) {
            boolean FURNACE_FUEL_SLOT = true;
            if (1 < container.m_6643_()) {
                int maxStackSize;
                int space;
                ItemStack fuelSlotStack = container.m_8020_(1);
                if (fuelSlotStack.m_41619_()) {
                    int maxStackSize2 = Math.min(container.m_6893_(), remainder.m_41741_());
                    int toInsert = Math.min(remainder.m_41613_(), maxStackSize2);
                    ItemStack newStack = remainder.m_41777_();
                    newStack.m_41764_(toInsert);
                    container.m_6836_(1, newStack);
                    remainder.m_41774_(toInsert);
                    if (remainder.m_41619_()) {
                        if (containerEntity instanceof BlockEntity) {
                            containerEntity.m_6596_();
                        }
                        return ItemStack.f_41583_;
                    }
                } else if (ItemStack.m_150942_((ItemStack)fuelSlotStack, (ItemStack)remainder) && (space = (maxStackSize = Math.min(container.m_6893_(), fuelSlotStack.m_41741_())) - fuelSlotStack.m_41613_()) > 0) {
                    int toInsert = Math.min(remainder.m_41613_(), space);
                    fuelSlotStack.m_41769_(toInsert);
                    remainder.m_41774_(toInsert);
                    if (remainder.m_41619_()) {
                        if (containerEntity instanceof BlockEntity) {
                            containerEntity.m_6596_();
                        }
                        return ItemStack.f_41583_;
                    }
                }
            }
            if (containerEntity instanceof BlockEntity) {
                containerEntity.m_6596_();
            }
            return remainder;
        }
        if (isFurnace && !isCoalOrCharcoal && !isLavaBucket) {
            boolean FURNACE_INPUT_SLOT = false;
            if (0 < container.m_6643_()) {
                int maxStackSize;
                int space;
                ItemStack inputSlotStack = container.m_8020_(0);
                if (inputSlotStack.m_41619_()) {
                    int maxStackSize3 = Math.min(container.m_6893_(), remainder.m_41741_());
                    int toInsert = Math.min(remainder.m_41613_(), maxStackSize3);
                    ItemStack newStack = remainder.m_41777_();
                    newStack.m_41764_(toInsert);
                    container.m_6836_(0, newStack);
                    remainder.m_41774_(toInsert);
                    if (remainder.m_41619_()) {
                        if (containerEntity instanceof BlockEntity) {
                            containerEntity.m_6596_();
                        }
                        return ItemStack.f_41583_;
                    }
                } else if (ItemStack.m_150942_((ItemStack)inputSlotStack, (ItemStack)remainder) && (space = (maxStackSize = Math.min(container.m_6893_(), inputSlotStack.m_41741_())) - inputSlotStack.m_41613_()) > 0) {
                    int toInsert = Math.min(remainder.m_41613_(), space);
                    inputSlotStack.m_41769_(toInsert);
                    remainder.m_41774_(toInsert);
                    if (remainder.m_41619_()) {
                        if (containerEntity instanceof BlockEntity) {
                            containerEntity.m_6596_();
                        }
                        return ItemStack.f_41583_;
                    }
                }
            }
            if (containerEntity instanceof BlockEntity) {
                containerEntity.m_6596_();
            }
            return remainder;
        }
        if (this.isChestBlockEntity(containerEntity) && (partnerPos = this.findDoubleChestPartner(this.connectedContainerPos)) != null) {
            BlockEntity partnerEntity;
            BlockPos mainChestPos = this.getMainChestPosition(this.connectedContainerPos, partnerPos);
            BlockPos secondChestPos = mainChestPos.equals((Object)this.connectedContainerPos) ? partnerPos : this.connectedContainerPos;
            remainder = this.insertIntoDoubleChest(remainder, mainChestPos, secondChestPos);
            if (containerEntity instanceof BlockEntity) {
                containerEntity.m_6596_();
            }
            if ((partnerEntity = this.f_58857_.m_7702_(partnerPos)) instanceof BlockEntity) {
                partnerEntity.m_6596_();
            }
            return remainder;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            int space;
            int maxStackSize;
            if (isFurnace && i == 2) continue;
            ItemStack slotStack = container.m_8020_(i);
            if (slotStack.m_41619_()) {
                maxStackSize = Math.min(container.m_6893_(), remainder.m_41741_());
                int toInsert = Math.min(remainder.m_41613_(), maxStackSize);
                ItemStack newStack = remainder.m_41777_();
                newStack.m_41764_(toInsert);
                container.m_6836_(i, newStack);
                remainder.m_41774_(toInsert);
                if (!remainder.m_41619_()) continue;
                break;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)remainder) || (space = (maxStackSize = Math.min(container.m_6893_(), slotStack.m_41741_())) - slotStack.m_41613_()) <= 0) continue;
            int toInsert = Math.min(remainder.m_41613_(), space);
            slotStack.m_41769_(toInsert);
            remainder.m_41774_(toInsert);
            if (remainder.m_41619_()) break;
        }
        if (containerEntity instanceof BlockEntity) {
            containerEntity.m_6596_();
        }
        return remainder;
    }

    public List<ItemStack> getFilterItems() {
        return this.filterItems;
    }

    public ItemStack getFilterItem(int slot) {
        if (slot >= 0 && slot < this.filterItems.size()) {
            return this.filterItems.get(slot);
        }
        return ItemStack.f_41583_;
    }

    public void setFilterItem(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.getCurrentFilterSlots()) {
            while (this.filterItems.size() <= slot) {
                this.filterItems.add(ItemStack.f_41583_);
            }
            this.filterItems.set(slot, stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_());
            if (!this.filterItems.get(slot).m_41619_()) {
                this.filterItems.get(slot).m_41764_(1);
            }
            this.m_6596_();
        }
    }

    public void setConnectedContainerPos(BlockPos pos) {
        this.connectedContainerPos = pos;
        this.m_6596_();
    }

    public BlockPos getConnectedContainerPos() {
        return this.connectedContainerPos;
    }

    public ItemStack m_8020_(int slot) {
        if (slot >= 0 && slot < this.getCurrentFilterSlots() && slot < this.filterItems.size()) {
            return this.filterItems.get(slot);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        if (slot >= 0 && slot < this.getCurrentFilterSlots() && slot < this.filterItems.size() && !this.filterItems.get(slot).m_41619_()) {
            ItemStack result = this.filterItems.get(slot).m_41777_();
            this.filterItems.set(slot, ItemStack.f_41583_);
            this.m_6596_();
            return result;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        if (slot >= 0 && slot < this.getCurrentFilterSlots() && slot < this.filterItems.size()) {
            ItemStack result = this.filterItems.get(slot);
            this.filterItems.set(slot, ItemStack.f_41583_);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.getCurrentFilterSlots()) {
            while (this.filterItems.size() <= slot) {
                this.filterItems.add(ItemStack.f_41583_);
            }
            if (!stack.m_41619_()) {
                if (!this.filterItems.get(slot).m_41619_()) {
                    this.filterItems.set(slot, stack.m_41777_());
                    this.filterItems.get(slot).m_41764_(1);
                } else {
                    int targetSlot = this.findNearestEmptySlot();
                    if (targetSlot != -1 && targetSlot != slot) {
                        while (this.filterItems.size() <= targetSlot) {
                            this.filterItems.add(ItemStack.f_41583_);
                        }
                        this.filterItems.set(targetSlot, stack.m_41777_());
                        this.filterItems.get(targetSlot).m_41764_(1);
                        this.filterItems.set(slot, ItemStack.f_41583_);
                    } else {
                        this.filterItems.set(slot, stack.m_41777_());
                        this.filterItems.get(slot).m_41764_(1);
                    }
                }
            } else {
                this.filterItems.set(slot, ItemStack.f_41583_);
            }
            this.m_6596_();
        }
    }

    private boolean isItemAlreadyInFilter(ItemStack stack) {
        return this.isItemAlreadyInFilter(stack, -1);
    }

    private boolean isItemAlreadyInFilter(ItemStack stack, int excludeSlot) {
        while (this.filterItems.size() < this.getCurrentFilterSlots()) {
            this.filterItems.add(ItemStack.f_41583_);
        }
        for (int i = 0; i < this.getCurrentFilterSlots(); ++i) {
            ItemStack filterItem;
            if (i == excludeSlot || (filterItem = this.filterItems.get(i)).m_41619_() || !ItemStack.m_41656_((ItemStack)filterItem, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    private int findNearestEmptySlot() {
        while (this.filterItems.size() < this.getCurrentFilterSlots()) {
            this.filterItems.add(ItemStack.f_41583_);
        }
        for (int i = 0; i < this.getCurrentFilterSlots(); ++i) {
            if (!this.filterItems.get(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.getCurrentFilterSlots()) {
            if (stack.m_41619_()) {
                return true;
            }
            return !this.isItemAlreadyInFilter(stack, slot);
        }
        return false;
    }

    public void m_6211_() {
        this.filterItems.clear();
        for (int i = 0; i < this.getCurrentFilterSlots(); ++i) {
            this.filterItems.add(ItemStack.f_41583_);
        }
        this.items.clear();
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public int getConnectorLevel() {
        return this.connectorLevel;
    }

    public void setConnectorLevel(int level) {
        this.connectorLevel = Math.max(1, level);
        this.ensureFilterCapacity();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int getCurrentFilterSlots() {
        return this.connectorLevel >= 2 ? 18 : 9;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public void ensureFilterCapacity() {
        int desired = this.getCurrentFilterSlots();
        if (this.items.size() != desired) {
            NonNullList newItems = NonNullList.m_122780_((int)desired, (Object)ItemStack.f_41583_);
            for (int i = 0; i < Math.min(this.items.size(), desired); ++i) {
                newItems.set(i, (Object)((ItemStack)this.items.get(i)));
            }
            this.items = newItems;
        }
        while (this.filterItems.size() < desired) {
            this.filterItems.add(ItemStack.f_41583_);
        }
        if (this.filterItems.size() > desired) {
            this.filterItems = new ArrayList<ItemStack>(this.filterItems.subList(0, desired));
        }
    }
}

