/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.block.entity;

import com.agustinbenitez.indexer.block.IndexerConnectorBlock;
import com.agustinbenitez.indexer.block.IndexerControllerBlock;
import com.agustinbenitez.indexer.block.IndexerPipeBlock;
import com.agustinbenitez.indexer.block.entity.IndexerConnectorBlockEntity;
import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.init.ModBlockEntities;
import com.agustinbenitez.indexer.menu.IndexerManagerMenu;
import com.agustinbenitez.indexer.network.ManagerItemsUpdatePacket;
import com.agustinbenitez.indexer.network.ModNetworking;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class IndexerManagerBlockEntity
extends RandomizableContainerBlockEntity {
    private boolean networkChanged = true;
    private List<IndexerConnectorBlockEntity> connectorCache = null;
    private static final int CONTAINER_SIZE = 9;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private final Map<String, Integer> pendingExtractions = new HashMap<String, Integer>();
    private final Map<String, ItemStack> pendingVariantByKey = new HashMap<String, ItemStack>();
    private static final int EXTRACTION_COOLDOWN_MAX = 8;
    private int extractionCooldown = 0;
    private int syncTicker = 0;

    public IndexerManagerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.INDEXER_MANAGER.get(), pos, state);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.indexer.manager");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new IndexerManagerMenu(id, inventory, (BlockEntity)this);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.indexer.manager");
    }

    public int m_6643_() {
        return 9;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.extractionCooldown = tag.m_128451_("ExtractionCooldown");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_("ExtractionCooldown", this.extractionCooldown);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public List<ManagerItemsUpdatePacket.Entry> getAggregatedItemVariants() {
        HashMap<String, ManagerItemsUpdatePacket.Entry> variants = new HashMap<String, ManagerItemsUpdatePacket.Entry>();
        List<IndexerConnectorBlockEntity> connectors = this.findConnectors();
        if (connectors.isEmpty()) {
            return new ArrayList<ManagerItemsUpdatePacket.Entry>();
        }
        for (IndexerConnectorBlockEntity connector : connectors) {
            BlockEntity be;
            BlockPos containerPos = connector.getConnectedContainerPos();
            if (containerPos == null || this.f_58857_ == null || (be = this.f_58857_.m_7702_(containerPos)) == null) continue;
            LazyOptional cap = be.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            if (cap.isPresent()) {
                IItemHandler handler = (IItemHandler)cap.resolve().get();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    this.aggregateStack(variants, handler.getStackInSlot(i));
                }
                continue;
            }
            if (!(be instanceof Container)) continue;
            Container container = (Container)be;
            for (int i = 0; i < container.m_6643_(); ++i) {
                this.aggregateStack(variants, container.m_8020_(i));
            }
        }
        return new ArrayList<ManagerItemsUpdatePacket.Entry>(variants.values());
    }

    private void aggregateStack(Map<String, ManagerItemsUpdatePacket.Entry> variants, ItemStack stack) {
        boolean pend;
        if (stack.m_41619_()) {
            return;
        }
        String key = this.buildVariantKey(stack);
        ManagerItemsUpdatePacket.Entry entry = variants.get(key);
        if (entry == null) {
            ItemStack icon = stack.m_41777_();
            icon.m_41764_(1);
            pend = this.pendingExtractions.getOrDefault(key, 0) > 0;
            entry = new ManagerItemsUpdatePacket.Entry(icon, 0, pend);
            variants.put(key, entry);
        }
        int newCount = entry.count + stack.m_41613_();
        pend = this.pendingExtractions.getOrDefault(key, 0) > 0;
        variants.put(key, new ManagerItemsUpdatePacket.Entry(entry.stackVariant, newCount, pend));
    }

    /*
     * WARNING - void declaration
     */
    private String buildVariantKey(ItemStack stack) {
        ResourceLocation base = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (base == null) {
            return "unknown";
        }
        StringBuilder sb = new StringBuilder(base.toString());
        if (stack.m_41782_() && stack.m_41783_() != null) {
            int lvl;
            String id;
            CompoundTag ench;
            ListTag list;
            CompoundTag tag = stack.m_41783_();
            ArrayList<CallSite> parts = new ArrayList<CallSite>();
            if (tag.m_128441_("Enchantments")) {
                void var7_8;
                list = tag.m_128437_("Enchantments", 10);
                boolean bl = false;
                while (var7_8 < list.size()) {
                    ench = list.m_128728_((int)var7_8);
                    id = ench.m_128461_("id");
                    lvl = ench.m_128451_("lvl");
                    parts.add((CallSite)((Object)(id + ":" + lvl)));
                    ++var7_8;
                }
            }
            if (tag.m_128441_("StoredEnchantments")) {
                void var7_10;
                list = tag.m_128437_("StoredEnchantments", 10);
                boolean bl = false;
                while (var7_10 < list.size()) {
                    ench = list.m_128728_((int)var7_10);
                    id = ench.m_128461_("id");
                    lvl = ench.m_128451_("lvl");
                    parts.add((CallSite)((Object)(id + ":" + lvl)));
                    ++var7_10;
                }
            }
            Collections.sort(parts);
            if (!parts.isEmpty()) {
                sb.append("|E:");
                for (String string : parts) {
                    sb.append(string).append(",");
                }
            }
            if (tag.m_128441_("BlockEntityTag")) {
                sb.append("|BET:").append(tag.m_128469_("BlockEntityTag").toString());
            }
        }
        return sb.toString();
    }

    private ResourceLocation parseBaseIdFromKey(String key) {
        int idx = key.indexOf("|E:");
        String base = idx >= 0 ? key.substring(0, idx) : key;
        try {
            return new ResourceLocation(base);
        }
        catch (Exception e) {
            return ForgeRegistries.ITEMS.getKey((Object)Items.f_41852_);
        }
    }

    public void sendItemsTo(ServerPlayer player) {
        List<ManagerItemsUpdatePacket.Entry> data = this.getAggregatedItemVariants();
        ModNetworking.sendToPlayer(new ManagerItemsUpdatePacket(data), player);
    }

    private void sendItemsToOpenPlayers() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        List<ManagerItemsUpdatePacket.Entry> data = this.getAggregatedItemVariants();
        for (ServerPlayer sp : serverLevel.m_6907_()) {
            IndexerManagerMenu managerMenu;
            AbstractContainerMenu menu = sp.f_36096_;
            if (!(menu instanceof IndexerManagerMenu) || (managerMenu = (IndexerManagerMenu)menu).getBlockEntity() != this) continue;
            ModNetworking.sendToPlayer(new ManagerItemsUpdatePacket(data), sp);
        }
    }

    public void syncOpenPlayers() {
        this.sendItemsToOpenPlayers();
    }

    public void queueExtraction(ResourceLocation itemId, int amount, ItemStack variantStack) {
        ItemStack icon;
        if (amount <= 0) {
            return;
        }
        ItemStack itemStack = icon = variantStack.m_41619_() ? new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemId)) : variantStack.m_41777_();
        if (!icon.m_41619_()) {
            icon.m_41764_(1);
        }
        String key = this.buildVariantKey(icon);
        int current = this.pendingExtractions.getOrDefault(key, 0);
        this.pendingExtractions.put(key, current + amount);
        this.pendingVariantByKey.put(key, icon);
        this.m_6596_();
    }

    public void cancelPendingExtraction(ItemStack variantStack) {
        if (variantStack.m_41619_()) {
            return;
        }
        ItemStack icon = variantStack.m_41777_();
        icon.m_41764_(1);
        String key = this.buildVariantKey(icon);
        if (this.pendingExtractions.containsKey(key)) {
            this.pendingExtractions.remove(key);
            this.pendingVariantByKey.remove(key);
            this.m_6596_();
            this.sendItemsToOpenPlayers();
        }
    }

    public int extractImmediately(ResourceLocation itemId, int amount, ItemStack variantStack) {
        int perTransfer = Math.max(1, this.getItemsPerTransferFromNearestController());
        int limit = Math.max(0, Math.min(amount, perTransfer));
        int moved = this.moveFromNetworkIntoInventory(itemId, limit, variantStack);
        if (moved > 0) {
            this.m_6596_();
        }
        return moved;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        ++this.syncTicker;
        if (this.syncTicker >= 10) {
            this.syncTicker = 0;
            Level level2 = this.f_58857_;
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                boolean hasOpenPlayers = false;
                for (ServerPlayer sp : serverLevel.m_6907_()) {
                    IndexerManagerMenu managerMenu;
                    AbstractContainerMenu abstractContainerMenu = sp.f_36096_;
                    if (!(abstractContainerMenu instanceof IndexerManagerMenu) || (managerMenu = (IndexerManagerMenu)abstractContainerMenu).getBlockEntity() != this) continue;
                    hasOpenPlayers = true;
                    break;
                }
                if (hasOpenPlayers) {
                    this.sendItemsToOpenPlayers();
                }
            }
        }
        if (this.pendingExtractions.isEmpty()) {
            return;
        }
        if (this.extractionCooldown > 0) {
            --this.extractionCooldown;
            return;
        }
        String nextKey = this.pendingExtractions.keySet().iterator().next();
        int remainingRequest = this.pendingExtractions.getOrDefault(nextKey, 0);
        if (remainingRequest <= 0) {
            this.pendingExtractions.remove(nextKey);
            this.pendingVariantByKey.remove(nextKey);
            return;
        }
        int perTick = this.getItemsPerTransferFromNearestController();
        int toTransferThisTick = Math.min(perTick, remainingRequest);
        ItemStack var = this.pendingVariantByKey.getOrDefault(nextKey, ItemStack.f_41583_);
        ResourceLocation nextId = var.m_41619_() ? this.parseBaseIdFromKey(nextKey) : ForgeRegistries.ITEMS.getKey((Object)var.m_41720_());
        int moved = this.moveFromNetworkIntoInventory(nextId, toTransferThisTick, var);
        if (moved > 0) {
            this.pendingExtractions.put(nextKey, remainingRequest - moved);
            if (this.pendingExtractions.get(nextKey) <= 0) {
                this.pendingExtractions.remove(nextKey);
                this.pendingVariantByKey.remove(nextKey);
            }
            this.m_6596_();
            this.extractionCooldown = 8;
            this.sendItemsToOpenPlayers();
        } else {
            this.pendingExtractions.remove(nextKey);
            this.pendingVariantByKey.remove(nextKey);
        }
    }

    public boolean isInventoryFull() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack s = this.m_8020_(i);
            if (s.m_41619_()) {
                return false;
            }
            if (s.m_41613_() >= s.m_41741_()) continue;
            return false;
        }
        return true;
    }

    private int moveFromNetworkIntoInventory(ResourceLocation itemId, int maxAmount, ItemStack variantStack) {
        if (this.f_58857_ == null || maxAmount <= 0) {
            return 0;
        }
        int remaining = maxAmount;
        List<IndexerConnectorBlockEntity> connectors = this.findConnectors();
        block0: for (IndexerConnectorBlockEntity connector : connectors) {
            ItemStack toMove;
            int inserted;
            ResourceLocation key;
            ItemStack slot;
            int i;
            BlockEntity be;
            if (remaining <= 0) break;
            BlockPos containerPos = connector.getConnectedContainerPos();
            if (containerPos == null || (be = this.f_58857_.m_7702_(containerPos)) == null) continue;
            LazyOptional cap = be.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            if (cap.isPresent()) {
                IItemHandler handler = (IItemHandler)cap.resolve().get();
                for (i = 0; i < handler.getSlots() && remaining > 0; ++i) {
                    ItemStack extractedSim;
                    slot = handler.getStackInSlot(i);
                    if (slot.m_41619_() || (key = ForgeRegistries.ITEMS.getKey((Object)slot.m_41720_())) == null || !key.equals((Object)itemId) || !this.variantMatches(slot, variantStack) || (extractedSim = handler.extractItem(i, remaining, true)).m_41619_() || (inserted = this.insertIntoSelf(toMove = extractedSim.m_41777_())) <= 0) continue;
                    handler.extractItem(i, inserted, false);
                    remaining -= inserted;
                    if (!(be instanceof BlockEntity)) continue;
                    be.m_6596_();
                }
                continue;
            }
            if (!(be instanceof Container)) continue;
            Container container = (Container)be;
            for (i = 0; i < container.m_6643_(); ++i) {
                int take;
                slot = container.m_8020_(i);
                if (slot.m_41619_() || (key = ForgeRegistries.ITEMS.getKey((Object)slot.m_41720_())) == null || !key.equals((Object)itemId) || !this.variantMatches(slot, variantStack) || (take = Math.min(remaining, slot.m_41613_())) <= 0) continue;
                toMove = slot.m_41777_();
                toMove.m_41764_(take);
                inserted = this.insertIntoSelf(toMove);
                if (inserted > 0) {
                    slot.m_41774_(inserted);
                    container.m_6836_(i, slot.m_41619_() ? ItemStack.f_41583_ : slot);
                    remaining -= inserted;
                }
                if (be instanceof BlockEntity) {
                    be.m_6596_();
                }
                if (remaining <= 0) continue block0;
            }
        }
        return maxAmount - remaining;
    }

    private boolean variantMatches(ItemStack a, ItemStack variant) {
        CompoundTag ench;
        int i;
        boolean vHas;
        boolean vHasBet;
        if (variant.m_41619_()) {
            return true;
        }
        CompoundTag ta = a.m_41782_() ? a.m_41783_() : null;
        CompoundTag tv = variant.m_41782_() ? variant.m_41783_() : null;
        boolean aHasBet = ta != null && ta.m_128441_("BlockEntityTag");
        boolean bl = vHasBet = tv != null && tv.m_128441_("BlockEntityTag");
        if (aHasBet != vHasBet) {
            return false;
        }
        if (aHasBet && !ta.m_128469_("BlockEntityTag").equals((Object)tv.m_128469_("BlockEntityTag"))) {
            return false;
        }
        boolean aHas = ta != null && (ta.m_128441_("Enchantments") || ta.m_128441_("StoredEnchantments"));
        boolean bl2 = vHas = tv != null && (tv.m_128441_("Enchantments") || tv.m_128441_("StoredEnchantments"));
        if (!aHas && !vHas) {
            return true;
        }
        if (aHas != vHas) {
            return false;
        }
        ArrayList<CallSite> pa = new ArrayList<CallSite>();
        ArrayList<CallSite> pv = new ArrayList<CallSite>();
        if (ta != null && ta.m_128441_("Enchantments")) {
            ListTag la = ta.m_128437_("Enchantments", 10);
            for (i = 0; i < la.size(); ++i) {
                ench = la.m_128728_(i);
                pa.add((CallSite)((Object)(ench.m_128461_("id") + ":" + ench.m_128451_("lvl"))));
            }
        }
        if (ta != null && ta.m_128441_("StoredEnchantments")) {
            ListTag la2 = ta.m_128437_("StoredEnchantments", 10);
            for (i = 0; i < la2.size(); ++i) {
                ench = la2.m_128728_(i);
                pa.add((CallSite)((Object)(ench.m_128461_("id") + ":" + ench.m_128451_("lvl"))));
            }
        }
        if (tv != null && tv.m_128441_("Enchantments")) {
            ListTag lv = tv.m_128437_("Enchantments", 10);
            for (i = 0; i < lv.size(); ++i) {
                ench = lv.m_128728_(i);
                pv.add((CallSite)((Object)(ench.m_128461_("id") + ":" + ench.m_128451_("lvl"))));
            }
        }
        if (tv != null && tv.m_128441_("StoredEnchantments")) {
            ListTag lv2 = tv.m_128437_("StoredEnchantments", 10);
            for (i = 0; i < lv2.size(); ++i) {
                ench = lv2.m_128728_(i);
                pv.add((CallSite)((Object)(ench.m_128461_("id") + ":" + ench.m_128451_("lvl"))));
            }
        }
        Collections.sort(pa);
        Collections.sort(pv);
        return pa.equals(pv);
    }

    private int insertIntoSelf(ItemStack stack) {
        int i;
        int originalCount = stack.m_41613_();
        for (i = 0; i < this.m_6643_(); ++i) {
            ItemStack existing = this.m_8020_(i);
            if (existing.m_41619_()) {
                this.m_6836_(i, stack.m_41777_());
                return originalCount;
            }
            if (!ItemStack.m_41656_((ItemStack)existing, (ItemStack)stack) || existing.m_41613_() >= existing.m_41741_()) continue;
            int canAdd = Math.min(stack.m_41613_(), existing.m_41741_() - existing.m_41613_());
            existing.m_41769_(canAdd);
            stack.m_41774_(canAdd);
            this.m_6836_(i, existing);
            if (!stack.m_41619_()) continue;
            return originalCount;
        }
        if (!stack.m_41619_()) {
            for (i = 0; i < this.m_6643_(); ++i) {
                if (!this.m_8020_(i).m_41619_()) continue;
                this.m_6836_(i, stack.m_41777_());
                return originalCount;
            }
        }
        return originalCount - stack.m_41613_();
    }

    private int getItemsPerTransferFromNearestController() {
        IndexerControllerBlockEntity controller = this.findNearestController();
        return controller != null ? Math.max(1, controller.getItemsPerTransfer()) : 1;
    }

    @Nullable
    public IndexerControllerBlockEntity findNearestController() {
        if (this.f_58857_ == null) {
            return null;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockState adjacentState = this.f_58857_.m_8055_(adjacentPos);
            Block adjacentBlock = adjacentState.m_60734_();
            if (adjacentBlock instanceof IndexerPipeBlock) {
                if (!((Boolean)adjacentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()))).booleanValue()) continue;
                queue.add(adjacentPos);
                visited.add(adjacentPos);
                continue;
            }
            if (!(adjacentBlock instanceof IndexerControllerBlock)) continue;
            BlockEntity entity = this.f_58857_.m_7702_(adjacentPos);
            if (entity instanceof IndexerControllerBlockEntity) {
                IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)entity;
                return controller;
            }
            visited.add(adjacentPos);
        }
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = this.f_58857_.m_8055_(currentPos);
            for (Direction direction : Direction.values()) {
                BlockPos nextPos = currentPos.m_121945_(direction);
                if (visited.contains(nextPos)) continue;
                BlockState nextState = this.f_58857_.m_8055_(nextPos);
                Block nextBlock = nextState.m_60734_();
                if (nextBlock instanceof IndexerControllerBlock) {
                    BlockEntity entity = this.f_58857_.m_7702_(nextPos);
                    if (entity instanceof IndexerControllerBlockEntity) {
                        IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)entity;
                        return controller;
                    }
                    visited.add(nextPos);
                    continue;
                }
                if (!(nextBlock instanceof IndexerPipeBlock)) continue;
                boolean currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                boolean nextPipeConnected = (Boolean)nextState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()));
                if (!currentPipeConnected || !nextPipeConnected) continue;
                queue.add(nextPos);
                visited.add(nextPos);
            }
        }
        return null;
    }

    private List<IndexerConnectorBlockEntity> findConnectors() {
        IndexerControllerBlockEntity controller = this.findNearestController();
        if (controller != null) {
            List<IndexerConnectorBlockEntity> controllerConnectors = controller.findConnectors();
            this.connectorCache = controllerConnectors;
            this.networkChanged = false;
            return controllerConnectors;
        }
        if (!this.networkChanged && this.connectorCache != null) {
            return this.connectorCache;
        }
        ArrayList<IndexerConnectorBlockEntity> connectors = new ArrayList<IndexerConnectorBlockEntity>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockState adjacentState = this.f_58857_.m_8055_(adjacentPos);
            if (adjacentState.m_60734_() instanceof IndexerPipeBlock) {
                if (!((Boolean)adjacentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()))).booleanValue()) continue;
                queue.add(adjacentPos);
                visited.add(adjacentPos);
                continue;
            }
            if (adjacentState.m_60734_() instanceof IndexerConnectorBlock) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(adjacentPos);
                if (!(blockEntity instanceof IndexerConnectorBlockEntity)) continue;
                connectors.add((IndexerConnectorBlockEntity)blockEntity);
                continue;
            }
            if (!(adjacentState.m_60734_() instanceof IndexerControllerBlock)) continue;
            visited.add(adjacentPos);
            queue.add(adjacentPos);
        }
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = this.f_58857_.m_8055_(currentPos);
            BlockEntity blockEntity = this.f_58857_.m_7702_(currentPos);
            if (blockEntity instanceof IndexerConnectorBlockEntity) {
                connectors.add((IndexerConnectorBlockEntity)blockEntity);
                continue;
            }
            for (Direction direction : Direction.values()) {
                boolean validSource;
                BlockPos nextPos = currentPos.m_121945_(direction);
                if (visited.contains(nextPos)) continue;
                BlockState nextState = this.f_58857_.m_8055_(nextPos);
                Block nextBlock = nextState.m_60734_();
                boolean isCurrentPipe = currentState.m_60734_() instanceof IndexerPipeBlock;
                boolean isCurrentController = currentState.m_60734_() instanceof IndexerControllerBlock;
                if (nextBlock instanceof IndexerPipeBlock) {
                    validSource = isCurrentController;
                    if (isCurrentPipe) {
                        validSource = (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction));
                    }
                    boolean nextPipeConnected = (Boolean)nextState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()));
                    if (!validSource || !nextPipeConnected) continue;
                    queue.add(nextPos);
                    visited.add(nextPos);
                    continue;
                }
                if (nextBlock instanceof IndexerConnectorBlock) {
                    BlockEntity nextEntity;
                    validSource = isCurrentController;
                    if (isCurrentPipe) {
                        validSource = (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction));
                    }
                    if (!validSource || !((nextEntity = this.f_58857_.m_7702_(nextPos)) instanceof IndexerConnectorBlockEntity)) continue;
                    connectors.add((IndexerConnectorBlockEntity)nextEntity);
                    visited.add(nextPos);
                    continue;
                }
                if (!(nextBlock instanceof IndexerControllerBlock)) continue;
                validSource = isCurrentController;
                if (isCurrentPipe) {
                    validSource = (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction));
                }
                if (!validSource) continue;
                queue.add(nextPos);
                visited.add(nextPos);
            }
        }
        this.connectorCache = connectors;
        this.networkChanged = false;
        return connectors;
    }

    public void markNetworkChanged() {
        this.networkChanged = true;
        this.connectorCache = null;
    }
}

