/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.menu;

import com.agustinbenitez.indexer.block.entity.DropBoxBlockEntity;
import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.init.ModMenuTypes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DropBoxMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;
    private final DropBoxBlockEntity dropBoxEntity;

    public DropBoxMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(54), (ContainerData)new SimpleContainerData(6), null);
    }

    public DropBoxMenu(int id, Inventory playerInventory, DropBoxBlockEntity dropBoxEntity) {
        this(id, playerInventory, (Container)dropBoxEntity, DropBoxMenu.createContainerData(dropBoxEntity), dropBoxEntity);
    }

    private DropBoxMenu(int id, Inventory playerInventory, Container container, ContainerData data, DropBoxBlockEntity dropBoxEntity) {
        super((MenuType)ModMenuTypes.DROP_BOX_MENU.get(), id);
        int col;
        int row;
        this.container = container;
        this.data = data;
        this.dropBoxEntity = dropBoxEntity;
        this.m_38884_(data);
        for (row = 0; row < 6; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot(container, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.m_38897_(new Slot((Container)playerInventory, col2, 8 + col2 * 18, 198));
        }
    }

    private static ContainerData createContainerData(final DropBoxBlockEntity dropBoxEntity) {
        return new ContainerData(){

            public int m_6413_(int index) {
                if (dropBoxEntity != null) {
                    IndexerControllerBlockEntity controller = dropBoxEntity.findConnectedController();
                    if (index == 5) {
                        return controller != null ? 1 : 0;
                    }
                    if (controller != null) {
                        switch (index) {
                            case 0: {
                                return controller.getOccupiedSlots();
                            }
                            case 1: {
                                return controller.getTotalCapacity();
                            }
                            case 2: {
                                return controller.getConnectedContainersCount();
                            }
                            case 3: {
                                return controller.isEnabled() ? 1 : 0;
                            }
                            case 4: {
                                return controller.getCurrentUpgradeLevel();
                            }
                        }
                    }
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
            }

            public int m_6499_() {
                return 6;
            }
        };
    }

    public int getOccupiedSlots() {
        return this.data.m_6413_(0);
    }

    public int getTotalCapacity() {
        return this.data.m_6413_(1);
    }

    public int getConnectedContainersCount() {
        return this.data.m_6413_(2);
    }

    public boolean isControllerConnected() {
        return this.data.m_6413_(5) == 1;
    }

    public boolean isControllerEnabled() {
        return this.data.m_6413_(3) == 1;
    }

    public int getUpgradeLevel() {
        return this.data.m_6413_(4);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 54 ? !this.m_38903_(itemstack1, 54, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 54, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public void transferAllItemsToDropBox(Player player) {
        for (int i = 54; i < this.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (!slot.m_6657_()) continue;
            ItemStack itemStack = slot.m_7993_();
            if (!this.m_38903_(itemStack, 0, 54, false)) break;
            if (itemStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
                continue;
            }
            slot.m_6654_();
        }
    }
}

