/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.menu;

import com.agustinbenitez.indexer.block.IndexerControllerBlock;
import com.agustinbenitez.indexer.block.IndexerPipeBlock;
import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.block.entity.IndexerManagerBlockEntity;
import com.agustinbenitez.indexer.init.ModMenuTypes;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class IndexerManagerMenu
extends AbstractContainerMenu {
    private final IndexerManagerBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int INVENTORY_START_X = 8;
    private static final int INVENTORY_START_Y = 104;
    private static final int HOTBAR_START_Y = 162;
    private static final int SLOT_SIZE = 18;
    private static final int MANAGER_GRID_START_X = 8;
    private static final int MANAGER_GRID_START_Y = 86;

    public IndexerManagerMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenuTypes.INDEXER_MANAGER_MENU.get(), id);
        int col;
        BlockEntity be = inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
        this.blockEntity = (IndexerManagerBlockEntity)be;
        this.level = inv.f_35978_.m_9236_();
        this.data = new SimpleContainerData(6);
        this.m_38884_(this.data);
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)this.blockEntity, col, 8 + col * 18, 86));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.m_38897_(new Slot((Container)inv, col2 + row * 9 + 9, 8 + col2 * 18, 104 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 162));
        }
    }

    public IndexerManagerMenu(int id, Inventory inv, BlockEntity entity) {
        super((MenuType)ModMenuTypes.INDEXER_MANAGER_MENU.get(), id);
        int col;
        this.blockEntity = (IndexerManagerBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = this.createContainerData();
        this.m_38884_(this.data);
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)this.blockEntity, col, 8 + col * 18, 86));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.m_38897_(new Slot((Container)inv, col2 + row * 9 + 9, 8 + col2 * 18, 104 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 162));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int invEnd;
            int managerSlots;
            ItemStack stackInSlot = slot.m_7993_();
            itemstack = stackInSlot.m_41777_();
            int invStart = managerSlots = 9;
            int hotbarStart = invEnd = invStart + 27;
            int hotbarEnd = hotbarStart + 9;
            if (index < managerSlots ? !this.m_38903_(stackInSlot, invStart, hotbarEnd, true) : !this.m_38903_(stackInSlot, 0, managerSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, stackInSlot);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return IndexerManagerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public IndexerManagerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    private ContainerData createContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                IndexerControllerBlockEntity controller = IndexerManagerMenu.this.findNearestController();
                if (index == 5) {
                    return controller != null ? 1 : 0;
                }
                if (controller != null) {
                    switch (index) {
                        case 0: {
                            return controller.getOccupiedSlots();
                        }
                        case 1: {
                            return controller.getTotalCapacity();
                        }
                        case 2: {
                            return controller.getConnectedContainersCount();
                        }
                        case 3: {
                            return controller.isEnabled() ? 1 : 0;
                        }
                        case 4: {
                            return controller.getCurrentUpgradeLevel();
                        }
                    }
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
            }

            public int m_6499_() {
                return 6;
            }
        };
    }

    private IndexerControllerBlockEntity findNearestController() {
        if (this.level == null) {
            return null;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        BlockPos origin = this.blockEntity.m_58899_();
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = origin.m_121945_(direction);
            BlockState adjacentState = this.level.m_8055_(adjacentPos);
            if (adjacentState.m_60734_() instanceof IndexerPipeBlock) {
                if (!((Boolean)adjacentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()))).booleanValue()) continue;
                queue.add(adjacentPos);
                visited.add(adjacentPos);
                continue;
            }
            if (!(adjacentState.m_60734_() instanceof IndexerControllerBlock)) continue;
            BlockEntity entity = this.level.m_7702_(adjacentPos);
            if (entity instanceof IndexerControllerBlockEntity) {
                return (IndexerControllerBlockEntity)entity;
            }
            visited.add(adjacentPos);
        }
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = this.level.m_8055_(currentPos);
            for (Direction direction : Direction.values()) {
                BlockPos nextPos = currentPos.m_121945_(direction);
                if (visited.contains(nextPos)) continue;
                BlockState nextState = this.level.m_8055_(nextPos);
                if (nextState.m_60734_() instanceof IndexerControllerBlock) {
                    BlockEntity entity = this.level.m_7702_(nextPos);
                    if (entity instanceof IndexerControllerBlockEntity) {
                        return (IndexerControllerBlockEntity)entity;
                    }
                    visited.add(nextPos);
                    continue;
                }
                if (!(nextState.m_60734_() instanceof IndexerPipeBlock)) continue;
                boolean currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                boolean nextPipeConnected = (Boolean)nextState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()));
                if (!currentPipeConnected || !nextPipeConnected) continue;
                queue.add(nextPos);
                visited.add(nextPos);
            }
        }
        return null;
    }

    public int getOccupiedSlots() {
        return this.data.m_6413_(0);
    }

    public int getTotalCapacity() {
        return this.data.m_6413_(1);
    }

    public int getConnectedContainersCount() {
        return this.data.m_6413_(2);
    }

    public boolean isControllerEnabled() {
        return this.data.m_6413_(3) == 1;
    }

    public int getUpgradeLevel() {
        return this.data.m_6413_(4);
    }

    public boolean isControllerConnected() {
        return this.data.m_6413_(5) == 1;
    }
}

