/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.network;

import com.agustinbenitez.indexer.block.entity.IndexerManagerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ExtractItemFromManagerPacket {
    private final BlockPos managerPos;
    private final ResourceLocation itemId;
    private final int count;
    private final ItemStack variantStack;

    public ExtractItemFromManagerPacket(BlockPos managerPos, ResourceLocation itemId, int count, ItemStack variantStack) {
        this.managerPos = managerPos;
        this.itemId = itemId;
        this.count = count;
        this.variantStack = variantStack.m_41777_();
        this.variantStack.m_41764_(1);
    }

    public ExtractItemFromManagerPacket(FriendlyByteBuf buf) {
        this.managerPos = buf.m_130135_();
        this.itemId = buf.m_130281_();
        this.count = buf.readInt();
        this.variantStack = buf.m_130267_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.managerPos);
        buf.m_130085_(this.itemId);
        buf.writeInt(this.count);
        buf.m_130055_(this.variantStack);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity be;
            ServerPlayer player = context.getSender();
            if (player != null && (be = player.m_9236_().m_7702_(this.managerPos)) instanceof IndexerManagerBlockEntity) {
                IndexerManagerBlockEntity manager = (IndexerManagerBlockEntity)be;
                int moved = manager.extractImmediately(this.itemId, this.count, this.variantStack);
                int remaining = Math.max(0, this.count - moved);
                if (remaining > 0 && !manager.isInventoryFull()) {
                    manager.queueExtraction(this.itemId, remaining, this.variantStack);
                }
                manager.sendItemsTo(player);
            }
        });
        return true;
    }
}

