/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.network;

import com.agustinbenitez.indexer.screen.IndexerManagerScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ManagerItemsUpdatePacket {
    private final List<Entry> entries;

    public ManagerItemsUpdatePacket(List<Entry> entries) {
        this.entries = new ArrayList<Entry>(entries);
    }

    public ManagerItemsUpdatePacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.entries = new ArrayList<Entry>(size);
        for (int i = 0; i < size; ++i) {
            ItemStack s = buf.m_130267_();
            int c = buf.readInt();
            boolean p = buf.readBoolean();
            this.entries.add(new Entry(s, c, p));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entries.size());
        for (Entry e : this.entries) {
            buf.m_130055_(e.stackVariant);
            buf.writeInt(e.count);
            buf.writeBoolean(e.pending);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            Screen patt1915$temp = mc.f_91080_;
            if (patt1915$temp instanceof IndexerManagerScreen) {
                IndexerManagerScreen screen = (IndexerManagerScreen)patt1915$temp;
                screen.updateItemListFromServer(this.entries);
            }
        }));
        return true;
    }

    public static class Entry {
        public final ItemStack stackVariant;
        public final int count;
        public final boolean pending;

        public Entry(ItemStack s, int c, boolean p) {
            this.stackVariant = s;
            this.count = c;
            this.pending = p;
        }
    }
}

