/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.network;

import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.network.ContainerListUpdatePacket;
import com.agustinbenitez.indexer.network.ModNetworking;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class RefreshNetworkPacket {
    private final BlockPos controllerPos;

    public RefreshNetworkPacket(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    public RefreshNetworkPacket(FriendlyByteBuf buf) {
        this.controllerPos = buf.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.controllerPos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = context.getSender();
            if (player != null && (blockEntity = player.m_9236_().m_7702_(this.controllerPos)) instanceof IndexerControllerBlockEntity) {
                IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
                controller.forceNetworkRefresh();
                List<IndexerControllerBlockEntity.ContainerNetworkInfo> containers = controller.getNetworkContainers();
                ModNetworking.sendToPlayer(new ContainerListUpdatePacket(containers), player);
            }
        });
        return true;
    }
}

