/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.screen;

import com.agustinbenitez.indexer.init.ModItems;
import com.agustinbenitez.indexer.menu.DropBoxMenu;
import com.agustinbenitez.indexer.network.ModNetworking;
import com.agustinbenitez.indexer.network.TransferAllItemsPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DropBoxScreen
extends AbstractContainerScreen<DropBoxMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("indexer", "textures/gui/drop_box.png");
    private Button transferAllButton;
    private static final int STATS_PANEL_WIDTH = 100;
    private static final int STATS_PANEL_HEIGHT = 166;

    public DropBoxScreen(DropBoxMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 276;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonX = this.f_97735_ + 157;
        int buttonY = this.f_97736_ + 125;
        this.transferAllButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2191"), button -> ModNetworking.sendToServer(new TransferAllItemsPacket())).m_252987_(buttonX, buttonY, 12, 12).m_253136_();
        this.m_142416_((GuiEventListener)this.transferAllButton);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, 176, 222);
        int statsX = this.f_97735_ + 176;
        guiGraphics.m_280509_(statsX, this.f_97736_, statsX + 100, this.f_97736_ + 166, -1072689136);
        this.renderStats(guiGraphics, mouseX, mouseY);
    }

    private void renderStats(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack upgradeItem;
        int statsX = this.f_97735_ + 176 + 6;
        int statsY = this.f_97736_ + 8;
        MutableComponent statsTitle = Component.m_237115_((String)"gui.indexer.stats");
        guiGraphics.m_280614_(this.f_96547_, (Component)statsTitle, statsX, statsY, 0xFFFFFF, false);
        if (!((DropBoxMenu)this.f_97732_).isControllerConnected()) {
            MutableComponent errorText = Component.m_237115_((String)"gui.indexer.manager.controller_not_found");
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)errorText, statsX, statsY += 20, 88, 0xFF5555);
            int areaX = this.f_97735_ + 8;
            int areaW = 160;
            int areaY = this.f_97736_ + 24;
            int textWidth = this.f_96547_.m_92852_((FormattedText)errorText);
            int tx = areaX + (areaW - textWidth) / 2;
            int ty = areaY + 20;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            guiGraphics.m_280614_(this.f_96547_, (Component)errorText, tx, ty, 0xFF5555, false);
            guiGraphics.m_280168_().m_85849_();
            return;
        }
        int occupiedSlots = ((DropBoxMenu)this.f_97732_).getOccupiedSlots();
        int totalCapacity = ((DropBoxMenu)this.f_97732_).getTotalCapacity();
        int connectedContainers = ((DropBoxMenu)this.f_97732_).getConnectedContainersCount();
        int upgradeLevel = ((DropBoxMenu)this.f_97732_).getUpgradeLevel();
        statsY += 15;
        MutableComponent speedText = Component.m_237113_((String)("Speed: " + (switch (upgradeLevel) {
            case 1 -> "x5";
            case 2 -> "x10";
            case 3 -> "x20";
            case 4 -> "x64";
            case 5 -> "x256";
            default -> "x1";
        })));
        int speedColor = upgradeLevel > 0 ? 0x55FF55 : 0xCCCCCC;
        guiGraphics.m_280614_(this.f_96547_, (Component)speedText, statsX, statsY, speedColor, false);
        if (upgradeLevel > 0 && !(upgradeItem = this.getUpgradeItemForLevel(upgradeLevel)).m_41619_()) {
            int textWidth = this.f_96547_.m_92895_(speedText.getString());
            guiGraphics.m_280480_(upgradeItem, statsX + textWidth + 6, statsY - 2);
        }
        MutableComponent capacityTitle = Component.m_237115_((String)"gui.indexer.capacity");
        guiGraphics.m_280614_(this.f_96547_, (Component)capacityTitle, statsX, statsY += 20, 0xFFFFFF, false);
        int barWidth = 88;
        int barHeight = 6;
        guiGraphics.m_280509_(statsX, statsY += 12, statsX + barWidth, statsY + barHeight, -13421773);
        if (totalCapacity > 0) {
            float fillPercentage = (float)occupiedSlots / (float)totalCapacity;
            int fillWidth = (int)((float)barWidth * fillPercentage);
            int barColor = fillPercentage < 0.5f ? -11141291 : (fillPercentage < 0.8f ? -22016 : -43691);
            guiGraphics.m_280509_(statsX, statsY, statsX + fillWidth, statsY + barHeight, barColor);
        }
        statsY += 10;
        String capacityText = occupiedSlots + " / " + totalCapacity;
        if (totalCapacity > 0) {
            int percentage = (int)((float)occupiedSlots / (float)totalCapacity * 100.0f);
            capacityText = capacityText + " (" + percentage + "%)";
        }
        guiGraphics.m_280056_(this.f_96547_, capacityText, statsX, statsY, 0xCCCCCC, false);
        MutableComponent containersTitle = Component.m_237115_((String)"gui.indexer.connected_containers");
        guiGraphics.m_280614_(this.f_96547_, (Component)containersTitle, statsX, statsY += 20, 0xFFFFFF, false);
        MutableComponent containersCount = Component.m_237113_((String)String.valueOf(connectedContainers));
        guiGraphics.m_280614_(this.f_96547_, (Component)containersCount, statsX, statsY += 12, 0xCCCCCC, false);
    }

    private ItemStack getUpgradeItemForLevel(int level) {
        switch (level) {
            case 0: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_ZERO.get());
            }
            case 1: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_BASIC.get());
            }
            case 2: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_COPPER.get());
            }
            case 3: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_ADVANCED.get());
            }
            case 4: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_ELITE.get());
            }
            case 5: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_DEFINITIVE.get());
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 96 + 2, 0x404040, false);
    }
}

