/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.screen;

import com.agustinbenitez.indexer.init.ModItems;
import com.agustinbenitez.indexer.menu.IndexerControllerNetworkMenu;
import com.agustinbenitez.indexer.network.ContainerListUpdatePacket;
import com.agustinbenitez.indexer.network.ModNetworking;
import com.agustinbenitez.indexer.network.RefreshNetworkPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class IndexerControllerNetworkScreen
extends AbstractContainerScreen<IndexerControllerNetworkMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("indexer", "textures/gui/indexer_controller_network_gui.png");
    private static final int GUI_WIDTH = 400;
    private static final int GUI_HEIGHT = 240;
    private static final int LEFT_PANEL_X = 8;
    private static final int LEFT_PANEL_Y = 20;
    private static final int LEFT_PANEL_WIDTH = 180;
    private static final int LEFT_PANEL_HEIGHT = 200;
    private static final int RIGHT_PANEL_X = 200;
    private static final int RIGHT_PANEL_Y = 20;
    private static final int RIGHT_PANEL_WIDTH = 180;
    private static final int RIGHT_PANEL_HEIGHT = 200;
    private List<ContainerInfo> containerList = new ArrayList<ContainerInfo>();
    private int totalNetworkItems = 0;
    private int totalUniqueTypes = 0;
    private float averageFillPercentage = 0.0f;
    private String topItemName = "";
    private int topItemCount = 0;
    private int scrollOffset = 0;
    private int maxVisibleContainers = 5;
    private ContainerInfo selectedContainer = null;
    private boolean showDetailedView = false;
    private ContainerInfo detailedContainer = null;
    private int detailedItemsAreaX = 0;
    private int detailedItemsAreaY = 0;
    private int detailedItemsAreaWidth = 0;
    private int detailedItemsAreaHeight = 0;
    private int detailedItemsScrollRowOffset = 0;
    private EditBox searchBox;
    private String searchFilter = "";
    private boolean draggingLeftScrollbar = false;
    private boolean draggingDetailScrollbar = false;
    private boolean isLoading = false;

    public IndexerControllerNetworkScreen(IndexerControllerNetworkMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 400;
        this.f_97727_ = 240;
        this.f_97731_ = this.f_97727_ - 10;
        this.refreshNetwork();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.showDetailedView && keyCode == 256) {
            this.showDetailedView = false;
            this.detailedContainer = null;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7856_() {
        super.m_7856_();
        int leftX = (this.f_96543_ - this.f_97726_) / 2;
        int topY = (this.f_96544_ - this.f_97727_) / 2;
        this.searchBox = new EditBox(this.f_96547_, leftX + 8 + 2, topY + 20 - 15, 176, 12, (Component)Component.m_237115_((String)"gui.indexer.controller.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94151_(this::onSearchChanged);
        this.m_7787_((GuiEventListener)this.searchBox);
    }

    private void onSearchChanged(String search) {
        this.searchFilter = search.toLowerCase();
        this.scrollOffset = 0;
    }

    private void refreshNetwork() {
        ModNetworking.sendToServer(new RefreshNetworkPacket(((IndexerControllerNetworkMenu)this.f_97732_).getBlockEntity().m_58899_()));
        this.updateContainerList();
    }

    private void updateContainerList() {
        this.isLoading = true;
        this.containerList.clear();
        ModNetworking.sendToServer(new RefreshNetworkPacket(((IndexerControllerNetworkMenu)this.f_97732_).getBlockEntity().m_58899_()));
    }

    public void updateContainerListFromServer(List<ContainerListUpdatePacket.ContainerData> serverContainers) {
        this.containerList.clear();
        for (ContainerListUpdatePacket.ContainerData serverContainer : serverContainers) {
            ContainerInfo info = new ContainerInfo();
            info.position = serverContainer.position;
            info.containerType = serverContainer.containerType;
            info.itemCount = serverContainer.itemCount;
            info.maxSlots = serverContainer.maxSlots;
            info.filters = new ArrayList<ItemStack>(serverContainer.filters);
            info.uniqueItems = new HashMap<String, Integer>(serverContainer.uniqueItems);
            this.containerList.add(info);
        }
        this.recalculateStats();
        this.isLoading = false;
    }

    private void recalculateStats() {
        this.totalNetworkItems = 0;
        HashSet<String> uniqueTypes = new HashSet<String>();
        HashMap itemCounts = new HashMap();
        float totalFill = 0.0f;
        int filledContainers = 0;
        for (ContainerInfo containerInfo : this.containerList) {
            this.totalNetworkItems += containerInfo.itemCount;
            uniqueTypes.addAll(containerInfo.uniqueItems.keySet());
            containerInfo.uniqueItems.forEach((k, v) -> itemCounts.merge(k, v, Integer::sum));
            if (containerInfo.maxSlots <= 0) continue;
            totalFill += (float)containerInfo.itemCount / (float)containerInfo.maxSlots;
            ++filledContainers;
        }
        this.totalUniqueTypes = uniqueTypes.size();
        this.averageFillPercentage = filledContainers > 0 ? totalFill / (float)filledContainers * 100.0f : 0.0f;
        this.topItemCount = 0;
        this.topItemName = "";
        for (Map.Entry entry : itemCounts.entrySet()) {
            if ((Integer)entry.getValue() <= this.topItemCount) continue;
            this.topItemCount = (Integer)entry.getValue();
            this.topItemName = (String)entry.getKey();
        }
    }

    private String getRandomContainerType() {
        String[] types = new String[]{"Chest", "Barrel", "Furnace", "Blast Furnace", "Smoker", "Hopper"};
        return types[(int)(Math.random() * (double)types.length)];
    }

    private int getMaxSlotsForType(String type) {
        return switch (type) {
            case "Chest", "Barrel" -> 27;
            case "Furnace", "Blast Furnace", "Smoker" -> 3;
            case "Hopper" -> 5;
            default -> 27;
        };
    }

    private List<ItemStack> generateRandomFilters() {
        ArrayList<ItemStack> filters = new ArrayList<ItemStack>();
        ItemStack[] possibleItems = new ItemStack[]{new ItemStack((ItemLike)Items.f_42416_), new ItemStack((ItemLike)Items.f_42417_), new ItemStack((ItemLike)Items.f_42415_), new ItemStack((ItemLike)Items.f_42413_), new ItemStack((ItemLike)Items.f_42451_)};
        int filterCount = (int)(Math.random() * 3.0);
        for (int i = 0; i < filterCount; ++i) {
            filters.add(possibleItems[(int)(Math.random() * (double)possibleItems.length)]);
        }
        return filters;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280509_(x, y, x + this.f_97726_, y + this.f_97727_, -13816528);
        guiGraphics.m_280509_(x, y, x + this.f_97726_, y + 2, -14803426);
        guiGraphics.m_280509_(x, y + this.f_97727_ - 2, x + this.f_97726_, y + this.f_97727_, -14803426);
        guiGraphics.m_280509_(x, y, x + 2, y + this.f_97727_, -14803426);
        guiGraphics.m_280509_(x + this.f_97726_ - 2, y, x + this.f_97726_, y + this.f_97727_, -14803426);
        guiGraphics.m_280509_(x + 8, y + 20, x + 8 + 180, y + 20 + 200, -14803426);
        guiGraphics.m_280509_(x + 8, y + 20, x + 8 + 180, y + 20 + 1, -12566464);
        guiGraphics.m_280509_(x + 8, y + 20 + 200 - 1, x + 8 + 180, y + 20 + 200, -12566464);
        guiGraphics.m_280509_(x + 8, y + 20, x + 8 + 1, y + 20 + 200, -12566464);
        guiGraphics.m_280509_(x + 8 + 180 - 1, y + 20, x + 8 + 180, y + 20 + 200, -12566464);
        guiGraphics.m_280509_(x + 200, y + 20, x + 200 + 180, y + 20 + 200, -14803426);
        guiGraphics.m_280509_(x + 200, y + 20, x + 200 + 180, y + 20 + 1, -12566464);
        guiGraphics.m_280509_(x + 200, y + 20 + 200 - 1, x + 200 + 180, y + 20 + 200, -12566464);
        guiGraphics.m_280509_(x + 200, y + 20, x + 200 + 1, y + 20 + 200, -12566464);
        guiGraphics.m_280509_(x + 200 + 180 - 1, y + 20, x + 200 + 180, y + 20 + 200, -12566464);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        int titleX = (this.f_97726_ - titleWidth) / 2;
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, titleX, this.f_97727_ - 15, 0xFFFFFF, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.indexer.controller.containers"), 13, 10, 0xCCCCCC, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.indexer.controller.network_stats"), 205, 10, 0xCCCCCC, false);
        this.renderContainerList(guiGraphics, mouseX, mouseY);
        if (!this.showDetailedView) {
            this.renderNetworkStats(guiGraphics);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.searchBox.f_93624_ = !this.showDetailedView;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.showDetailedView) {
            this.m_280072_(guiGraphics, mouseX, mouseY);
        }
        if (this.showDetailedView && this.detailedContainer != null) {
            this.renderDetailedView(guiGraphics, mouseX, mouseY);
        }
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!this.showDetailedView) {
            super.m_280072_(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderContainerList(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int index;
        if (this.isLoading) {
            int centerX = 98;
            int centerY = 120;
            guiGraphics.m_280509_(10, 22, 186, 218, Integer.MIN_VALUE);
            long time = System.currentTimeMillis() / 200L;
            String[] spinnerChars = new String[]{"|", "/", "-", "\\"};
            String spinner = spinnerChars[(int)(time % 4L)];
            String loadingText = Component.m_237115_((String)"gui.indexer.controller.updating").getString() + " " + spinner;
            int textWidth = this.f_96547_.m_92895_(loadingText);
            guiGraphics.m_280056_(this.f_96547_, loadingText, centerX - textWidth / 2, centerY - 4, 0xFFFFFF, false);
            return;
        }
        List<ContainerInfo> filteredContainers = this.getFilteredContainers();
        int startY = 25;
        int itemHeight = 35;
        for (int i = 0; i < Math.min(this.maxVisibleContainers, filteredContainers.size() - this.scrollOffset) && (index = i + this.scrollOffset) < filteredContainers.size(); ++i) {
            boolean isHovered;
            ContainerInfo container = filteredContainers.get(index);
            int itemY = startY + i * itemHeight;
            boolean bl = isHovered = mouseX >= 8 && mouseX <= 180 && mouseY >= itemY && mouseY <= itemY + itemHeight - 5;
            if (isHovered && !this.showDetailedView) {
                guiGraphics.m_280509_(10, itemY, 168, itemY + itemHeight - 5, -11184811);
                if (container.uniqueItems != null && !container.uniqueItems.isEmpty()) {
                    this.renderContainerPreviewOverlay(guiGraphics, container, itemY, mouseX, mouseY);
                }
            }
            String posText = container.position.m_123341_() + ", " + container.position.m_123342_() + ", " + container.position.m_123343_();
            guiGraphics.m_280056_(this.f_96547_, posText, 13, itemY + 2, 0xCCCCCC, false);
            String translatedType = this.getTranslatedContainerType(container.containerType);
            String typeText = translatedType + " (" + container.itemCount + "/" + container.maxSlots + ")";
            guiGraphics.m_280056_(this.f_96547_, typeText, 13, itemY + 12, 0xAAAAAA, false);
            if (!this.showDetailedView) {
                ItemStack typeIcon = this.getContainerTypeIcon(container.containerType);
                int iconSize = 16;
                int iconX = 168 - iconSize;
                int iconY = itemY + 6;
                guiGraphics.m_280509_(iconX - 1, iconY - 1, iconX + iconSize + 1, iconY + iconSize + 1, -15066598);
                guiGraphics.m_280509_(iconX, iconY, iconX + iconSize, iconY + iconSize, -13816528);
                if (!typeIcon.m_41619_()) {
                    guiGraphics.m_280480_(typeIcon, iconX, iconY);
                } else {
                    String q = "?";
                    int tw = this.f_96547_.m_92895_(q);
                    int tx = iconX + (iconSize - tw) / 2;
                    int ty = iconY + 4;
                    guiGraphics.m_280056_(this.f_96547_, q, tx, ty, 0xFFFFFF, false);
                }
            }
            if (!this.showDetailedView) {
                String filtersLabel = Component.m_237115_((String)"gui.indexer.controller.filters").getString();
                guiGraphics.m_280056_(this.f_96547_, filtersLabel, 13, itemY + 22, 0x999999, false);
                if (!container.filters.isEmpty()) {
                    int filterX = 13 + this.f_96547_.m_92895_(filtersLabel) + 3;
                    int filterY = itemY + 22;
                    int maxFilters = 4;
                    int filterSpacing = 12;
                    for (int f = 0; f < Math.min(container.filters.size(), maxFilters); ++f) {
                        ItemStack filter = container.filters.get(f);
                        if (filter.m_41619_()) continue;
                        guiGraphics.m_280168_().m_85836_();
                        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                        guiGraphics.m_280480_(filter, (int)((float)(filterX + f * filterSpacing) / 0.5f), (int)((float)(filterY - 2) / 0.5f));
                        guiGraphics.m_280168_().m_85849_();
                    }
                    if (container.filters.size() > maxFilters) {
                        guiGraphics.m_280056_(this.f_96547_, "...", filterX + maxFilters * filterSpacing, filterY, 0xAAAAAA, false);
                    }
                } else {
                    String noFiltersText = Component.m_237115_((String)"gui.indexer.controller.no_filters").getString();
                    int noFiltersX = 13 + this.f_96547_.m_92895_(filtersLabel) + 3;
                    guiGraphics.m_280056_(this.f_96547_, noFiltersText, noFiltersX, itemY + 22, 0x666666, false);
                }
            }
            if (i >= Math.min(this.maxVisibleContainers, filteredContainers.size() - this.scrollOffset) - 1 || index >= filteredContainers.size() - 1) continue;
            int separatorY = itemY + itemHeight - 3;
            guiGraphics.m_280509_(13, separatorY, 163, separatorY + 1, -12303292);
        }
        if (filteredContainers.size() > this.maxVisibleContainers) {
            this.renderScrollbar(guiGraphics, filteredContainers.size());
        }
    }

    private void renderContainerPreviewOverlay(GuiGraphics guiGraphics, ContainerInfo container, int baseItemY, int mouseX, int mouseY) {
        boolean hasMoreItems;
        int overlayWidth = 140;
        int itemsPerRow = 4;
        int itemSize = 16;
        int itemSpacing = 22;
        int headerHeight = 16;
        int padding = 8;
        int maxItems = itemsPerRow * 2;
        int shownItems = Math.min(container.uniqueItems.size(), maxItems);
        int rows = Math.max(1, (int)Math.ceil((float)shownItems / (float)itemsPerRow));
        int overlayHeight = padding * 2 + headerHeight + rows * itemSpacing;
        int overlayX = 188 - overlayWidth - 12;
        int overlayY = baseItemY - 4;
        int maxY = 220 - overlayHeight - 4;
        if (overlayY > maxY) {
            overlayY = maxY;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
        guiGraphics.m_280509_(overlayX, overlayY, overlayX + overlayWidth, overlayY + overlayHeight, -869454544);
        guiGraphics.m_280509_(overlayX, overlayY, overlayX + overlayWidth, overlayY + 1, -12566464);
        guiGraphics.m_280509_(overlayX, overlayY + overlayHeight - 1, overlayX + overlayWidth, overlayY + overlayHeight, -12566464);
        guiGraphics.m_280509_(overlayX, overlayY, overlayX + 1, overlayY + overlayHeight, -12566464);
        guiGraphics.m_280509_(overlayX + overlayWidth - 1, overlayY, overlayX + overlayWidth, overlayY + overlayHeight, -12566464);
        MutableComponent itemsTitle = Component.m_237115_((String)"gui.indexer.controller.detailed_view.items");
        int titleWidth = this.f_96547_.m_92852_((FormattedText)itemsTitle);
        guiGraphics.m_280614_(this.f_96547_, (Component)itemsTitle, overlayX + (overlayWidth - titleWidth) / 2, overlayY + 4, 0xFFFFFF, false);
        if (container.uniqueItems.isEmpty()) {
            String emptyText = Component.m_237115_((String)"gui.indexer.controller.container_empty").getString();
            int emptyWidth = this.f_96547_.m_92895_(emptyText);
            guiGraphics.m_280056_(this.f_96547_, emptyText, overlayX + (overlayWidth - emptyWidth) / 2, overlayY + headerHeight + padding, 0xAAAAAA, false);
            guiGraphics.m_280168_().m_85849_();
            return;
        }
        List<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(container.uniqueItems.entrySet());
        entries.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
        boolean bl = hasMoreItems = entries.size() > maxItems;
        if (hasMoreItems) {
            entries = entries.subList(0, maxItems);
        }
        int gridX = overlayX + padding;
        int gridY = overlayY + headerHeight + padding;
        int index = 0;
        for (Map.Entry<String, Integer> entry : entries) {
            int row = index / itemsPerRow;
            int col = index % itemsPerRow;
            int itemX = gridX + col * itemSpacing;
            int itemY = gridY + row * itemSpacing;
            guiGraphics.m_280509_(itemX - 1, itemY - 1, itemX + itemSize + 1, itemY + itemSize + 1, -15066598);
            guiGraphics.m_280509_(itemX, itemY, itemX + itemSize, itemY + itemSize, -13816528);
            ItemStack displayItem = this.createItemStackFromName(entry.getKey());
            if (!displayItem.m_41619_()) {
                guiGraphics.m_280480_(displayItem, itemX, itemY);
                String qty = this.formatNumber(entry.getValue());
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                guiGraphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
                float scaledX = (float)(itemX + itemSize - 2) / 0.7f;
                float scaledY = (float)(itemY + itemSize - 6) / 0.7f;
                guiGraphics.m_280056_(this.f_96547_, qty, (int)scaledX - this.f_96547_.m_92895_(qty), (int)scaledY, 0xFFFFFF, true);
                guiGraphics.m_280168_().m_85849_();
                if (mouseX >= itemX && mouseX < itemX + itemSize && mouseY >= itemY && mouseY < itemY + itemSize) {
                    ArrayList<Object> tooltip = new ArrayList<Object>();
                    tooltip.add(displayItem.m_41786_());
                    tooltip.add(Component.m_237113_((String)("Cantidad: " + this.formatNumber(entry.getValue()))));
                    guiGraphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
                }
            }
            ++index;
        }
        if (hasMoreItems) {
            String moreText = "...";
            int moreWidth = this.f_96547_.m_92895_(moreText);
            guiGraphics.m_280056_(this.f_96547_, moreText, overlayX + overlayWidth - padding - moreWidth, overlayY + overlayHeight - padding - 9, 0xAAAAAA, false);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderScrollbar(GuiGraphics guiGraphics, int totalItems) {
        int scrollbarX = 182;
        int scrollbarY = 25;
        int scrollbarHeight = 190;
        guiGraphics.m_280509_(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, -3355444);
        int thumbHeight = Math.max(10, this.maxVisibleContainers * scrollbarHeight / totalItems);
        int thumbY = scrollbarY + this.scrollOffset * (scrollbarHeight - thumbHeight) / (totalItems - this.maxVisibleContainers);
        guiGraphics.m_280509_(scrollbarX + 1, thumbY, scrollbarX + 5, thumbY + thumbHeight, -7829368);
    }

    private void renderNetworkStats(GuiGraphics guiGraphics) {
        ItemStack upgradeItem;
        int startX = 210;
        int startY = 30;
        int lineHeight = 12;
        int currentY = startY;
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.indexer.controller.network_summary"), startX, currentY, 0xCCCCCC, false);
        String containersText = Component.m_237115_((String)"gui.indexer.controller.containers").getString() + ": " + ((IndexerControllerNetworkMenu)this.f_97732_).getConnectedContainersCount();
        guiGraphics.m_280056_(this.f_96547_, containersText, startX, currentY += lineHeight + 2, 0xFFFFFF, false);
        String itemsText = Component.m_237115_((String)"gui.indexer.controller.total_items").getString() + ": " + this.formatNumber(this.totalNetworkItems);
        guiGraphics.m_280056_(this.f_96547_, itemsText, startX, currentY += lineHeight, 0xFFFFFF, false);
        String typesText = Component.m_237115_((String)"gui.indexer.controller.unique_types").getString() + ": " + this.formatNumber(this.totalUniqueTypes);
        guiGraphics.m_280056_(this.f_96547_, typesText, startX, currentY += lineHeight, 0xFFFFFF, false);
        currentY += lineHeight + 8;
        if (!this.topItemName.isEmpty()) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.indexer.controller.top_stock"), startX, currentY, 0xCCCCCC, false);
            currentY += lineHeight + 2;
            ItemStack topStack = this.createItemStackFromName(this.topItemName);
            if (!topStack.m_41619_()) {
                guiGraphics.m_280480_(topStack, startX, currentY);
                Object name = topStack.m_41786_().getString();
                if (((String)name).length() > 18) {
                    name = ((String)name).substring(0, 15) + "...";
                }
                guiGraphics.m_280056_(this.f_96547_, (String)name, startX + 20, currentY, 0xFFFFFF, false);
                guiGraphics.m_280056_(this.f_96547_, this.formatNumber(this.topItemCount), startX + 20, currentY + 9, 0xAAAAAA, false);
                currentY += 20;
            } else {
                currentY += lineHeight;
            }
            currentY += 8;
        }
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.indexer.controller.efficiency"), startX, currentY, 0xCCCCCC, false);
        String fillText = Component.m_237115_((String)"gui.indexer.controller.avg_fill").getString() + ": ";
        int fillTextWidth = this.f_96547_.m_92895_(fillText);
        guiGraphics.m_280056_(this.f_96547_, fillText, startX, currentY += lineHeight + 2, 0xFFFFFF, false);
        String pctText = String.format("%.1f%%", Float.valueOf(this.averageFillPercentage));
        int color = this.averageFillPercentage > 80.0f ? -12255420 : (this.averageFillPercentage > 50.0f ? -22016 : -48060);
        guiGraphics.m_280056_(this.f_96547_, pctText, startX + fillTextWidth, currentY, color, false);
        int upgradeLevel = ((IndexerControllerNetworkMenu)this.f_97732_).getCurrentUpgradeLevel();
        String transferRateText = Component.m_237115_((String)"gui.indexer.controller.speed").getString() + ": " + ((IndexerControllerNetworkMenu)this.f_97732_).getItemsPerTransfer() + "/t";
        guiGraphics.m_280056_(this.f_96547_, transferRateText, startX, currentY += lineHeight + 8, 65280, false);
        if (upgradeLevel > 0 && !(upgradeItem = this.getUpgradeItemForLevel(upgradeLevel)).m_41619_()) {
            int textWidth = this.f_96547_.m_92895_(transferRateText);
            guiGraphics.m_280480_(upgradeItem, startX + 5 + textWidth, currentY - 4);
        }
    }

    private void renderDetailedView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE);
        int panelWidth = 320;
        int panelHeight = 220;
        int panelX = (this.f_96543_ - panelWidth) / 2 - 30;
        int panelY = (this.f_96544_ - panelHeight) / 2;
        guiGraphics.m_280509_(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -13816528);
        guiGraphics.m_280509_(panelX, panelY, panelX + panelWidth, panelY + 1, -12566464);
        guiGraphics.m_280509_(panelX, panelY + panelHeight - 1, panelX + panelWidth, panelY + panelHeight, -12566464);
        guiGraphics.m_280509_(panelX, panelY, panelX + 1, panelY + panelHeight, -12566464);
        guiGraphics.m_280509_(panelX + panelWidth - 1, panelY, panelX + panelWidth, panelY + panelHeight, -12566464);
        MutableComponent title = Component.m_237115_((String)"gui.indexer.controller.detailed_view.title");
        int titleWidth = this.f_96547_.m_92852_((FormattedText)title);
        guiGraphics.m_280614_(this.f_96547_, (Component)title, panelX + (panelWidth - titleWidth) / 2, panelY + 8, 0xFFFFFF, false);
        int yOffset = panelY + 25;
        MutableComponent posText = Component.m_237115_((String)"gui.indexer.controller.detailed_view.position").m_130946_(" " + this.detailedContainer.position.m_123341_() + ", " + this.detailedContainer.position.m_123342_() + ", " + this.detailedContainer.position.m_123343_());
        guiGraphics.m_280614_(this.f_96547_, (Component)posText, panelX + 10, yOffset, 0xCCCCCC, false);
        String translatedType = this.getTranslatedContainerType(this.detailedContainer.containerType);
        MutableComponent typeText = Component.m_237115_((String)"gui.indexer.controller.detailed_view.type").m_130946_(" " + translatedType);
        guiGraphics.m_280614_(this.f_96547_, (Component)typeText, panelX + 10, yOffset += 12, 0xCCCCCC, false);
        MutableComponent capacityText = Component.m_237115_((String)"gui.indexer.controller.detailed_view.capacity").m_130946_(" " + this.detailedContainer.itemCount + "/" + this.detailedContainer.maxSlots + " slots");
        guiGraphics.m_280614_(this.f_96547_, (Component)capacityText, panelX + 10, yOffset += 12, 0xCCCCCC, false);
        float fillPercentage = this.detailedContainer.maxSlots > 0 ? (float)this.detailedContainer.itemCount / (float)this.detailedContainer.maxSlots * 100.0f : 0.0f;
        MutableComponent fillText = Component.m_237115_((String)"gui.indexer.controller.detailed_view.filled").m_130946_(String.format(" %.1f%%", Float.valueOf(fillPercentage)));
        int fillColor = fillPercentage > 80.0f ? -48060 : (fillPercentage > 50.0f ? -22016 : -12255420);
        guiGraphics.m_280614_(this.f_96547_, (Component)fillText, panelX + 10, yOffset += 12, fillColor, false);
        int barWidth = panelWidth - 20;
        int barHeight = 6;
        int barX = panelX + 10;
        int barY = yOffset += 12;
        guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -12303292);
        int fillWidth = (int)((float)barWidth * fillPercentage / 100.0f);
        if (fillWidth > 0) {
            guiGraphics.m_280509_(barX, barY, barX + fillWidth, barY + barHeight, fillColor);
        }
        MutableComponent filtersText = Component.m_237115_((String)"gui.indexer.controller.detailed_view.filters");
        guiGraphics.m_280614_(this.f_96547_, (Component)filtersText, panelX + 10, yOffset += 20, 0xFFFFFF, false);
        yOffset += 15;
        if (this.detailedContainer.filters.isEmpty()) {
            guiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.indexer.controller.no_filters_configured").getString(), panelX + 10, yOffset, 0x888888, false);
        } else {
            int filterX = panelX + 10;
            int filterY = yOffset;
            int filterSize = 16;
            int filterSpacing = 20;
            int filtersPerRow = (panelWidth - 20) / filterSpacing;
            for (int i = 0; i < this.detailedContainer.filters.size(); ++i) {
                ItemStack filter = this.detailedContainer.filters.get(i);
                if (filter.m_41619_()) continue;
                int row = i / filtersPerRow;
                int col = i % filtersPerRow;
                int itemX = filterX + col * filterSpacing;
                int itemY = filterY + row * filterSpacing;
                guiGraphics.m_280509_(itemX - 1, itemY - 1, itemX + filterSize + 1, itemY + filterSize + 1, -15066598);
                guiGraphics.m_280509_(itemX, itemY, itemX + filterSize, itemY + filterSize, -13816528);
                guiGraphics.m_280480_(filter, itemX, itemY);
                if (mouseX < itemX || mouseX >= itemX + filterSize || mouseY < itemY || mouseY >= itemY + filterSize) continue;
                guiGraphics.m_280153_(this.f_96547_, filter, mouseX, mouseY);
            }
        }
        MutableComponent itemsText = Component.m_237115_((String)"gui.indexer.controller.detailed_view.items");
        guiGraphics.m_280614_(this.f_96547_, (Component)itemsText, panelX + 10, yOffset += 40, 0xFFFFFF, false);
        yOffset += 15;
        if (this.detailedContainer.uniqueItems.isEmpty()) {
            guiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.indexer.controller.container_empty").getString(), panelX + 10, yOffset, 0x888888, false);
        } else {
            int itemSize = 16;
            int itemSpacing = 20;
            this.detailedItemsAreaX = panelX + 10;
            this.detailedItemsAreaY = yOffset;
            int scrollbarWidth = 6;
            int rightMargin = 8;
            this.detailedItemsAreaWidth = panelWidth - 20 - (scrollbarWidth + rightMargin);
            this.detailedItemsAreaHeight = panelY + panelHeight - this.detailedItemsAreaY - 40;
            this.detailedItemsAreaHeight = Math.max(itemSpacing * 2 + 8, this.detailedItemsAreaHeight);
            guiGraphics.m_280509_(this.detailedItemsAreaX, this.detailedItemsAreaY, this.detailedItemsAreaX + this.detailedItemsAreaWidth, this.detailedItemsAreaY + this.detailedItemsAreaHeight, -14474461);
            int itemsPerRow = Math.max(1, this.detailedItemsAreaWidth / itemSpacing);
            int visibleRows = Math.max(2, this.detailedItemsAreaHeight / itemSpacing);
            int totalItems = this.detailedContainer.uniqueItems.size();
            int totalRows = (int)Math.ceil((double)totalItems / (double)itemsPerRow);
            int maxRowOffset = Math.max(0, totalRows - visibleRows);
            if (this.detailedItemsScrollRowOffset > maxRowOffset) {
                this.detailedItemsScrollRowOffset = maxRowOffset;
            }
            if (this.detailedItemsScrollRowOffset < 0) {
                this.detailedItemsScrollRowOffset = 0;
            }
            int itemIndex = 0;
            for (Map.Entry<String, Integer> entry : this.detailedContainer.uniqueItems.entrySet()) {
                String itemName = entry.getKey();
                int quantity = entry.getValue();
                int row = itemIndex / itemsPerRow;
                int col = itemIndex % itemsPerRow;
                if (row < this.detailedItemsScrollRowOffset || row >= this.detailedItemsScrollRowOffset + visibleRows) {
                    ++itemIndex;
                    continue;
                }
                int visibleRowIndex = row - this.detailedItemsScrollRowOffset;
                int currentItemX = this.detailedItemsAreaX + col * itemSpacing;
                int currentItemY = this.detailedItemsAreaY + visibleRowIndex * itemSpacing;
                guiGraphics.m_280509_(currentItemX - 1, currentItemY - 1, currentItemX + itemSize + 1, currentItemY + itemSize + 1, -15066598);
                guiGraphics.m_280509_(currentItemX, currentItemY, currentItemX + itemSize, currentItemY + itemSize, -13816528);
                ItemStack displayItem = this.createItemStackFromName(itemName);
                if (!displayItem.m_41619_()) {
                    guiGraphics.m_280480_(displayItem, currentItemX, currentItemY);
                    String quantityText = this.formatNumber(quantity);
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                    guiGraphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
                    float scaledX = (float)(currentItemX + itemSize - 2) / 0.7f;
                    float scaledY = (float)(currentItemY + itemSize - 2) / 0.7f;
                    int textWidth = (int)((float)this.f_96547_.m_92895_(quantityText) * 0.7f);
                    guiGraphics.m_280056_(this.f_96547_, quantityText, (int)(scaledX - (float)textWidth / 0.7f), (int)(scaledY - 11.428572f), 0xFFFFFF, true);
                    guiGraphics.m_280168_().m_85849_();
                    if (mouseX >= currentItemX && mouseX < currentItemX + itemSize && mouseY >= currentItemY && mouseY < currentItemY + itemSize && mouseX >= this.detailedItemsAreaX && mouseX < this.detailedItemsAreaX + this.detailedItemsAreaWidth && mouseY >= this.detailedItemsAreaY && mouseY < this.detailedItemsAreaY + this.detailedItemsAreaHeight) {
                        ArrayList<Object> tooltip = new ArrayList<Object>();
                        tooltip.add(displayItem.m_41786_());
                        tooltip.add(Component.m_237113_((String)("Cantidad: " + this.formatNumber(quantity))));
                        guiGraphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
                    }
                }
                ++itemIndex;
            }
            if (totalRows > visibleRows) {
                int scrollbarX = this.detailedItemsAreaX + this.detailedItemsAreaWidth + rightMargin;
                int scrollbarY = this.detailedItemsAreaY;
                int scrollbarHeight = this.detailedItemsAreaHeight;
                guiGraphics.m_280509_(scrollbarX, scrollbarY, scrollbarX + scrollbarWidth, scrollbarY + scrollbarHeight, -12961222);
                int thumbHeight = Math.max(10, visibleRows * scrollbarHeight / totalRows);
                int thumbY = scrollbarY + this.detailedItemsScrollRowOffset * (scrollbarHeight - thumbHeight) / (totalRows - visibleRows);
                guiGraphics.m_280509_(scrollbarX + 1, thumbY, scrollbarX + scrollbarWidth - 1, thumbY + thumbHeight, -7829368);
            }
        }
        MutableComponent closeText = Component.m_237115_((String)"gui.indexer.controller.detailed_view.close_instruction");
        int closeWidth = this.f_96547_.m_92852_((FormattedText)closeText);
        guiGraphics.m_280614_(this.f_96547_, (Component)closeText, panelX + (panelWidth - closeWidth) / 2, panelY + panelHeight - 15, 0x888888, false);
    }

    private List<ContainerInfo> getFilteredContainers() {
        if (this.searchFilter.isEmpty()) {
            return this.containerList;
        }
        return this.containerList.stream().filter(container -> container.containerType.toLowerCase().contains(this.searchFilter) || container.position.toString().toLowerCase().contains(this.searchFilter)).toList();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.showDetailedView) {
            if (mouseX < 8.0 || mouseX > 188.0 || mouseY < 20.0 || mouseY > 220.0) {
                this.showDetailedView = false;
                this.detailedContainer = null;
                return true;
            }
            return true;
        }
        List<ContainerInfo> filtered = this.getFilteredContainers();
        if (filtered.size() > this.maxVisibleContainers) {
            int scrollbarX = 182;
            int scrollbarY = 25;
            int scrollbarHeight = 190;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 6) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                int thumbHeight = Math.max(10, this.maxVisibleContainers * scrollbarHeight / filtered.size());
                int track = Math.max(1, scrollbarHeight - thumbHeight);
                int pos = (int)Math.max(0.0, Math.min((double)track, mouseY - (double)scrollbarY - (double)(thumbHeight / 2)));
                int maxScroll = Math.max(0, filtered.size() - this.maxVisibleContainers);
                this.scrollOffset = pos * maxScroll / track;
                this.draggingLeftScrollbar = true;
                return true;
            }
        }
        if (mouseX >= 8.0 && mouseX <= 180.0 && mouseY >= 25.0 && mouseY <= 215.0) {
            int itemHeight = 35;
            int clickedIndex = ((int)mouseY - 20 - 5) / itemHeight + this.scrollOffset;
            List<ContainerInfo> filteredContainers = this.getFilteredContainers();
            if (clickedIndex >= 0 && clickedIndex < filteredContainers.size()) {
                this.detailedContainer = filteredContainers.get(clickedIndex);
                this.showDetailedView = true;
                return true;
            }
        }
        if (this.showDetailedView && this.detailedContainer != null) {
            int visibleRows;
            int itemSpacing = 20;
            int itemsPerRow = Math.max(1, this.detailedItemsAreaWidth / itemSpacing);
            int totalItems = this.detailedContainer.uniqueItems.size();
            int totalRows = (int)Math.ceil((double)totalItems / (double)itemsPerRow);
            if (totalRows > (visibleRows = Math.max(2, this.detailedItemsAreaHeight / itemSpacing))) {
                int scrollbarWidth = 6;
                int rightMargin = 8;
                int scrollbarX = this.detailedItemsAreaX + this.detailedItemsAreaWidth + rightMargin;
                int scrollbarY = this.detailedItemsAreaY;
                int scrollbarHeight = this.detailedItemsAreaHeight;
                if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                    int thumbHeight = Math.max(10, visibleRows * scrollbarHeight / totalRows);
                    int track = Math.max(1, scrollbarHeight - thumbHeight);
                    int pos = (int)Math.max(0.0, Math.min((double)track, mouseY - (double)scrollbarY - (double)(thumbHeight / 2)));
                    int maxRowOffset = Math.max(0, totalRows - visibleRows);
                    this.detailedItemsScrollRowOffset = Math.max(0, Math.min(maxRowOffset, pos * maxRowOffset / track));
                    this.draggingDetailScrollbar = true;
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (mouseX >= 8.0 && mouseX <= 188.0 && mouseY >= 20.0 && mouseY <= 220.0) {
            List<ContainerInfo> filteredContainers = this.getFilteredContainers();
            int maxScroll = Math.max(0, filteredContainers.size() - this.maxVisibleContainers);
            this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)delta));
            return true;
        }
        if (this.showDetailedView && this.detailedContainer != null && mouseX >= (double)this.detailedItemsAreaX && mouseX <= (double)(this.detailedItemsAreaX + this.detailedItemsAreaWidth) && mouseY >= (double)this.detailedItemsAreaY && mouseY <= (double)(this.detailedItemsAreaY + this.detailedItemsAreaHeight)) {
            int itemSpacing = 20;
            int itemsPerRow = Math.max(1, this.detailedItemsAreaWidth / itemSpacing);
            int visibleRows = Math.max(2, this.detailedItemsAreaHeight / itemSpacing);
            int totalItems = this.detailedContainer.uniqueItems.size();
            int totalRows = (int)Math.ceil((double)totalItems / (double)itemsPerRow);
            int maxRowOffset = Math.max(0, totalRows - visibleRows);
            this.detailedItemsScrollRowOffset = Math.max(0, Math.min(maxRowOffset, this.detailedItemsScrollRowOffset - (int)delta));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingLeftScrollbar) {
            List<ContainerInfo> filtered = this.getFilteredContainers();
            int scrollbarY = 25;
            int scrollbarHeight = 190;
            int thumbHeight = Math.max(10, this.maxVisibleContainers * scrollbarHeight / Math.max(1, filtered.size()));
            int track = Math.max(1, scrollbarHeight - thumbHeight);
            int pos = (int)Math.max(0.0, Math.min((double)track, mouseY - (double)scrollbarY - (double)(thumbHeight / 2)));
            int maxScroll = Math.max(0, filtered.size() - this.maxVisibleContainers);
            this.scrollOffset = pos * maxScroll / track;
            return true;
        }
        if (this.draggingDetailScrollbar && this.showDetailedView && this.detailedContainer != null) {
            int itemSpacing = 20;
            int itemsPerRow = Math.max(1, this.detailedItemsAreaWidth / itemSpacing);
            int totalItems = this.detailedContainer.uniqueItems.size();
            int totalRows = (int)Math.ceil((double)totalItems / (double)itemsPerRow);
            int visibleRows = Math.max(2, this.detailedItemsAreaHeight / itemSpacing);
            int maxRowOffset = Math.max(0, totalRows - visibleRows);
            int scrollbarHeight = this.detailedItemsAreaHeight;
            int thumbHeight = Math.max(10, visibleRows * scrollbarHeight / Math.max(1, totalRows));
            int track = Math.max(1, scrollbarHeight - thumbHeight);
            int pos = (int)Math.max(0.0, Math.min((double)track, mouseY - (double)this.detailedItemsAreaY - (double)(thumbHeight / 2)));
            this.detailedItemsScrollRowOffset = Math.max(0, Math.min(maxRowOffset, pos * maxRowOffset / track));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.draggingLeftScrollbar = false;
        this.draggingDetailScrollbar = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_181908_() {
        super.m_181908_();
    }

    private String formatNumber(int number) {
        if (number < 1000) {
            return String.valueOf(number);
        }
        if (number < 1000000) {
            return String.format("%.1fK", (double)number / 1000.0).replace(".0K", "K");
        }
        return String.format("%.1fM", (double)number / 1000000.0).replace(".0M", "M");
    }

    private String getTranslatedContainerType(String containerType) {
        switch (containerType.toLowerCase()) {
            case "chest": {
                return Component.m_237115_((String)"gui.indexer.controller.container_type.chest").getString();
            }
            case "furnace": {
                return Component.m_237115_((String)"gui.indexer.controller.container_type.furnace").getString();
            }
            case "blast_furnace": {
                return Component.m_237115_((String)"gui.indexer.controller.container_type.blast_furnace").getString();
            }
            case "smoker": {
                return Component.m_237115_((String)"gui.indexer.controller.container_type.smoker").getString();
            }
            case "barrel": {
                return Component.m_237115_((String)"gui.indexer.controller.container_type.barrel").getString();
            }
            case "shulker_box": {
                return Component.m_237115_((String)"gui.indexer.controller.container_type.shulker_box").getString();
            }
            case "hopper": {
                return Component.m_237115_((String)"gui.indexer.controller.container_type.hopper").getString();
            }
            case "dispenser": {
                return Component.m_237115_((String)"gui.indexer.controller.container_type.dispenser").getString();
            }
            case "dropper": {
                return Component.m_237115_((String)"gui.indexer.controller.container_type.dropper").getString();
            }
            case "brewing_stand": {
                return Component.m_237115_((String)"gui.indexer.controller.container_type.brewing_stand").getString();
            }
        }
        return Component.m_237115_((String)"gui.indexer.controller.container_type.other").getString();
    }

    private ItemStack getContainerTypeIcon(String containerType) {
        switch (containerType.toLowerCase()) {
            case "chest": {
                return new ItemStack((ItemLike)Items.f_42009_);
            }
            case "barrel": {
                return new ItemStack((ItemLike)Items.f_42768_);
            }
            case "hopper": {
                return new ItemStack((ItemLike)Items.f_42155_);
            }
            case "furnace": {
                return new ItemStack((ItemLike)Items.f_41962_);
            }
            case "blast_furnace": {
                return new ItemStack((ItemLike)Items.f_42770_);
            }
            case "smoker": {
                return new ItemStack((ItemLike)Items.f_42769_);
            }
            case "dispenser": {
                return new ItemStack((ItemLike)Items.f_41855_);
            }
            case "dropper": {
                return new ItemStack((ItemLike)Items.f_42162_);
            }
            case "brewing_stand": {
                return new ItemStack((ItemLike)Items.f_42543_);
            }
            case "shulker_box": {
                return new ItemStack((ItemLike)Items.f_42265_);
            }
        }
        return ItemStack.f_41583_;
    }

    private ItemStack createItemStackFromName(String itemName) {
        try {
            ResourceLocation itemLocation = new ResourceLocation(itemName);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            if (item != null && item != Items.f_41852_) {
                return new ItemStack((ItemLike)item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ItemStack.f_41583_;
    }

    private ItemStack getUpgradeItemForLevel(int level) {
        switch (level) {
            case 0: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_ZERO.get());
            }
            case 1: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_BASIC.get());
            }
            case 2: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_COPPER.get());
            }
            case 3: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_ADVANCED.get());
            }
            case 4: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_ELITE.get());
            }
            case 5: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_DEFINITIVE.get());
            }
        }
        return ItemStack.f_41583_;
    }

    private String getUpgradeNameForLevel(int level) {
        switch (level) {
            case 0: {
                return Component.m_237115_((String)"upgrade.indexer.zero").getString();
            }
            case 1: {
                return Component.m_237115_((String)"upgrade.indexer.basic").getString();
            }
            case 2: {
                return Component.m_237115_((String)"upgrade.indexer.copper").getString();
            }
            case 3: {
                return Component.m_237115_((String)"upgrade.indexer.advanced").getString();
            }
            case 4: {
                return Component.m_237115_((String)"upgrade.indexer.elite").getString();
            }
            case 5: {
                return Component.m_237115_((String)"upgrade.indexer.definitive").getString();
            }
        }
        return "Sin mejora";
    }

    private static class ContainerInfo {
        BlockPos position;
        String containerType;
        int itemCount;
        int maxSlots;
        List<ItemStack> filters = new ArrayList<ItemStack>();
        Map<String, Integer> uniqueItems = new HashMap<String, Integer>();
    }
}

