/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class IndexerManualScreen
extends Screen {
    private static final int SCREEN_WIDTH = 271;
    private static final int SCREEN_HEIGHT = 180;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("indexer", "textures/gui/manual/manualgui.png");
    private static final ResourceLocation LOGO = new ResourceLocation("indexer", "textures/block/indexer_controller_top.png");
    private static final String WIKI_URL = "https://agustinbeniteez.github.io/Wikimods/mod/index.html?id=indexer&game=minecraft";
    private Button nextButton;
    private Button prevButton;
    private Button closeButton;
    private Button menuButton;
    private Button craftingButton;
    private Button tutorialButton;
    private Button wikiButton;
    private EditBox searchBox;
    private int currentPage = 0;
    private final int totalPages = 13;
    private final ResourceLocation[] pageImages = new ResourceLocation[13];
    private ViewMode currentView = ViewMode.MENU;
    private boolean inSplash = true;
    private long splashEndMillis = 0L;
    private static final ResourceLocation MENU_CRAFT_TEXTURE = new ResourceLocation("indexer", "textures/gui/manual/menu/menucraft.png");
    private static final ResourceLocation MENU_TUTORIAL_TEXTURE = new ResourceLocation("indexer", "textures/gui/manual/menu/menututorial.png");
    private static final ResourceLocation MENU_WIKI_TEXTURE = new ResourceLocation("indexer", "textures/gui/manual/menu/menuwiki.png");
    private int menuBtnWidth;
    private int menuBtnHeight;
    private int menuStartX;
    private int menuY;
    private List<Recipe<?>> modCraftingRecipes = Collections.emptyList();
    private List<Recipe<?>> filteredCraftingRecipes = Collections.emptyList();
    private int craftingPage = 0;
    private static final int recipesPerPage = 2;

    public IndexerManualScreen() {
        super((Component)Component.m_237115_((String)"item.indexer.indexer_manual"));
        for (int i = 0; i < 13; ++i) {
            this.pageImages[i] = new ResourceLocation("indexer", "textures/gui/manual/manual" + (i + 1) + ".png");
        }
        this.splashEndMillis = System.currentTimeMillis() + 1000L;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int leftPos = centerX - 135;
        int topPos = centerY - 90;
        this.prevButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.previousPage()).m_252987_(leftPos + 10, topPos + 180 - 30, 20, 20).m_253136_();
        this.nextButton = Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.nextPage()).m_252987_(leftPos + 271 - 30, topPos + 180 - 30, 20, 20).m_253136_();
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"X"), button -> this.m_7379_()).m_252987_(leftPos + 271 - 25, topPos + 5, 20, 20).m_253136_();
        this.menuButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.indexer.manual.menu"), b -> this.switchToMenu()).m_252987_(leftPos + 5, topPos + 5, 40, 20).m_253136_();
        this.menuBtnWidth = 80;
        this.menuBtnHeight = 70;
        this.menuStartX = centerX - (this.menuBtnWidth * 3 + 20) / 2;
        this.menuY = topPos + 60;
        this.craftingButton = new TexturedMenuButton(this.menuStartX, this.menuY, this.menuBtnWidth, this.menuBtnHeight, (Component)Component.m_237115_((String)"gui.indexer.manual.crafting"), b -> this.switchToCrafting(), MENU_CRAFT_TEXTURE);
        this.tutorialButton = new TexturedMenuButton(this.menuStartX + this.menuBtnWidth + 10, this.menuY, this.menuBtnWidth, this.menuBtnHeight, (Component)Component.m_237115_((String)"gui.indexer.manual.tutorial"), b -> this.switchToTutorial(), MENU_TUTORIAL_TEXTURE);
        this.wikiButton = new TexturedMenuButton(this.menuStartX + (this.menuBtnWidth + 10) * 2, this.menuY, this.menuBtnWidth, this.menuBtnHeight, (Component)Component.m_237115_((String)"gui.indexer.manual.wiki"), b -> this.openWiki(), MENU_WIKI_TEXTURE);
        this.searchBox = new EditBox(this.f_96547_, leftPos + 20, topPos + 30, 231, 18, (Component)Component.m_237115_((String)"gui.indexer.manual.search_placeholder"));
        this.searchBox.m_94199_(64);
        this.searchBox.m_94151_(s -> this.applyCraftingFilter((String)s));
        this.m_142416_((GuiEventListener)this.prevButton);
        this.m_142416_((GuiEventListener)this.nextButton);
        this.m_142416_((GuiEventListener)this.closeButton);
        this.m_142416_((GuiEventListener)this.menuButton);
        this.m_142416_((GuiEventListener)this.craftingButton);
        this.m_142416_((GuiEventListener)this.tutorialButton);
        this.m_142416_((GuiEventListener)this.wikiButton);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.updateButtonStates();
        this.updateVisibilityForView();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int leftPos = centerX - 135;
        int topPos = centerY - 90;
        guiGraphics.m_280163_(BACKGROUND, leftPos, topPos, 0.0f, 0.0f, 271, 180, 271, 180);
        if (this.inSplash) {
            long now = System.currentTimeMillis();
            if (now < this.splashEndMillis) {
                int logoSize = 80;
                long elapsed = Math.max(0L, 1000L - (this.splashEndMillis - now));
                float angle = (float)elapsed * 180.0f / 1000.0f;
                PoseStack pose = guiGraphics.m_280168_();
                pose.m_85836_();
                pose.m_252880_((float)centerX, (float)(topPos + 90), 0.0f);
                pose.m_252781_(Axis.f_252403_.m_252977_(angle));
                guiGraphics.m_280163_(LOGO, -logoSize / 2, -logoSize / 2, 0.0f, 0.0f, logoSize, logoSize, logoSize, logoSize);
                pose.m_85849_();
                return;
            }
            this.inSplash = false;
            this.currentView = ViewMode.MENU;
            this.updateVisibilityForView();
        }
        switch (this.currentView) {
            case MENU: {
                String title = I18n.m_118938_((String)"item.indexer.indexer_manual", (Object[])new Object[0]);
                guiGraphics.m_280056_(this.f_96547_, title, centerX - this.f_96547_.m_92895_(title) / 2, topPos + 30, 0xFFFFFF, false);
                break;
            }
            case TUTORIAL: {
                String pageText = this.currentPage + 1 + "/13";
                guiGraphics.m_280056_(this.f_96547_, pageText, centerX - this.f_96547_.m_92895_(pageText) / 2, topPos + 180 - 15, 0xFFFFFF, false);
                try {
                    guiGraphics.m_280163_(this.pageImages[this.currentPage], leftPos + 28, topPos + 30, 0.0f, 0.0f, 200, 120, 200, 120);
                }
                catch (Exception e) {
                    guiGraphics.m_280056_(this.f_96547_, I18n.m_118938_((String)"gui.indexer.manual.error_image", (Object[])new Object[0]), leftPos + 28, topPos + 70, 0xFF0000, false);
                }
                break;
            }
            case CRAFTING: {
                this.renderCraftingList(guiGraphics, leftPos, topPos, mouseX, mouseY);
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderPageContent(GuiGraphics guiGraphics, int leftPos, int topPos) {
    }

    private void nextPage() {
        int maxPage;
        if (this.currentView == ViewMode.TUTORIAL) {
            if (this.currentPage < 12) {
                ++this.currentPage;
            }
        } else if (this.currentView == ViewMode.CRAFTING && this.craftingPage < (maxPage = Math.max(0, (int)Math.ceil((double)this.filteredCraftingRecipes.size() / 2.0) - 1))) {
            ++this.craftingPage;
        }
        this.updateButtonStates();
    }

    private void previousPage() {
        if (this.currentView == ViewMode.TUTORIAL) {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        } else if (this.currentView == ViewMode.CRAFTING && this.craftingPage > 0) {
            --this.craftingPage;
        }
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.currentView == ViewMode.TUTORIAL) {
            this.prevButton.f_93623_ = this.currentPage > 0;
            this.nextButton.f_93623_ = this.currentPage < 12;
        } else if (this.currentView == ViewMode.CRAFTING) {
            int maxPage = Math.max(0, (int)Math.ceil((double)this.filteredCraftingRecipes.size() / 2.0) - 1);
            this.prevButton.f_93623_ = this.craftingPage > 0;
            this.nextButton.f_93623_ = this.craftingPage < maxPage;
        } else {
            this.prevButton.f_93623_ = false;
            this.nextButton.f_93623_ = false;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void switchToMenu() {
        this.currentView = ViewMode.MENU;
        this.updateVisibilityForView();
    }

    private void switchToTutorial() {
        this.currentView = ViewMode.TUTORIAL;
        this.updateVisibilityForView();
    }

    private void switchToCrafting() {
        this.currentView = ViewMode.CRAFTING;
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.loadModCraftingRecipes();
            this.applyCraftingFilter(this.searchBox.m_94155_());
        }
        this.craftingPage = 0;
        this.updateVisibilityForView();
    }

    private void openWiki() {
        this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(accepted -> {
            if (accepted) {
                Util.m_137581_().m_137646_(WIKI_URL);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, WIKI_URL, true));
    }

    private void updateVisibilityForView() {
        if (this.inSplash) {
            this.prevButton.f_93624_ = false;
            this.nextButton.f_93624_ = false;
            this.menuButton.f_93624_ = false;
            this.craftingButton.f_93624_ = false;
            this.tutorialButton.f_93624_ = false;
            this.wikiButton.f_93624_ = false;
            this.searchBox.f_93624_ = false;
            return;
        }
        boolean isMenu = this.currentView == ViewMode.MENU;
        boolean isTutorial = this.currentView == ViewMode.TUTORIAL;
        boolean isCrafting = this.currentView == ViewMode.CRAFTING;
        this.prevButton.f_93624_ = isTutorial || isCrafting;
        this.nextButton.f_93624_ = isTutorial || isCrafting;
        this.menuButton.f_93624_ = !isMenu;
        this.craftingButton.f_93624_ = isMenu;
        this.tutorialButton.f_93624_ = isMenu;
        this.wikiButton.f_93624_ = isMenu;
        this.searchBox.f_93624_ = isCrafting;
        this.updateButtonStates();
    }

    private void loadModCraftingRecipes() {
        try {
            RecipeManager manager = this.f_96541_.f_91073_.m_7465_();
            List recipes = manager.m_44013_(RecipeType.f_44107_);
            ArrayList modList = new ArrayList();
            for (Recipe recipe : recipes) {
                ResourceLocation key;
                ItemStack result = recipe.m_8043_(this.f_96541_.f_91073_.m_9598_());
                if (result.m_41619_() || (key = ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())) == null || !"indexer".equals(key.m_135827_())) continue;
                modList.add(recipe);
            }
            this.modCraftingRecipes = modList;
            this.filteredCraftingRecipes = modList;
        }
        catch (Exception e) {
            this.modCraftingRecipes = Collections.emptyList();
            this.filteredCraftingRecipes = Collections.emptyList();
        }
    }

    private void applyCraftingFilter(String query) {
        String q;
        if (query == null) {
            query = "";
        }
        if ((q = query.trim().toLowerCase()).isEmpty()) {
            this.filteredCraftingRecipes = this.modCraftingRecipes;
        } else {
            ArrayList filtered = new ArrayList();
            for (Recipe<?> recipe : this.modCraftingRecipes) {
                ItemStack result = recipe.m_8043_(this.f_96541_.f_91073_.m_9598_());
                String name = I18n.m_118938_((String)result.m_41778_(), (Object[])new Object[0]).toLowerCase();
                if (!name.contains(q)) continue;
                filtered.add(recipe);
            }
            this.filteredCraftingRecipes = filtered;
        }
        this.craftingPage = 0;
        this.updateButtonStates();
    }

    private void renderCraftingList(GuiGraphics g, int leftPos, int topPos, int mouseX, int mouseY) {
        String title = I18n.m_118938_((String)"gui.indexer.manual.crafting", (Object[])new Object[0]);
        int centerX = this.f_96543_ / 2;
        g.m_280056_(this.f_96547_, title, centerX - this.f_96547_.m_92895_(title) / 2, topPos + 12, 0xFFFFFF, false);
        this.searchBox.m_88315_(g, mouseX, mouseY, 0.0f);
        int startIndex = this.craftingPage * 2;
        int endIndex = Math.min(startIndex + 2, this.filteredCraftingRecipes.size());
        int baseY = topPos + 60;
        int columnWidth = 105;
        int columnGap = 20;
        int rowHeight = 90;
        for (int i = startIndex; i < endIndex; ++i) {
            int localIndex = i - startIndex;
            int col = localIndex % 2;
            int row = localIndex / 2;
            int baseX = leftPos + 20 + col * (columnWidth + columnGap);
            int y = baseY + row * rowHeight;
            Recipe<?> recipe = this.filteredCraftingRecipes.get(i);
            ItemStack result = recipe.m_8043_(this.f_96541_.f_91073_.m_9598_());
            g.m_280480_(result, baseX, y);
            String name = I18n.m_118938_((String)result.m_41778_(), (Object[])new Object[0]);
            int nameMaxWidth = columnWidth - 26;
            String shownName = this.ellipsize(name, nameMaxWidth);
            g.m_280056_(this.f_96547_, shownName, baseX + 22, y + 6, 0xFFFFFF, false);
            int gridX = baseX;
            int gridY = y + 24;
            this.renderRecipeGrid(g, recipe, gridX, gridY);
        }
        String pageText = (this.filteredCraftingRecipes.isEmpty() ? 0 : this.craftingPage + 1) + "/" + Math.max(1, (int)Math.ceil((double)this.filteredCraftingRecipes.size() / 2.0));
        g.m_280056_(this.f_96547_, pageText, centerX - this.f_96547_.m_92895_(pageText) / 2, topPos + 180 - 15, 0xFFFFFF, false);
    }

    private void renderRecipeGrid(GuiGraphics g, Recipe<?> recipe, int gridX, int gridY) {
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            int w = shaped.getRecipeWidth();
            int h = shaped.getRecipeHeight();
            NonNullList ing = shaped.m_7527_();
            int offsetX = (3 - Math.min(3, w)) / 2;
            int offsetY = (3 - Math.min(3, h)) / 2;
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 3; ++c) {
                    boolean inside;
                    int slotX = gridX + c * 18;
                    int slotY = gridY + r * 18;
                    boolean bl = inside = c >= offsetX && c < offsetX + Math.min(3, w) && r >= offsetY && r < offsetY + Math.min(3, h);
                    if (inside) {
                        ItemStack[] stacks;
                        int rr = r - offsetY;
                        int cc = c - offsetX;
                        int idx = rr * w + cc;
                        ItemStack stack = ItemStack.f_41583_;
                        if (idx >= 0 && idx < ing.size() && (stacks = ((Ingredient)ing.get(idx)).m_43908_()).length > 0) {
                            stack = stacks[0];
                        }
                        if (!stack.m_41619_()) {
                            g.m_280480_(stack, slotX, slotY);
                            continue;
                        }
                        this.drawEmptySlot(g, slotX, slotY);
                        continue;
                    }
                    this.drawEmptySlot(g, slotX, slotY);
                }
            }
        } else {
            NonNullList ing = recipe.m_7527_();
            int count = Math.min(9, ing.size());
            for (int idx = 0; idx < 9; ++idx) {
                int c = idx % 3;
                int r = idx / 3;
                int slotX = gridX + c * 18;
                int slotY = gridY + r * 18;
                if (idx < count) {
                    ItemStack stack;
                    ItemStack[] stacks = ((Ingredient)ing.get(idx)).m_43908_();
                    ItemStack itemStack = stack = stacks.length > 0 ? stacks[0] : ItemStack.f_41583_;
                    if (!stack.m_41619_()) {
                        g.m_280480_(stack, slotX, slotY);
                        continue;
                    }
                    this.drawEmptySlot(g, slotX, slotY);
                    continue;
                }
                this.drawEmptySlot(g, slotX, slotY);
            }
        }
    }

    private void drawEmptySlot(GuiGraphics g, int x, int y) {
        g.m_280509_(x - 1, y - 1, x + 17, y + 17, -15066598);
        g.m_280509_(x, y, x + 16, y + 16, -13816528);
    }

    private String ellipsize(String text, int maxWidth) {
        int cut;
        if (this.f_96547_.m_92895_(text) <= maxWidth) {
            return text;
        }
        String ell = "...";
        int ellW = this.f_96547_.m_92895_(ell);
        int target = Math.max(0, maxWidth - ellW);
        for (cut = Math.max(0, text.length()); cut > 0 && this.f_96547_.m_92895_(text.substring(0, cut)) > target; --cut) {
        }
        return cut <= 0 ? ell : text.substring(0, cut) + ell;
    }

    private static enum ViewMode {
        MENU,
        TUTORIAL,
        CRAFTING;

    }

    private static class TexturedMenuButton
    extends Button {
        private final ResourceLocation texture;

        public TexturedMenuButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, ResourceLocation texture) {
            super(x, y, width, height, message, onPress, f_252438_);
            this.texture = texture;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int x = this.m_252754_();
            int y = this.m_252907_();
            int w = this.m_5711_();
            int h = this.m_93694_();
            if (this.m_198029_()) {
                int dw = (int)Math.round((double)w * 1.06);
                int dh = (int)Math.round((double)h * 1.06);
                int dx = x - (dw - w) / 2;
                int dy = y - (dh - h) / 2;
                guiGraphics.m_280163_(this.texture, dx, dy, 0.0f, 0.0f, dw, dh, w, h);
                guiGraphics.m_280509_(x, y, x + w, y + h, 0x66000000);
                guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), x + w / 2, y + (h - 8) / 2, 0xFFFFFF);
            } else {
                guiGraphics.m_280163_(this.texture, x, y, 0.0f, 0.0f, w, h, w, h);
            }
        }
    }
}

