/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.blockentity;

import com.min01.crypticfoes.block.CrypticBlocks;
import com.min01.crypticfoes.block.ScreamerBlock;
import com.min01.crypticfoes.effect.CrypticEffects;
import com.min01.crypticfoes.entity.living.EntityHowler;
import com.min01.crypticfoes.misc.SmoothAnimationState;
import com.min01.crypticfoes.particle.CrypticParticles;
import com.min01.crypticfoes.sound.CrypticSounds;
import com.min01.crypticfoes.util.CrypticUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ScreamerBlockEntity
extends BlockEntity {
    public int tickCount;
    public final SmoothAnimationState screamAnimationState = new SmoothAnimationState();

    public ScreamerBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)CrypticBlocks.SCREAMER_BLOCK_ENTITY.get(), p_155229_, p_155230_);
    }

    public static void update(Level level, BlockPos pos, BlockState state, ScreamerBlockEntity block) {
        boolean activate = (Boolean)state.m_61143_((Property)ScreamerBlock.ACTIVATE);
        if (level.f_46443_) {
            block.screamAnimationState.updateWhen(activate, block.tickCount);
        }
        if (activate) {
            ++block.tickCount;
            if (block.tickCount == 1) {
                level.m_5594_(null, pos, (SoundEvent)CrypticSounds.SCREAMER_WORK.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
            }
            if (block.tickCount == 30) {
                level.m_7106_((ParticleOptions)CrypticParticles.HOWLER_SHOCKWAVE.get(), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.01f), (double)((float)pos.m_123343_() + 0.5f), 80.0, 0.0, 0.0);
            }
            if (block.tickCount == 34) {
                boolean charged = (Boolean)state.m_61143_((Property)ScreamerBlock.CHARGED);
                List list = level.m_6443_(LivingEntity.class, new AABB(-6.0, 0.0, -6.0, 6.0, 6.0, 6.0).m_82338_(pos), EntitySelector.f_20406_.and(t -> !(t instanceof EntityHowler)));
                list.forEach(t -> {
                    Vec3 motion = CrypticUtil.fromToVector(Vec3.m_82539_((Vec3i)pos), t.m_20182_().m_82520_(0.0, 1.0, 0.0), 1.0f);
                    t.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                    if (t instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)t;
                        player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)t));
                    }
                    if (charged) {
                        t.m_7292_(new MobEffectInstance((MobEffect)CrypticEffects.STUNNED.get(), 100));
                    }
                });
                if (charged) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)ScreamerBlock.CHARGED, (Comparable)Boolean.valueOf(false)));
                }
            }
            if (block.tickCount >= 45) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ScreamerBlock.ACTIVATE, (Comparable)Boolean.valueOf(!activate)));
            }
        } else {
            block.tickCount = 0;
        }
    }

    public void m_142466_(CompoundTag p_155245_) {
        super.m_142466_(p_155245_);
        this.tickCount = p_155245_.m_128451_("TickCount");
    }

    protected void m_183515_(CompoundTag p_187471_) {
        super.m_183515_(p_187471_);
        p_187471_.m_128405_("TickCount", this.tickCount);
    }
}

