/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.entity.living;

import com.min01.crypticfoes.entity.AbstractAnimatableCreature;
import com.min01.crypticfoes.misc.CrypticExplosion;
import com.min01.crypticfoes.misc.SmoothAnimationState;
import com.min01.crypticfoes.particle.CrypticParticles;
import com.min01.crypticfoes.sound.CrypticSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class EntityBrancher
extends AbstractAnimatableCreature {
    public static final EntityDataAccessor<Integer> ANGER_COUNT = SynchedEntityData.m_135353_(EntityBrancher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EXPLOSION_MAX_TICK = SynchedEntityData.m_135353_(EntityBrancher.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> IS_RUNNING = SynchedEntityData.m_135353_(EntityBrancher.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final SmoothAnimationState idleAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState shiverAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState explosionAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState runAnimationState = new SmoothAnimationState();
    public float brightness;
    public float brightnessOld;
    public int glowingTicks;
    public int explosionTick;
    public int explosionMaxTick;

    public EntityBrancher(EntityType<? extends PathfinderMob> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, (double)0.8f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER_COUNT, (Object)0);
        this.f_19804_.m_135372_(EXPLOSION_MAX_TICK, (Object)0);
        this.f_19804_.m_135372_(IS_RUNNING, (Object)false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                return super.m_8036_() && EntityBrancher.this.isAngry() && EntityBrancher.this.m_5448_() == null;
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(this, new Class[0]){

            public void m_8056_() {
                super.m_8056_();
                EntityBrancher.this.setAngerCount(2);
                EntityBrancher.this.m_216990_((SoundEvent)CrypticSounds.BRANCHER_ANGRY.get());
            }
        });
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.idleAnimationState.updateWhen(this.getAnimationState() == 0, this.f_19797_);
            this.shiverAnimationState.updateWhen(this.getAnimationState() == 1, this.f_19797_);
            this.explosionAnimationState.updateWhen(this.getAnimationState() == 2, this.f_19797_);
            this.runAnimationState.updateWhen(this.isRunning(), this.f_19797_);
            ++this.glowingTicks;
            this.brightness += (0.0f - this.brightness) * 0.8f;
        }
        if (this.isAngry() && this.m_5448_() != null) {
            this.setRunning(true);
            this.m_21573_().m_5624_((Entity)this.m_5448_(), (double)0.42f);
            if (this.m_20270_((Entity)this.m_5448_()) <= 2.0f) {
                if (this.getAnimationState() == 0) {
                    this.setAnimationState(2);
                }
                this.setExplosionMaxTick(40);
            } else if (this.getAnimationState() == 2) {
                this.setExplosionMaxTick(160);
            }
        }
        if (this.getAnimationState() == 2) {
            if (this.explosionTick <= this.getExplosionMaxTick()) {
                ++this.explosionTick;
                if (this.explosionTick % 20 == 0) {
                    this.m_216990_((SoundEvent)CrypticSounds.BRANCHER_HEARTBEAT.get());
                }
            } else if (this.m_6084_()) {
                this.brancherExplode(this.m_20182_(), 2.0f);
                this.m_216990_((SoundEvent)CrypticSounds.BRANCHER_HISS.get());
                this.m_146870_();
            }
        }
        if (this.getAnimationTick() <= 0 && this.getAnimationState() == 1) {
            this.setAnimationState(0);
        }
    }

    public void brancherExplode(Vec3 pos, float radius) {
        CrypticExplosion explosion = new CrypticExplosion(this.f_19853_, (Entity)this, pos.f_82479_, pos.f_82480_, pos.f_82481_, radius, (ParticleOptions)CrypticParticles.BRANCHER_EXPLOSION_SEED.get());
        explosion.m_46061_();
        explosion.m_46075_(false);
        this.m_216990_((SoundEvent)CrypticSounds.BRANCHER_EXPLOSION.get());
    }

    @Override
    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128379_("isRunning", this.isRunning());
        p_21484_.m_128405_("AngerCount", this.getAngerCount());
        p_21484_.m_128405_("ExplosionMaxTick", this.getExplosionMaxTick());
    }

    @Override
    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        if (p_21450_.m_128441_("isRunning")) {
            this.setRunning(p_21450_.m_128471_("isRunning"));
        }
        if (p_21450_.m_128441_("AngerCount")) {
            this.setAngerCount(p_21450_.m_128451_("AngerCount"));
        }
        if (p_21450_.m_128441_("ExplosionMaxTick")) {
            this.setExplosionMaxTick(p_21450_.m_128451_("ExplosionMaxTick"));
        }
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CrypticSounds.BRANCHER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)CrypticSounds.BRANCHER_HURT.get();
    }

    public void setRunning(boolean value) {
        this.f_19804_.m_135381_(IS_RUNNING, (Object)value);
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(IS_RUNNING);
    }

    public void setExplosionMaxTick(int value) {
        this.f_19804_.m_135381_(EXPLOSION_MAX_TICK, (Object)value);
    }

    public int getExplosionMaxTick() {
        return (Integer)this.f_19804_.m_135370_(EXPLOSION_MAX_TICK);
    }

    public void setAngerCount(int value) {
        this.f_19804_.m_135381_(ANGER_COUNT, (Object)value);
        if (value == 2) {
            this.m_216990_((SoundEvent)CrypticSounds.BRANCHER_ANGRY.get());
        }
    }

    public int getAngerCount() {
        return (Integer)this.f_19804_.m_135370_(ANGER_COUNT);
    }

    public boolean isAngry() {
        return this.getAngerCount() >= 2;
    }
}

