/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.entity.living;

import com.min01.crypticfoes.entity.AbstractAnimatableMonster;
import com.min01.crypticfoes.entity.EntityCameraShake;
import com.min01.crypticfoes.entity.ai.goal.HowlerPunchGoal;
import com.min01.crypticfoes.entity.ai.goal.HowlerRoarGoal;
import com.min01.crypticfoes.item.CrypticItems;
import com.min01.crypticfoes.misc.SmoothAnimationState;
import com.min01.crypticfoes.particle.CrypticParticles;
import com.min01.crypticfoes.sound.CrypticSounds;
import com.min01.crypticfoes.util.CrypticUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityHowler
extends AbstractAnimatableMonster {
    public static final EntityDataAccessor<Boolean> IS_SLEEPING = SynchedEntityData.m_135353_(EntityHowler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_FALLING = SynchedEntityData.m_135353_(EntityHowler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<BlockPos> SLEEP_POS = SynchedEntityData.m_135353_(EntityHowler.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public final SmoothAnimationState idleAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState sleepAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState awakeAnimationState = new SmoothAnimationState(0.999f);
    public final SmoothAnimationState fallAnimationState = new SmoothAnimationState(0.999f);
    public final SmoothAnimationState landAnimationState = new SmoothAnimationState(0.999f);
    public final SmoothAnimationState roarAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState blinkAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState punchAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState flyAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState flyStartAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState flyEndAnimationState = new SmoothAnimationState(0.999f);
    public int ambientTick;
    public int targetTick = 200;

    public EntityHowler(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.posArray = new Vec3[1];
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 100.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 25.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new HowlerPunchGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HowlerRoarGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            protected void m_26073_() {
                this.f_26050_ = this.f_26135_.f_19853_.m_45982_(this.f_26135_.f_19853_.m_6443_(this.f_26048_, this.m_7255_(this.m_7623_()), p_148152_ -> true), TargetingConditions.f_26872_, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
            }

            protected AABB m_7255_(double p_26069_) {
                if (((EntityHowler)this.f_26135_).isHowlerSleeping()) {
                    return this.f_26135_.m_20191_().m_82377_(15.0, (double)this.f_26135_.f_19853_.m_151558_(), 15.0);
                }
                return super.m_7255_(p_26069_);
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public boolean canRandomStroll() {
        return super.canRandomStroll() && !this.isHowlerSleeping() && !this.isUsingSkill();
    }

    @Override
    public boolean canLookAround() {
        return super.canLookAround() && !this.isHowlerSleeping() && !this.isUsingSkill();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(IS_FALLING, (Object)false);
        this.f_19804_.m_135372_(SLEEP_POS, (Object)BlockPos.f_121853_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_183634_();
        if (this.f_19853_.f_46443_) {
            this.idleAnimationState.updateWhen(!this.isHowlerSleeping() && this.getAnimationState() == 0, this.f_19797_);
            this.sleepAnimationState.updateWhen(this.isHowlerSleeping() && this.getAnimationState() == 1, this.f_19797_);
            this.awakeAnimationState.updateWhen(this.isHowlerSleeping() && this.getAnimationState() == 2, this.f_19797_);
            this.fallAnimationState.updateWhen(!this.isHowlerSleeping() && this.isFalling() && this.getAnimationState() == 0, this.f_19797_);
            this.landAnimationState.updateWhen(!this.isHowlerSleeping() && this.getAnimationState() == 3, this.f_19797_);
            this.roarAnimationState.updateWhen(!this.isHowlerSleeping() && this.isUsingSkill(4), this.f_19797_);
            this.blinkAnimationState.updateWhen(!this.isHowlerSleeping() && this.ambientTick > 0, this.f_19797_);
            this.punchAnimationState.updateWhen(!this.isHowlerSleeping() && this.isUsingSkill(5), this.f_19797_);
            this.flyAnimationState.updateWhen(this.isHowlerSleeping() && this.getAnimationState() == 6, this.f_19797_);
            this.flyStartAnimationState.updateWhen(this.isHowlerSleeping() && this.getAnimationState() == 7, this.f_19797_);
            this.flyEndAnimationState.updateWhen(this.isHowlerSleeping() && this.getAnimationState() == 8, this.f_19797_);
        }
        if (this.ambientTick > 0) {
            --this.ambientTick;
        }
        if (!this.isHowlerSleeping()) {
            if (!this.f_19853_.f_46443_) {
                BlockPos ceilingPos;
                if (this.m_5448_() == null) {
                    ++this.targetTick;
                } else if (this.m_5448_().m_6084_()) {
                    this.targetTick = 0;
                    if (this.canLook()) {
                        this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                    }
                    if (this.canMove()) {
                        this.m_21573_().m_5624_((Entity)this.m_5448_(), 1.0);
                    }
                }
                if (this.targetTick >= 200 && !this.f_19853_.m_45527_(this.m_20183_()) && this.getAnimationState() == 0 && this.m_20096_() && this.f_19853_.m_8055_(this.m_20097_().m_7494_()).m_60795_() && !this.f_19853_.m_45527_(ceilingPos = CrypticUtil.getCeilingPos((BlockGetter)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), -1)) && CrypticUtil.distanceToY((Entity)this, ceilingPos) >= 8.0f) {
                    this.setSleepPos(ceilingPos);
                    this.setCanMove(false);
                    this.setCanLook(false);
                    this.setHowlerSleeping(true);
                }
            }
            if (this.m_20096_()) {
                if (this.isFalling()) {
                    this.setFalling(false);
                    this.setAnimationState(3);
                    this.setAnimationTick(43);
                    this.createShockwave();
                } else if (this.getAnimationState() == 3 && this.getAnimationTick() <= 0) {
                    this.setAnimationState(0);
                    this.setCanMove(true);
                    this.setCanLook(true);
                }
            }
        } else if (!this.getSleepPos().equals((Object)BlockPos.f_121853_) && !this.isFalling()) {
            BlockPos pos = this.getSleepPos();
            if (this.horizontalDist(pos, this.m_20185_(), this.m_20189_()) <= 2.0) {
                if (this.getAnimationState() == 0 && !this.m_20069_()) {
                    this.setAnimationState(7);
                    this.setAnimationTick(46);
                    this.m_20256_(Vec3.f_82478_);
                    this.m_20242_(true);
                }
                if (this.getAnimationState() == 7) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.getAnimationState() == 6) {
                    Vec3 sleepPos = Vec3.m_82512_((Vec3i)pos);
                    if (sleepPos.m_82546_(this.m_146892_()).m_82553_() <= 2.0) {
                        this.setAnimationState(8);
                        this.setAnimationTick(35);
                        this.m_20256_(new Vec3(0.0, this.m_20184_().f_82480_, 0.0));
                    } else {
                        BlockPos abovePos = this.m_20183_().m_6630_(3);
                        if (this.f_19863_) {
                            this.setSleepPos(abovePos);
                        }
                        this.m_246865_(new Vec3(0.0, (double)0.05f, 0.0));
                    }
                }
                if (this.getAnimationTick() <= 0) {
                    if (this.getAnimationState() == 7) {
                        this.setAnimationState(6);
                        this.setAnimationTick(45);
                    }
                    if (this.getAnimationState() == 8) {
                        this.setAnimationState(1);
                        this.setAnimationTick(40);
                    }
                }
            } else {
                this.m_21573_().m_26519_((double)pos.m_123341_(), this.m_20186_(), (double)pos.m_123343_(), 0.5);
            }
            if (this.getAnimationState() == 1) {
                this.m_20256_(Vec3.f_82478_);
            }
            if (this.getAnimationState() == 2 && this.getAnimationTick() <= 0) {
                this.setHowlerSleeping(false);
                this.m_20242_(false);
                this.setFalling(true);
                this.setAnimationState(0);
            }
        }
        if (this.getAnimationState() == 1) {
            this.m_20256_(Vec3.f_82478_);
        }
        if (this.isHowlerSleeping() && this.getAnimationState() == 1) {
            if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
                this.awake();
            } else if (this.f_19853_.m_8055_(this.getSleepPos()).m_60795_()) {
                this.targetTick = 0;
                this.setHowlerSleeping(false);
                this.m_20242_(false);
                this.setFalling(true);
                this.setAnimationState(0);
            }
        }
    }

    public void awake() {
        this.targetTick = 0;
        this.setAnimationState(2);
        this.setAnimationTick(60);
    }

    protected void m_7472_(DamageSource p_32292_, int p_32293_, boolean p_32294_) {
        Creeper creeper;
        super.m_7472_(p_32292_, p_32293_, p_32294_);
        Entity entity = p_32292_.m_7639_();
        if (entity != this && entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_()) {
            creeper.m_32314_();
            this.m_19998_((ItemLike)CrypticItems.HOWLER_HEAD.get());
        }
    }

    public void createShockwave() {
        EntityCameraShake.cameraShake(this.f_19853_, this.m_20182_(), 15.0f, 0.25f, 0, 20);
        List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(3.0), t -> !(t instanceof EntityHowler));
        list.forEach(t -> {
            Vec3 motion = CrypticUtil.fromToVector(this.m_20182_(), t.m_20182_().m_82520_(0.0, 1.0, 0.0), 1.0f);
            t.m_5997_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
            if (t instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)t;
                player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)t));
            }
        });
        if (!this.f_19853_.f_46443_) {
            ServerLevel level = (ServerLevel)this.f_19853_;
            level.m_7605_((Entity)this, (byte)99);
            for (int i = 0; i < 50; ++i) {
                double spread1 = this.f_19796_.m_188583_() * 1.0;
                double spread2 = this.f_19796_.m_188583_() * 1.0;
                level.m_8767_((ParticleOptions)new BlockParticleOption((ParticleType)CrypticParticles.DUST_PILLAR.get(), this.m_20075_()), this.m_20185_() + spread1, this.m_20186_(), this.m_20189_() + spread2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean checkHowlerSpawnRules(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos p_219017_, RandomSource p_219018_) {
        BlockPos ceilingPos = CrypticUtil.getCeilingPos((BlockGetter)p_219015_, p_219017_.m_123341_(), p_219017_.m_123342_(), p_219017_.m_123343_(), 0);
        BlockPos groundPos = p_219015_.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, p_219017_);
        return CrypticUtil.distanceToY(p_219017_, ceilingPos) >= 8.0f && ceilingPos.m_123342_() < groundPos.m_123342_() && !p_219015_.m_45527_(ceilingPos) && p_219015_.m_46791_() != Difficulty.PEACEFUL && EntityHowler.m_219009_((ServerLevelAccessor)p_219015_, (BlockPos)p_219017_, (RandomSource)p_219018_) && EntityHowler.m_217057_(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)p_219017_, (RandomSource)p_219018_);
    }

    public double horizontalDist(BlockPos pos, double x, double z) {
        double xDist = (double)pos.m_123341_() + 0.5 - x;
        double zDist = (double)pos.m_123343_() + 0.5 - z;
        return Math.sqrt(xDist * xDist + zDist * zDist);
    }

    public void m_7822_(byte p_21375_) {
        super.m_7822_(p_21375_);
        if (p_21375_ == 99) {
            BlockPos groundPos = CrypticUtil.getGroundPos((BlockGetter)this.f_19853_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), -2);
            this.f_19853_.m_7106_((ParticleOptions)CrypticParticles.HOWLER_SHOCKWAVE.get(), this.m_20185_(), (double)((float)groundPos.m_123342_() + 0.01f), this.m_20189_(), 20.0, 0.0, 0.0);
        }
    }

    public void m_5997_(double p_20286_, double p_20287_, double p_20288_) {
        if (!this.isHowlerSleeping()) {
            super.m_5997_(p_20286_, p_20287_, p_20288_);
        }
    }

    public void m_8032_() {
        super.m_8032_();
        if (!this.isHowlerSleeping() && this.ambientTick <= 0) {
            this.ambientTick = 10;
        }
    }

    protected void m_267689_(float p_268283_) {
        float f = Math.min(p_268283_ * 4.0f, 1.0f);
        if (this.isHowlerSleeping()) {
            f = 0.0f;
        }
        this.f_267362_.m_267566_(f, 0.4f);
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (this.getAnimationState() == 3 || this.getAnimationState() == 4 || this.getAnimationState() == 5) {
            p_21017_ *= 0.5f;
        }
        if (p_21016_.m_269533_(DamageTypeTags.f_268549_)) {
            return false;
        }
        if (p_21016_.m_276093_(DamageTypes.f_268612_) && (this.isHowlerSleeping() || this.isFalling())) {
            return false;
        }
        if (this.isHowlerSleeping() && this.getAnimationState() == 1 && p_21016_.m_7640_() != null) {
            this.targetTick = 0;
            this.setAnimationState(2);
            this.setAnimationTick(60);
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    @Override
    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        this.setHowlerSleeping(p_21450_.m_128471_("isHowlerSleeping"));
        this.setFalling(p_21450_.m_128471_("isFalling"));
        this.setSleepPos(NbtUtils.m_129239_((CompoundTag)p_21450_.m_128469_("SleepPos")));
    }

    @Override
    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128379_("isHowlerSleeping", this.isHowlerSleeping());
        p_21484_.m_128379_("isFalling", this.isFalling());
        p_21484_.m_128365_("SleepPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getSleepPos()));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CrypticSounds.HOWLER_IDLE.get();
    }

    public void setHowlerSleeping(boolean value) {
        this.f_19804_.m_135381_(IS_SLEEPING, (Object)value);
    }

    public boolean isHowlerSleeping() {
        return (Boolean)this.f_19804_.m_135370_(IS_SLEEPING);
    }

    public void setFalling(boolean value) {
        this.f_19804_.m_135381_(IS_FALLING, (Object)value);
    }

    public boolean isFalling() {
        return (Boolean)this.f_19804_.m_135370_(IS_FALLING);
    }

    public void setSleepPos(BlockPos value) {
        this.f_19804_.m_135381_(SLEEP_POS, (Object)value);
    }

    public BlockPos getSleepPos() {
        return (BlockPos)this.f_19804_.m_135370_(SLEEP_POS);
    }
}

