/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.entity.model;

import com.min01.crypticfoes.entity.animation.BrancherAnimation;
import com.min01.crypticfoes.entity.living.EntityBrancher;
import com.min01.crypticfoes.util.CrypticClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class ModelBrancher
extends HierarchicalModel<EntityBrancher> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("crypticfoes", "brancher"), "main");
    private final ModelPart root;

    public ModelBrancher(ModelPart root) {
        this.root = root.m_171324_("root");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bone = root.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)0.5f));
        body.m_171599_("body_main", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -4.0f, -3.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.5f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.5f));
        head.m_171599_("lefthair", CubeListBuilder.m_171558_().m_171514_(32, 10).m_171488_(0.0f, -3.0f, 0.0f, 2.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-4.0f, (float)-0.5f));
        head.m_171599_("righthair", CubeListBuilder.m_171558_().m_171514_(36, 10).m_171488_(-2.0f, -3.0f, 0.0f, 2.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-4.0f, (float)-0.5f));
        head.m_171599_("horns", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)-1.5f));
        PartDefinition rightfrontleg = bone.m_171599_("rightfrontleg", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-15.0f, (float)-3.0f));
        rightfrontleg.m_171599_("rightfronttwigs", CubeListBuilder.m_171558_().m_171514_(32, 2).m_171488_(-2.0f, -4.0f, 0.0f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)4.0f, (float)0.0f));
        PartDefinition leftfrontleg = bone.m_171599_("leftfrontleg", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-15.0f, (float)-3.0f));
        leftfrontleg.m_171599_("leftfronttwigs", CubeListBuilder.m_171558_().m_171514_(36, 2).m_171488_(0.0f, -4.0f, 0.0f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)4.0f, (float)0.0f));
        PartDefinition rightbackleg = bone.m_171599_("rightbackleg", CubeListBuilder.m_171558_().m_171514_(16, 36).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-15.0f, (float)4.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        rightbackleg.m_171599_("rightbacktwigs", CubeListBuilder.m_171558_().m_171514_(40, 2).m_171480_().m_171488_(0.0f, -4.0f, 0.0f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)4.0f, (float)0.0f));
        PartDefinition leftbackleg = bone.m_171599_("leftbackleg", CubeListBuilder.m_171558_().m_171514_(32, 36).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.0f, (float)-15.0f, (float)4.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        leftbackleg.m_171599_("leftbacktwigs", CubeListBuilder.m_171558_().m_171514_(40, 10).m_171480_().m_171488_(-2.0f, -4.0f, 0.0f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityBrancher entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        entity.idleAnimationState.animate(this, BrancherAnimation.BRANCHER_IDLE, ageInTicks, limbSwingAmount);
        entity.shiverAnimationState.animate(this, BrancherAnimation.BRANCHER_SHIVER, ageInTicks);
        entity.explosionAnimationState.animate(this, BrancherAnimation.BRANCHER_EXPLOSION, ageInTicks);
        float factor = entity.runAnimationState.factor(CrypticClientUtil.MC.m_91296_());
        this.m_267799_(BrancherAnimation.BRANCHER_WALK, limbSwing, limbSwingAmount * factor, 2.5f, 2.5f);
        this.m_267799_(BrancherAnimation.BRANCHER_RUN, limbSwing, Math.max(limbSwingAmount - factor, 0.0f), 1.5f, 2.5f);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

