/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.entity.model;

import com.min01.crypticfoes.entity.animation.PetrifiedAnimation;
import com.min01.crypticfoes.entity.living.EntityPetrified;
import com.min01.crypticfoes.util.CrypticClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class ModelPetrified
extends HierarchicalModel<EntityPetrified> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("crypticfoes", "petrified"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart arms;
    private final ModelPart stone;

    public ModelPetrified(ModelPart root) {
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.arms = this.body.m_171324_("arms");
        this.stone = this.arms.m_171324_("stone");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 28).m_171488_(-4.0f, -9.0f, -2.0f, 8.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        arms.m_171599_("stone", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -7.0f, -7.5f, 14.0f, 14.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-28.0f, (float)0.5f));
        arms.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 41).m_171488_(0.0f, -23.0f, -1.0f, 2.0f, 23.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)1.0f, (float)0.0f));
        arms.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(32, 41).m_171488_(-2.0f, -23.0f, -1.0f, 2.0f, 23.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)1.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(8, 44).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-7.0f, (float)0.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-7.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityPetrified entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        CrypticClientUtil.animateHead(this.head, netHeadYaw, headPitch);
        entity.idleAnimationState.animate(this, PetrifiedAnimation.PETRIFIED_IDLE, ageInTicks, limbSwingAmount);
        entity.idleNoneAnimationState.animate(this, PetrifiedAnimation.PETRIFIED_IDLE_NONE, ageInTicks, limbSwingAmount);
        entity.throwAnimationState.animate(this, PetrifiedAnimation.PETRIFIED_THROW, ageInTicks);
        entity.reloadingAnimationState.animate(this, PetrifiedAnimation.PETRIFIED_RELOADING, ageInTicks);
        float factor = entity.runAnimationState.factor(CrypticClientUtil.MC.m_91296_());
        this.m_267799_(PetrifiedAnimation.PETRIFIED_WALK, limbSwing, Math.max(limbSwingAmount - factor, 0.0f), 2.5f, 2.5f);
        this.m_267799_(PetrifiedAnimation.PETRIFIED_WALK_NONE, limbSwing, limbSwingAmount * factor, 2.5f, 2.5f);
        this.stone.f_104207_ = entity.hasStone();
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

