/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.entity.projectile;

import com.min01.crypticfoes.effect.CrypticEffects;
import com.min01.crypticfoes.item.CrypticItems;
import com.min01.crypticfoes.item.MonstrousHornItem;
import com.min01.crypticfoes.misc.CrypticTags;
import com.min01.crypticfoes.util.CrypticUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class EntityHowlerScream
extends ThrowableProjectile {
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(EntityHowlerScream.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Integer> STUN_DURATION = SynchedEntityData.m_135353_(EntityHowlerScream.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> RANGE = SynchedEntityData.m_135353_(EntityHowlerScream.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float alpha = 1.0f;

    public EntityHowlerScream(EntityType<? extends ThrowableProjectile> p_37466_, Level p_37467_) {
        super(p_37466_, p_37467_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(STUN_DURATION, (Object)160);
        this.f_19804_.m_135372_(RANGE, (Object)Float.valueOf(0.03f));
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
        this.alpha -= this.getRange();
        this.alpha = Mth.m_14036_((float)this.alpha, (float)0.0f, (float)1.0f);
        if (this.alpha <= 0.0f) {
            this.m_146870_();
        } else if (this.m_19749_() != null) {
            float scale = 0.25f + (float)this.f_19797_ * 0.08f;
            scale = Mth.m_14036_((float)scale, (float)0.0f, (float)3.0f);
            List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_((double)scale), t -> !t.m_7307_(this.m_19749_()) && t != this.m_19749_() && !t.m_21023_((MobEffect)CrypticEffects.STUNNED.get()));
            list.forEach(t -> {
                if (!t.m_6095_().m_204039_(CrypticTags.CrypticEntity.RESIST_TO_STUN) && !t.m_21023_((MobEffect)CrypticEffects.STUNNED.get())) {
                    this.addStunCount();
                    t.m_7292_(new MobEffectInstance((MobEffect)CrypticEffects.STUNNED.get(), this.getStunDuration()));
                }
            });
        }
    }

    public void addStunCount() {
        Player player;
        ItemStack stack;
        Entity entity = this.m_19749_();
        if (entity instanceof Player && (stack = (player = (Player)entity).m_21120_(player.m_7655_())).m_150930_((Item)CrypticItems.MONSTROUS_HORN.get())) {
            MonstrousHornItem.setStunCount(stack, MonstrousHornItem.getStunCount(stack) + 1);
        }
    }

    protected void m_8060_(BlockHitResult p_37258_) {
        super.m_8060_(p_37258_);
        BlockPos blockPos = p_37258_.m_82425_();
        BlockState state = this.f_19853_.m_8055_(blockPos);
        if (state.m_204336_(CrypticTags.CrypticBlocks.BREAKABLE_BY_SCREAM) && !this.f_19853_.f_46443_ && this.m_142265_(this.f_19853_, blockPos) && this.m_20184_().m_82553_() > 0.6) {
            this.f_19853_.m_46961_(blockPos, true);
        }
    }

    public EntityDimensions m_6972_(Pose p_19975_) {
        float scale = 0.25f + (float)this.f_19797_ * 0.08f;
        scale = Mth.m_14036_((float)scale, (float)0.0f, (float)3.0f);
        return EntityDimensions.m_20395_((float)scale, (float)scale);
    }

    protected void m_37283_() {
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_20069_() {
        return false;
    }

    public void m_7380_(CompoundTag p_37265_) {
        if (((Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent()) {
            p_37265_.m_128362_("Owner", (UUID)((Optional)this.f_19804_.m_135370_(OWNER_UUID)).get());
        }
        p_37265_.m_128405_("StunDuration", this.getStunDuration());
        p_37265_.m_128350_("Range", this.getRange());
    }

    public void m_7378_(CompoundTag p_37262_) {
        if (p_37262_.m_128403_("Owner")) {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.of(p_37262_.m_128342_("Owner")));
        }
        this.setStunDuration(p_37262_.m_128451_("StunDuration"));
        this.setRange(p_37262_.m_128457_("Range"));
    }

    public void m_5602_(Entity owner) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.of(owner.m_20148_()));
    }

    public Entity m_19749_() {
        if (((Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent()) {
            return CrypticUtil.getEntityByUUID(this.f_19853_, (UUID)((Optional)this.f_19804_.m_135370_(OWNER_UUID)).get());
        }
        return null;
    }

    public void setStunDuration(int duration) {
        this.f_19804_.m_135381_(STUN_DURATION, (Object)duration);
    }

    public int getStunDuration() {
        return (Integer)this.f_19804_.m_135370_(STUN_DURATION);
    }

    public void setRange(float range) {
        this.f_19804_.m_135381_(RANGE, (Object)Float.valueOf(range));
    }

    public float getRange() {
        return ((Float)this.f_19804_.m_135370_(RANGE)).floatValue();
    }
}

