/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.event;

import com.min01.crypticfoes.effect.CrypticEffects;
import com.min01.crypticfoes.entity.EntityCameraShake;
import com.min01.crypticfoes.util.CrypticClientUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crypticfoes", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventHandlerForge {
    public static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("crypticfoes", "textures/gui/cryptic_foes_icon.png");

    @SubscribeEvent
    public static void onComputeFovModifier(ComputeFovModifierEvent event) {
        if (CrypticClientUtil.MC.f_91074_.m_21023_((MobEffect)CrypticEffects.STUNNED.get()) && !CrypticClientUtil.MC.f_91074_.m_5833_()) {
            float fov = event.getFovModifier();
            event.setNewFovModifier(fov - 0.5f);
        }
    }

    @SubscribeEvent
    public static void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = CrypticClientUtil.MC.f_91074_;
        float delta = CrypticClientUtil.MC.m_91296_();
        float ticksExistedDelta = (float)player.f_19797_ + delta;
        if (player != null) {
            float shakeAmplitude = 0.0f;
            for (EntityCameraShake cameraShake : player.f_19853_.m_45976_(EntityCameraShake.class, player.m_20191_().m_82400_(100.0))) {
                if (!(cameraShake.m_20270_((Entity)player) < cameraShake.getRadius())) continue;
                shakeAmplitude += cameraShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
        }
    }

    @SubscribeEvent
    public static void onInteractionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        if (CrypticClientUtil.MC.f_91074_.m_21023_((MobEffect)CrypticEffects.STUNNED.get()) && !CrypticClientUtil.MC.f_91074_.m_5833_()) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlayEvent(RenderGuiOverlayEvent.Post event) {
        ForgeGui gui = (ForgeGui)CrypticClientUtil.MC.f_91065_;
        if (!CrypticClientUtil.MC.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements() && CrypticClientUtil.MC.f_91074_.m_21023_((MobEffect)CrypticEffects.FRAGILITY.get()) && event.getOverlay() == VanillaGuiOverlay.ARMOR_LEVEL.type()) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            ClientEventHandlerForge.renderFragilityArmor(guiGraphics, guiGraphics.m_280182_(), guiGraphics.m_280206_());
        }
    }

    public static void renderFragilityArmor(GuiGraphics guiGraphics, int width, int height) {
        RenderSystem.enableBlend();
        int left = width / 2 - 91;
        int top = height - 49;
        int level = CrypticClientUtil.MC.f_91074_.m_21230_();
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                guiGraphics.m_280218_(GUI_ICONS_LOCATION, left, top, 34, 9, 9, 9);
            } else if (i == level) {
                guiGraphics.m_280218_(GUI_ICONS_LOCATION, left, top, 25, 9, 9, 9);
            } else if (i > level) {
                guiGraphics.m_280218_(GUI_ICONS_LOCATION, left, top, 16, 9, 9, 9);
            }
            left += 8;
        }
        RenderSystem.disableBlend();
    }
}

