/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.event;

import com.min01.crypticfoes.advancements.CrypticCriteriaTriggers;
import com.min01.crypticfoes.block.FallenLeavesBlock;
import com.min01.crypticfoes.effect.CrypticEffects;
import com.min01.crypticfoes.entity.living.EntityHowler;
import com.min01.crypticfoes.network.CrypticNetwork;
import com.min01.crypticfoes.network.UpdateSilencedBlocksPacket;
import com.min01.crypticfoes.network.UpdateStunnedEffectPacket;
import com.min01.crypticfoes.sound.CrypticSounds;
import com.min01.crypticfoes.util.CrypticUtil;
import com.min01.crypticfoes.world.CrypticSavedData;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crypticfoes", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandlerForge {
    public static final Map<UUID, BlockPos> LEAVES_POS = new WeakHashMap<UUID, BlockPos>();

    @SubscribeEvent
    public static void onPlayLevelSoundAtPosition(PlayLevelSoundEvent.AtPosition event) {
        BlockPos blockPos;
        Holder sound = event.getSound();
        Level level = event.getLevel();
        if (CrypticUtil.isBlockSilenced(level, blockPos = BlockPos.m_274446_((Position)event.getPosition()))) {
            event.setCanceled(true);
        } else if (sound != null) {
            // empty if block
        }
        for (Entity entity : CrypticUtil.getAllEntities(level)) {
            EntityHowler howler;
            if (sound.get() != SoundEvents.f_11699_ || !blockPos.m_203195_((Position)entity.m_20182_(), 40.0) || !(entity instanceof EntityHowler) || !(howler = (EntityHowler)entity).isHowlerSleeping() || howler.getAnimationState() != 1 || howler.f_19853_.m_46472_() != level.m_46472_() || CrypticUtil.isBlockSilenced(level, blockPos)) continue;
            howler.awake();
        }
    }

    @SubscribeEvent
    public static void onPlayLevelSoundAtEntity(PlayLevelSoundEvent.AtEntity event) {
        Holder sound = event.getSound();
        Level level = event.getLevel();
        BlockPos blockPos = event.getEntity().m_20183_();
        if (sound != null) {
            // empty if block
        }
        for (Entity entity : CrypticUtil.getAllEntities(level)) {
            EntityHowler howler;
            if (!((SoundEvent)sound.get()).m_11660_().toString().contains("goat_horn") || !blockPos.m_203195_((Position)entity.m_20182_(), 40.0) || !(entity instanceof EntityHowler) || !(howler = (EntityHowler)entity).isHowlerSleeping() || howler.getAnimationState() != 1 || howler.f_19853_.m_46472_() != level.m_46472_()) continue;
            howler.awake();
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.type == TickEvent.Type.LEVEL) {
            CrypticUtil.removeSilencedBlocks(event.level);
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        Level level = (Level)event.getLevel();
        CrypticSavedData data = CrypticSavedData.get(level);
        if (data != null) {
            CrypticNetwork.sendToAll(new UpdateSilencedBlocksPacket(data.getSilencedBlocks()));
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            BlockPos pos = entity.m_20183_();
            UUID uuid = entity.m_20148_();
            Block block = entity.f_19853_.m_8055_(pos).m_60734_();
            if (block instanceof FallenLeavesBlock) {
                FallenLeavesBlock block2 = (FallenLeavesBlock)block;
                BlockPos leavesPos = LEAVES_POS.get(uuid);
                if (!pos.equals((Object)leavesPos)) {
                    LEAVES_POS.put(uuid, pos);
                    block2.m_141947_(entity.f_19853_, pos, entity.f_19853_.m_8055_(pos), (Entity)entity);
                }
            } else {
                LEAVES_POS.remove(uuid);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)CrypticEffects.STUNNED.get())) {
            entity.m_21195_((MobEffect)CrypticEffects.STUNNED.get());
        }
    }

    @SubscribeEvent
    public static void onMobEffectAdded(MobEffectEvent.Added event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance != null && instance.m_19544_() == CrypticEffects.STUNNED.get() && !living.f_19853_.f_46443_) {
            CrypticNetwork.sendToAll(new UpdateStunnedEffectPacket(living.m_20148_(), instance.m_19564_(), instance.m_19557_(), false));
        }
    }

    @SubscribeEvent
    public static void onMobEffectRemove(MobEffectEvent.Remove event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance != null && instance.m_19544_() == CrypticEffects.STUNNED.get() && !living.f_19853_.f_46443_) {
            CrypticNetwork.sendToAll(new UpdateStunnedEffectPacket(living.m_20148_(), instance.m_19564_(), instance.m_19557_(), true));
        }
    }

    @SubscribeEvent
    public static void onMobEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance != null && instance.m_19544_() == CrypticEffects.STUNNED.get() && !living.f_19853_.f_46443_) {
            CrypticNetwork.sendToAll(new UpdateStunnedEffectPacket(living.m_20148_(), instance.m_19564_(), instance.m_19557_(), true));
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player entity = event.getEntity();
        if (entity.m_21023_((MobEffect)CrypticEffects.STUNNED.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        ItemStack stack = event.getItemStack();
        if (player.m_21023_((MobEffect)CrypticEffects.STUNNED.get())) {
            event.setCanceled(true);
        }
        if (CrypticUtil.isBlockSilenced(level, pos)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CrypticCriteriaTriggers.ITEM_USED_ON_SILENCED_BLOCK.m_285767_(serverPlayer, pos, stack);
            }
            if (stack.canPerformAction(ToolActions.AXE_WAX_OFF)) {
                CrypticUtil.removeSilencedBlock(level, pos);
                BlockState state = level.m_8055_(pos);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                }
                level.m_5594_(player, pos, (SoundEvent)CrypticSounds.SILENCING_BLEND_OFF.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3004, pos, 0);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
                stack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(event.getHand()));
                player.m_6674_(event.getHand());
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_));
            }
        }
    }
}

