/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.item;

import com.min01.crypticfoes.advancements.CrypticCriteriaTriggers;
import com.min01.crypticfoes.entity.CrypticEntities;
import com.min01.crypticfoes.entity.projectile.EntityHowlerScream;
import com.min01.crypticfoes.sound.CrypticSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class MonstrousHornItem
extends Item {
    public MonstrousHornItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        ItemStack stack = p_41433_.m_21120_(p_41434_);
        boolean isScream = MonstrousHornItem.isScream(stack);
        if (!isScream) {
            p_41433_.m_6672_(p_41434_);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_5929_(Level p_41428_, LivingEntity p_41429_, ItemStack p_41430_, int p_41431_) {
        int charge;
        if (p_41431_ % 10 == 0 && (charge = MonstrousHornItem.getHornCharge(p_41430_)) < 6) {
            MonstrousHornItem.setHornCharge(p_41430_, charge + 1);
            MonstrousHornItem.setCurrentHornCharge(p_41430_, charge + 1);
            p_41429_.m_5496_((SoundEvent)CrypticSounds.MONSTROUS_HORN_INHALE.get(), 1.0f, (float)charge / 2.0f);
        }
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        boolean isScream = MonstrousHornItem.isScream(p_41404_);
        if (p_41408_) {
            if (isScream) {
                int stunCount = MonstrousHornItem.getStunCount(p_41404_);
                int charge = MonstrousHornItem.getHornCharge(p_41404_);
                int chargeTick = MonstrousHornItem.getHornChargeTick(p_41404_);
                int tick = MonstrousHornItem.getScreamTick(p_41404_);
                if (chargeTick < charge * 3) {
                    MonstrousHornItem.setScreamTick(p_41404_, tick + 1);
                    if (tick % 2 == 0) {
                        EntityHowlerScream scream = new EntityHowlerScream((EntityType<? extends ThrowableProjectile>)((EntityType)CrypticEntities.HOWLER_SCREAM.get()), p_41405_);
                        scream.m_5602_(p_41406_);
                        scream.m_146884_(p_41406_.m_146892_());
                        scream.m_37251_(p_41406_, p_41406_.m_146909_(), p_41406_.m_146908_(), 0.0f, 0.5f + (float)charge * 0.25f, 1.0f);
                        scream.m_20242_(true);
                        scream.setStunDuration(charge * 20);
                        scream.setRange(0.06f - (float)charge * 5.0E-4f);
                        p_41405_.m_7967_((Entity)scream);
                        MonstrousHornItem.setHornChargeTick(p_41404_, chargeTick + 1);
                        if (Math.random() <= 0.5) {
                            p_41406_.m_216990_((SoundEvent)CrypticSounds.MONSTROUS_HORN_SCREAM.get());
                        }
                    }
                    if (stunCount >= 10 && p_41406_ instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)p_41406_;
                        CrypticCriteriaTriggers.STUNNING_SPEECH.trigger(serverPlayer);
                    }
                } else {
                    MonstrousHornItem.reset(p_41404_, p_41406_);
                }
            }
        } else if (MonstrousHornItem.getHornCharge(p_41404_) > 0) {
            MonstrousHornItem.reset(p_41404_, p_41406_);
        }
    }

    public static void reset(ItemStack stack, Entity entity) {
        MonstrousHornItem.setScream(stack, false);
        MonstrousHornItem.setScreamTick(stack, 0);
        MonstrousHornItem.setHornCharge(stack, 0);
        MonstrousHornItem.setCurrentHornCharge(stack, 0);
        MonstrousHornItem.setHornChargeTick(stack, 0);
        MonstrousHornItem.setStunCount(stack, 0);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36335_().m_41524_(stack.m_41720_(), 140);
        }
    }

    public void m_5551_(ItemStack p_41412_, Level p_41413_, LivingEntity p_41414_, int p_41415_) {
        int charge = MonstrousHornItem.getHornCharge(p_41412_);
        if (charge > 0) {
            MonstrousHornItem.setScream(p_41412_, true);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return newStack.m_41720_() != this;
    }

    public static boolean isScream(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128471_("isScream") : false;
    }

    public static void setScream(ItemStack stack, boolean scream) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("isScream", scream);
    }

    public static int getStunCount(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("StunCount") : 0;
    }

    public static void setStunCount(ItemStack stack, int tick) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("StunCount", tick);
    }

    public static int getScreamTick(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("ScreamTick") : 0;
    }

    public static void setScreamTick(ItemStack stack, int tick) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("ScreamTick", tick);
    }

    public static int getHornChargeTick(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("HornChargeTick") : 0;
    }

    public static void setHornChargeTick(ItemStack stack, int tick) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("HornChargeTick", tick);
        if (tick % 3 == 0) {
            MonstrousHornItem.setCurrentHornCharge(stack, MonstrousHornItem.getCurrentHornCharge(stack) - 1);
        }
    }

    public static int getCurrentHornCharge(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("CurrentHornCharge") : 0;
    }

    public static void setCurrentHornCharge(ItemStack stack, int charge) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("CurrentHornCharge", charge);
    }

    public static int getHornCharge(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("HornCharge") : 0;
    }

    public static void setHornCharge(ItemStack stack, int charge) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("HornCharge", charge);
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.TOOT_HORN;
    }

    public int m_8105_(ItemStack p_41454_) {
        return 72000;
    }
}

