/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.network;

import com.min01.crypticfoes.entity.IPosArray;
import com.min01.crypticfoes.misc.CrypticEntityDataSerializers;
import com.min01.crypticfoes.util.CrypticUtil;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class UpdatePosArrayPacket {
    private final UUID entityUUID;
    private final int array;
    private final Vec3 pos;

    public UpdatePosArrayPacket(Entity entity, Vec3 pos, int array) {
        this.entityUUID = entity.m_20148_();
        this.pos = pos;
        this.array = array;
    }

    public UpdatePosArrayPacket(FriendlyByteBuf buf) {
        this.entityUUID = buf.m_130259_();
        this.pos = CrypticEntityDataSerializers.readVec3((ByteBuf)buf);
        this.array = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
        CrypticEntityDataSerializers.writeVec3(buf, this.pos);
        buf.writeInt(this.array);
    }

    public static class Handler {
        public static boolean onMessage(UpdatePosArrayPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                    Object entity = CrypticUtil.getEntityByUUID(((NetworkEvent.Context)ctx.get()).getSender().f_19853_, message.entityUUID);
                    if (entity instanceof IPosArray) {
                        IPosArray mob = (IPosArray)entity;
                        mob.getPosArray()[message.array] = message.pos;
                    }
                } else {
                    CrypticUtil.getClientLevel(t -> {
                        Object entity = CrypticUtil.getEntityByUUID(t, message.entityUUID);
                        if (entity instanceof IPosArray) {
                            IPosArray mob = (IPosArray)entity;
                            mob.getPosArray()[message.array] = message.pos;
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

