/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.network;

import com.min01.crypticfoes.effect.CrypticEffects;
import com.min01.crypticfoes.util.CrypticUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateStunnedEffectPacket {
    public final UUID entityUUID;
    public final int amplifier;
    public final int duration;
    public final boolean remove;

    public UpdateStunnedEffectPacket(UUID entityUUID, int amplifier, int duration, boolean remove) {
        this.entityUUID = entityUUID;
        this.amplifier = amplifier;
        this.duration = duration;
        this.remove = remove;
    }

    public UpdateStunnedEffectPacket(FriendlyByteBuf buf) {
        this.entityUUID = buf.m_130259_();
        this.amplifier = buf.readInt();
        this.duration = buf.readInt();
        this.remove = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
        buf.writeInt(this.amplifier);
        buf.writeInt(this.duration);
        buf.writeBoolean(this.remove);
    }

    public static class Handler {
        public static boolean onMessage(UpdateStunnedEffectPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    CrypticUtil.getClientLevel(level -> {
                        Object entity = CrypticUtil.getEntityByUUID(level, message.entityUUID);
                        if (entity instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)entity;
                            if (!message.remove) {
                                living.m_7292_(new MobEffectInstance((MobEffect)CrypticEffects.STUNNED.get(), message.duration, message.amplifier));
                            } else if (living.m_21023_((MobEffect)CrypticEffects.STUNNED.get())) {
                                living.m_21195_((MobEffect)CrypticEffects.STUNNED.get());
                            }
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

