/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;

public class CrypticClientUtil {
    public static final Minecraft MC = Minecraft.m_91087_();

    public static void drawQuad(PoseStack stack, VertexConsumer consumer, float size, int packedLightIn, float alpha) {
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 1.0f;
        float maxV = 1.0f;
        PoseStack.Pose matrixstack$entry = stack.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        CrypticClientUtil.drawVertex(matrix4f, matrix3f, consumer, size, size, 0.0f, minU, minV, alpha, packedLightIn);
        CrypticClientUtil.drawVertex(matrix4f, matrix3f, consumer, size, -size, 0.0f, minU, maxV, alpha, packedLightIn);
        CrypticClientUtil.drawVertex(matrix4f, matrix3f, consumer, -size, -size, 0.0f, maxU, maxV, alpha, packedLightIn);
        CrypticClientUtil.drawVertex(matrix4f, matrix3f, consumer, -size, size, 0.0f, maxU, minV, alpha, packedLightIn);
    }

    public static void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_252986_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void animateHead(ModelPart head, float netHeadYaw, float headPitch) {
        head.f_104204_ = (float)((double)head.f_104204_ + Math.toRadians(netHeadYaw));
        head.f_104203_ = (float)((double)head.f_104203_ + Math.toRadians(headPitch));
    }

    public static Vec3 getWorldPositionOfMultiPart(Entity entity, ModelPart root, Vec3 rotation, String ... modelPartName) {
        return CrypticClientUtil.getWorldPosition(entity, root, false, rotation, modelPartName);
    }

    public static Vec3 getWorldPosition(Entity entity, ModelPart root, Vec3 rotation, String ... modelPartName) {
        return CrypticClientUtil.getWorldPosition(entity, root, true, rotation, modelPartName);
    }

    public static Vec3 getWorldPosition(Entity entity, ModelPart root, boolean translateToEntity, Vec3 rotation, String ... modelPartName) {
        PoseStack poseStack = new PoseStack();
        if (translateToEntity) {
            poseStack.m_85837_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        }
        poseStack.m_252781_(new Quaternionf().rotateXYZ((float)Math.toRadians(rotation.f_82479_), (float)Math.toRadians(-rotation.f_82480_ + 180.0), (float)Math.toRadians(rotation.f_82481_)));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        ModelPart nextPart = null;
        for (int i = 0; i < modelPartName.length; ++i) {
            if (i == 0) {
                nextPart = root.m_171324_(modelPartName[0]);
                nextPart.m_104299_(poseStack);
                continue;
            }
            ModelPart child = nextPart.m_171324_(modelPartName[i]);
            child.m_104299_(poseStack);
            nextPart = child;
        }
        PoseStack.Pose last = poseStack.m_85850_();
        Matrix4f matrix4f = last.m_252922_();
        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vector4f.mul((Matrix4fc)matrix4f);
        return new Vec3((double)vector4f.x(), (double)vector4f.y(), (double)vector4f.z());
    }
}

