/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.util;

import com.min01.crypticfoes.network.AddSilencingParticlePacket;
import com.min01.crypticfoes.network.CrypticNetwork;
import com.min01.crypticfoes.world.CrypticSavedData;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class CrypticUtil {
    public static final Method GET_ENTITY = ObfuscationReflectionHelper.findMethod(Level.class, (String)"m_142646_", (Class[])new Class[0]);
    public static final List<BlockPos> SILENCED_BLOCKS = new ArrayList<BlockPos>();

    public static float distanceToY(BlockPos blockPos, BlockPos targetPos) {
        float f = blockPos.m_123342_() - targetPos.m_123342_();
        return Mth.m_14116_((float)(f * f));
    }

    public static float distanceToY(Entity entity, BlockPos pos) {
        float f = (float)(entity.m_20186_() - (double)pos.m_123342_());
        return Mth.m_14116_((float)(f * f));
    }

    public static void setBlockSilence(Level level, BlockPos pos) {
        CrypticSavedData data = CrypticSavedData.get(level);
        if (data != null) {
            data.setBlockSilence(pos);
            CrypticNetwork.sendToAll(new AddSilencingParticlePacket(pos));
        } else {
            SILENCED_BLOCKS.add(pos);
        }
    }

    public static void removeSilencedBlocks(Level level) {
        CrypticSavedData data = CrypticSavedData.get(level);
        if (data != null) {
            data.getSilencedBlocks().removeIf(t -> level.m_8055_(t).m_60795_());
        } else {
            SILENCED_BLOCKS.removeIf(t -> level.m_8055_(t).m_60795_());
        }
    }

    public static void removeSilencedBlock(Level level, BlockPos pos) {
        CrypticSavedData data = CrypticSavedData.get(level);
        if (data != null) {
            data.getSilencedBlocks().removeIf(t -> t.equals((Object)pos));
        } else {
            SILENCED_BLOCKS.removeIf(t -> t.equals((Object)pos));
        }
    }

    public static boolean isBlockSilenced(Level level, BlockPos pos) {
        CrypticSavedData data = CrypticSavedData.get(level);
        if (data != null) {
            return data.isBlockSilenced(level, pos);
        }
        return SILENCED_BLOCKS.contains(pos);
    }

    public static BlockPos getCeilingPos(BlockGetter pLevel, double pX, double startY, double pZ, int aboveY) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(pX, startY, pZ);
        do {
            blockpos$mutable.m_122173_(Direction.UP);
        } while ((pLevel.m_8055_((BlockPos)blockpos$mutable).m_60795_() || pLevel.m_8055_((BlockPos)blockpos$mutable).m_278721_() || !pLevel.m_8055_((BlockPos)blockpos$mutable).m_60838_(pLevel, (BlockPos)blockpos$mutable)) && blockpos$mutable.m_123342_() < pLevel.m_151558_());
        BlockPos pos = blockpos$mutable.m_7494_().m_6630_(aboveY);
        return pos;
    }

    public static BlockPos getGroundPos(BlockGetter pLevel, double pX, double startY, double pZ, int belowY) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(pX, startY, pZ);
        do {
            blockpos$mutable.m_122173_(Direction.DOWN);
        } while ((pLevel.m_8055_((BlockPos)blockpos$mutable).m_60795_() || pLevel.m_8055_((BlockPos)blockpos$mutable).m_278721_() || !pLevel.m_8055_((BlockPos)blockpos$mutable).m_60838_(pLevel, (BlockPos)blockpos$mutable)) && blockpos$mutable.m_123342_() > pLevel.m_141937_());
        BlockPos pos = blockpos$mutable.m_7495_().m_6625_(belowY);
        return pos;
    }

    public static void getClientLevel(Consumer<Level> consumer) {
        ((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).filter(ClientLevel.class::isInstance).ifPresent(level -> consumer.accept((Level)level));
    }

    public static double getMeleeAttackRangeSqr(float width, LivingEntity target, float multiplier) {
        return width * multiplier * width * multiplier + target.m_20205_();
    }

    public static double getMeleeAttackRangeSqr(Entity owner, LivingEntity target, float multiplier) {
        return owner.m_20205_() * multiplier * owner.m_20205_() * multiplier + target.m_20205_();
    }

    public static boolean isWithinMeleeAttackRange(Vec3 pos, float width, LivingEntity target, float multiplier) {
        double d0 = pos.m_82531_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        return d0 <= CrypticUtil.getMeleeAttackRangeSqr(width, target, multiplier);
    }

    public static boolean isWithinMeleeAttackRange(Entity owner, LivingEntity target, float multiplier) {
        double d0 = owner.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        return d0 <= CrypticUtil.getMeleeAttackRangeSqr(owner, target, multiplier);
    }

    public static Vec3 fromToVector(Vec3 from, Vec3 to, float scale) {
        Vec3 motion = to.m_82546_(from).m_82541_();
        return motion.m_82490_((double)scale);
    }

    public static Vec3 getLookPos(Vec2 rotation, Vec3 position, double left, double up, double forwards) {
        Vec2 vec2 = rotation;
        Vec3 vec3 = position;
        float f = Mth.m_14089_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float f4 = Mth.m_14089_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        Vec3 vec31 = new Vec3((double)(f * f2), (double)f3, (double)(f1 * f2));
        Vec3 vec32 = new Vec3((double)(f * f4), (double)f5, (double)(f1 * f4));
        Vec3 vec33 = vec31.m_82537_(vec32).m_82490_(-1.0);
        double d0 = vec31.f_82479_ * forwards + vec32.f_82479_ * up + vec33.f_82479_ * left;
        double d1 = vec31.f_82480_ * forwards + vec32.f_82480_ * up + vec33.f_82480_ * left;
        double d2 = vec31.f_82481_ * forwards + vec32.f_82481_ * up + vec33.f_82481_ * left;
        return new Vec3(vec3.f_82479_ + d0, vec3.f_82480_ + d1, vec3.f_82481_ + d2);
    }

    public static Iterable<Entity> getAllEntities(Level level) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return entities.m_142273_();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends Entity> T getEntityByUUID(Level level, UUID uuid) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return (T)((Entity)entities.m_142694_(uuid));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

