/*
 * Decompiled with CFR 0.152.
 */
package com.min01.crypticfoes.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CrypticSavedData
extends SavedData {
    public static final String NAME = "cryptic_foes_data";
    private final List<BlockPos> blocks = new ArrayList<BlockPos>();

    public static CrypticSavedData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DimensionDataStorage storage = serverLevel.m_8895_();
            CrypticSavedData data = (CrypticSavedData)storage.m_164861_(t -> CrypticSavedData.load(serverLevel, t), CrypticSavedData::new, NAME);
            return data;
        }
        return null;
    }

    public static CrypticSavedData load(ServerLevel level, CompoundTag nbt) {
        CrypticSavedData data = new CrypticSavedData();
        ListTag blocks = nbt.m_128437_("Blocks", 10);
        for (int i = 0; i < blocks.size(); ++i) {
            CompoundTag tag = blocks.m_128728_(i);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag);
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_()) continue;
            data.setBlockSilence(pos);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag blocks = new ListTag();
        this.blocks.forEach(t -> blocks.add((Object)NbtUtils.m_129224_((BlockPos)t)));
        nbt.m_128365_("Blocks", (Tag)blocks);
        return nbt;
    }

    public void setBlockSilence(BlockPos pos) {
        this.blocks.add(pos);
        this.m_77762_();
    }

    public boolean isBlockSilenced(Level level, BlockPos pos) {
        return this.blocks.contains(pos);
    }

    public List<BlockPos> getSilencedBlocks() {
        return this.blocks;
    }
}

