/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8111;
import net.threetag.palladiumcore.event.EntityEvents;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import net.threetag.palladiumcore.event.PlayerEvents;
import net.venturecraft.gliders.common.GliderDamageSource;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.common.item.ItemRegistry;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.util.GliderUtil;
import org.jetbrains.annotations.NotNull;

public class GliderEvents
implements LivingEntityEvents.Attack,
PlayerEvents.Tracking,
LivingEntityEvents.Tick,
EntityEvents.LightningStrike,
LivingEntityEvents.Hurt,
LivingEntityEvents.ItemUse,
PlayerEvents.AnvilUpdate {
    public static void initEvents() {
        GliderEvents instance = new GliderEvents();
        EntityEvents.LIGHTNING_STRIKE.register((Object)instance);
        LivingEntityEvents.HURT.register((Object)instance);
        LivingEntityEvents.ITEM_USE_START.register((Object)instance);
        LivingEntityEvents.ITEM_USE_TICK.register((Object)instance);
        LivingEntityEvents.ITEM_USE_STOP.register((Object)instance);
        LivingEntityEvents.HURT.register((Object)instance);
        PlayerEvents.ANVIL_UPDATE.register((Object)instance);
        PlayerEvents.START_TRACKING.register((Object)instance);
        LivingEntityEvents.TICK.register((Object)instance);
    }

    public void lightningStrike(List<class_1297> entities, class_1538 lightningBolt) {
        for (class_1297 entity : entities) {
            class_1937 class_19372;
            if (!(entity instanceof class_3222)) continue;
            class_3222 player = (class_3222)entity;
            class_1799 chestItem = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((class_1309)player);
            boolean hasCopperMod = GliderItem.hasCopperUpgrade(chestItem);
            boolean isGliding = GliderUtil.isGlidingWithActiveGlider((class_1309)player);
            if (!hasCopperMod && isGliding) {
                GliderItem.setBroken(chestItem, true);
                return;
            }
            if (!hasCopperMod || !isGliding) continue;
            GliderItem.setStruck(chestItem, true);
            if (!GliderItem.hasBeenStruck(chestItem) || !((class_19372 = player.method_37908()) instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)class_19372;
            player.method_5643(GliderDamageSource.getSource(serverLevel, GliderDamageSource.ZAP_EXPERIMENT), 2.0f);
        }
    }

    public EventResult livingEntityItemUse(class_1309 entity, @NotNull class_1799 stack, AtomicInteger duration) {
        return GliderUtil.isGlidingWithActiveGlider(entity) ? EventResult.cancel() : EventResult.pass();
    }

    public EventResult anvilUpdate(class_1657 player, class_1799 left, class_1799 right, String name, AtomicInteger cost, AtomicInteger materialCost, AtomicReference<class_1799> output) {
        class_1792 class_17922 = left.method_7909();
        if (class_17922 instanceof GliderItem) {
            class_1799 data;
            GliderItem gliderItem = (GliderItem)class_17922;
            if (gliderItem.method_7878(left, right)) {
                data = left.method_7972();
                GliderItem.setBroken(data, false);
                data.method_7974(0);
                cost.set(5);
                output.set(data);
            }
            if (right.method_7909() == ItemRegistry.COPPER_UPGRADE.get()) {
                data = left.method_7972();
                data = GliderEvents.makeResult(data, "copper");
                cost.set(10);
                output.set(data);
            }
            if (right.method_7909() == ItemRegistry.NETHER_UPGRADE.get()) {
                data = left.method_7972();
                data = GliderEvents.makeResult(data, "nether");
                cost.set(10);
                output.set(data);
            }
        }
        return EventResult.pass();
    }

    public static class_1799 makeResult(class_1799 base, String upgrade) {
        class_1799 result = base.method_7972();
        result.method_7948().method_10556(upgrade + "_upgrade", true);
        return result;
    }

    public void livingEntityTick(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            GliderData.get((class_1309)player).ifPresent(data -> data.tick((class_1309)player));
        }
    }

    public void playerTracking(class_1657 tracker, class_1297 trackedEntity) {
        if (trackedEntity instanceof class_1657) {
            class_1657 trackedPlayer = (class_1657)trackedEntity;
            if (tracker instanceof class_3222) {
                class_3222 trackerPlayer = (class_3222)tracker;
                GliderData.get((class_1309)trackedPlayer).ifPresent(data -> data.syncTo(trackerPlayer));
            }
        }
    }

    public EventResult livingEntityHurt(class_1309 entity, class_1282 damageSource, AtomicReference<Float> amount) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_1799 chestItem = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((class_1309)player);
            boolean hasCopperMod = GliderItem.hasCopperUpgrade(chestItem);
            boolean isGliding = GliderUtil.isGlidingWithActiveGlider((class_1309)player);
            boolean isLightning = damageSource.method_49708(class_8111.field_42336);
            if (hasCopperMod && isGliding && isLightning) {
                return EventResult.cancel();
            }
        }
        return EventResult.pass();
    }

    public EventResult livingEntityAttack(class_1309 entity, class_1282 damageSource, float amount) {
        class_1297 class_12972 = damageSource.method_5526();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            return GliderUtil.isGlidingWithActiveGlider(livingEntity) ? EventResult.cancel() : EventResult.pass();
        }
        return EventResult.pass();
    }
}

