/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5151;
import net.venturecraft.gliders.util.ModConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GliderItem
extends class_1792
implements class_5151 {
    private final Supplier<class_1799> repair;

    public GliderItem(class_1792.class_1793 itemProperties, Supplier<class_1799> stackSupplier) {
        super(itemProperties);
        this.repair = stackSupplier;
        class_2315.method_10009((class_1935)this, (class_2357)class_1738.field_7879);
    }

    public static boolean isSpaceGlider(class_1799 stack) {
        return stack.method_7954().getString().contains("xwing");
    }

    public static class_1799 setCopper(class_1799 itemStack, boolean copper) {
        class_2487 compound = itemStack.method_7948();
        compound.method_10556("copper_upgrade", copper);
        return itemStack;
    }

    public static boolean hasCopperUpgrade(class_1799 itemStack) {
        class_2487 compound = itemStack.method_7948();
        if (!compound.method_10545("copper_upgrade")) {
            return false;
        }
        return compound.method_10577("copper_upgrade");
    }

    public static class_1799 setNether(class_1799 itemStack, boolean copper) {
        class_2487 compound = itemStack.method_7948();
        compound.method_10556("nether_upgrade", copper);
        return itemStack;
    }

    public static boolean hasNetherUpgrade(class_1799 itemStack) {
        class_2487 compound = itemStack.method_7948();
        if (!compound.method_10545("nether_upgrade")) {
            return false;
        }
        return compound.method_10577("nether_upgrade");
    }

    public static boolean isGlidingEnabled(class_1799 itemStack) {
        class_2487 compound = itemStack.method_7948();
        if (!compound.method_10545("glide")) {
            return false;
        }
        return compound.method_10577("glide") && !GliderItem.isBroken(itemStack);
    }

    public static boolean isTooBroken(class_1799 itemStack) {
        return itemStack.method_7919() >= itemStack.method_7936() - 1;
    }

    public static void setGlide(class_1799 itemStack, boolean canGlide) {
        class_2487 compound = itemStack.method_7948();
        compound.method_10556("glide", canGlide);
    }

    public static void setBroken(class_1799 itemStack, boolean broken) {
        class_2487 compound = itemStack.method_7948();
        compound.method_10556("broken", broken);
    }

    public static boolean isBroken(class_1799 itemStack) {
        class_2487 compound = itemStack.method_7948();
        if (!compound.method_10545("broken")) {
            return false;
        }
        return compound.method_10577("broken");
    }

    public static void setStruck(class_1799 itemStack, boolean isStruck) {
        class_2487 compound = itemStack.method_7948();
        compound.method_10556("struck", isStruck);
    }

    public static boolean hasBeenStruck(class_1799 itemStack) {
        class_2487 compound = itemStack.method_7948();
        if (!compound.method_10545("struck")) {
            return false;
        }
        return compound.method_10577("struck");
    }

    public boolean method_7878(class_1799 stack, class_1799 repairCandidate) {
        return repairCandidate.method_7909() == this.repair.get().method_7909();
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 worldIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        if (GliderItem.hasCopperUpgrade(stack) || GliderItem.hasNetherUpgrade(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)ModConstants.INSTALLED_UPGRADES));
            if (GliderItem.hasCopperUpgrade(stack)) {
                tooltip.add((class_2561)class_2561.method_43470((String)"- ").method_10852((class_2561)class_2561.method_43471((String)ModConstants.COPPER_UPGRADE)));
            }
            if (GliderItem.hasNetherUpgrade(stack)) {
                tooltip.add((class_2561)class_2561.method_43470((String)"- ").method_10852((class_2561)class_2561.method_43471((String)ModConstants.NETHER_UPGRADE)));
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        return this.method_48576(this, level, player, usedHand);
    }

    public class_1304 method_7685() {
        return class_1304.field_6174;
    }

    public class_3414 method_31570() {
        return class_3417.field_14966;
    }
}

