/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.block;

import com.agustinbenitez.indexer.block.entity.DropBoxBlockEntity;
import com.agustinbenitez.indexer.init.ModBlockEntities;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DropBoxBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<BlockPos, Boolean> creativeModeBreaks = new ConcurrentHashMap<BlockPos, Boolean>();

    public DropBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.m_5776_()) {
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof DropBoxBlockEntity) {
                DropBoxBlockEntity dropBox = (DropBoxBlockEntity)entity;
                ((ServerPlayer)player).openMenu((MenuProvider)dropBox, pos);
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DropBoxBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return DropBoxBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.DROP_BOX.get()), (level1, pos, state1, blockEntity) -> blockEntity.tick(level1, pos, state1));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
    }

    public BlockState m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        creativeModeBreaks.put(pos, player.m_150110_().f_35937_);
        return super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            boolean isCreativeBreak;
            Boolean wasCreativeBreak = creativeModeBreaks.remove(pos);
            boolean bl = isCreativeBreak = wasCreativeBreak != null && wasCreativeBreak != false;
            if (!isCreativeBreak) {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof DropBoxBlockEntity) {
                    ((DropBoxBlockEntity)blockEntity).dropContents();
                }
                ItemStack itemStack = new ItemStack((ItemLike)this);
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return DropBoxBlock.m_306223_(DropBoxBlock::new);
    }
}

