/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.block;

import com.agustinbenitez.indexer.block.IndexerControllerBlock;
import com.agustinbenitez.indexer.block.IndexerPipeBlock;
import com.agustinbenitez.indexer.block.entity.IndexerConnectorBlockEntity;
import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.init.ModBlockEntities;
import com.agustinbenitez.indexer.init.ModDataComponents;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class IndexerConnectorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<BlockPos, Boolean> creativeModeBreaks = new ConcurrentHashMap<BlockPos, Boolean>();

    public IndexerConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        if (!IndexerConnectorBlock.hasAdjacentContainer(level, pos = context.m_8083_())) {
            Player player = context.m_43723_();
            if (player != null && !level.f_46443_) {
                player.m_213846_((Component)Component.m_237115_((String)"message.indexer.connector.place_requires_container").m_130940_(ChatFormatting.RED));
            }
            return null;
        }
        boolean isConnected = IndexerConnectorBlock.isConnectedToController(level, pos);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(isConnected));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockEntity adjacentEntity;
            if (!direction.m_122434_().m_122479_() || !((adjacentEntity = level.m_7702_(pos.m_121945_(direction))) instanceof Container) || adjacentEntity instanceof IndexerConnectorBlockEntity) continue;
            return true;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CONNECTED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof IndexerConnectorBlockEntity) {
            ((IndexerConnectorBlockEntity)entity).updateConnectedContainer();
            this.notifyNearbyControllers(level, pos);
        }
        boolean isConnected = IndexerConnectorBlock.isConnectedToController(level, pos);
        if ((Boolean)state.m_61143_((Property)CONNECTED) != isConnected) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CONNECTED, (Comparable)Boolean.valueOf(isConnected)), 3);
        }
    }

    private void notifyNearbyControllers(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        int searchRadius = 16;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    BlockEntity blockEntity = level.m_7702_(checkPos);
                    if (!(blockEntity instanceof IndexerControllerBlockEntity)) continue;
                    IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
                    controller.markNetworkChanged();
                    return;
                }
            }
        }
    }

    protected InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity entity;
        if (!level.m_5776_() && (entity = level.m_7702_(pos)) instanceof IndexerConnectorBlockEntity) {
            ((ServerPlayer)player).openMenu((MenuProvider)((IndexerConnectorBlockEntity)entity), pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new IndexerConnectorBlockEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (level.m_5776_()) {
            return;
        }
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof IndexerConnectorBlockEntity) {
            IndexerConnectorBlockEntity connector = (IndexerConnectorBlockEntity)entity;
            connector.updateConnectedContainer();
            if (connector.getConnectedContainerPos() != null && placer instanceof Player) {
                Player player = (Player)placer;
                player.m_213846_((Component)Component.m_237115_((String)"message.indexer.connector.connected_container"));
            }
            if (stack.m_319951_((DataComponentType)ModDataComponents.CONNECTOR_LEVEL.get())) {
                connector.setConnectorLevel((Integer)stack.m_323252_((DataComponentType)ModDataComponents.CONNECTOR_LEVEL.get()));
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return IndexerConnectorBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.INDEXER_CONNECTOR.get()), IndexerConnectorBlockEntity::tick);
    }

    public BlockState m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        creativeModeBreaks.put(pos, player.m_150110_().f_35937_);
        return super.m_5707_(level, pos, state, player);
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return IndexerConnectorBlock.m_306223_(IndexerConnectorBlock::new);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            boolean isCreativeBreak;
            Boolean wasCreativeBreak = creativeModeBreaks.remove(pos);
            boolean bl = isCreativeBreak = wasCreativeBreak != null && wasCreativeBreak != false;
            if (!isCreativeBreak) {
                IndexerConnectorBlockEntity connectorEntity;
                int connectorLevel;
                IndexerConnectorBlockEntity connectorEntity2;
                ItemStack filterItem;
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof IndexerConnectorBlockEntity && !(filterItem = (connectorEntity2 = (IndexerConnectorBlockEntity)blockEntity).getFilterItem(0)).m_41619_()) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)filterItem);
                }
                ItemStack itemStack = new ItemStack((ItemLike)this);
                if (blockEntity instanceof IndexerConnectorBlockEntity && (connectorLevel = (connectorEntity = (IndexerConnectorBlockEntity)blockEntity).getConnectorLevel()) > 1) {
                    itemStack.m_322496_((DataComponentType)ModDataComponents.CONNECTOR_LEVEL.get(), (Object)connectorLevel);
                }
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public static boolean hasAdjacentContainer(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos;
            BlockEntity adjacentEntity;
            if (!direction.m_122434_().m_122479_() || !((adjacentEntity = level.m_7702_(adjacentPos = pos.m_121945_(direction))) instanceof Container) || adjacentEntity instanceof IndexerConnectorBlockEntity) continue;
            return true;
        }
        return false;
    }

    public static boolean isConnectedToController(Level level, BlockPos pos) {
        if (level == null) {
            return false;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (adjacentState.m_60734_() instanceof IndexerControllerBlock) {
                return true;
            }
            if (!(adjacentState.m_60734_() instanceof IndexerPipeBlock)) continue;
            queue.add(adjacentPos);
            visited.add(adjacentPos);
        }
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = level.m_8055_(currentPos);
            for (Direction direction : Direction.values()) {
                BlockPos nextPos = currentPos.m_121945_(direction);
                if (visited.contains(nextPos)) continue;
                BlockState nextState = level.m_8055_(nextPos);
                Block nextBlock = nextState.m_60734_();
                if (nextBlock instanceof IndexerControllerBlock) {
                    return true;
                }
                if (!(nextBlock instanceof IndexerPipeBlock)) continue;
                boolean currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                boolean nextPipeConnected = (Boolean)nextState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()));
                if (!currentPipeConnected || !nextPipeConnected) continue;
                queue.add(nextPos);
                visited.add(nextPos);
            }
        }
        return false;
    }
}

