/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.block;

import com.agustinbenitez.indexer.block.IndexerConnectorBlock;
import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.init.ModBlocks;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IndexerPipeBlock
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    private static final Map<BlockPos, Boolean> creativeModeBreaks = new ConcurrentHashMap<BlockPos, Boolean>();
    private static final VoxelShape CORE_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape UP_SHAPE = Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public IndexerPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getConnectionState(context.m_43725_(), context.m_8083_());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockState newState = this.getConnectionState(level, pos);
        if (!newState.equals(state)) {
            level.m_7731_(pos, newState, 3);
        }
        this.notifyNearbyControllers(level, pos);
    }

    private void notifyNearbyControllers(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        int searchRadius = 16;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    BlockEntity blockEntity = level.m_7702_(checkPos);
                    if (!(blockEntity instanceof IndexerControllerBlockEntity)) continue;
                    IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
                    controller.markNetworkChanged();
                    return;
                }
            }
        }
        this.notifyNearbyConnectors(level, pos);
    }

    private void notifyNearbyConnectors(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        int searchRadius = 16;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    BlockState blockState = level.m_8055_(checkPos);
                    if (!(blockState.m_60734_() instanceof IndexerConnectorBlock)) continue;
                    boolean isConnected = IndexerConnectorBlock.isConnectedToController(level, checkPos);
                    if ((Boolean)blockState.m_61143_((Property)IndexerConnectorBlock.CONNECTED) == isConnected) continue;
                    level.m_7731_(checkPos, (BlockState)blockState.m_61124_((Property)IndexerConnectorBlock.CONNECTED, (Comparable)Boolean.valueOf(isConnected)), 3);
                }
            }
        }
    }

    private BlockState getConnectionState(Level level, BlockPos pos) {
        boolean north = this.canConnectTo(level, pos, Direction.NORTH);
        boolean east = this.canConnectTo(level, pos, Direction.EAST);
        boolean south = this.canConnectTo(level, pos, Direction.SOUTH);
        boolean west = this.canConnectTo(level, pos, Direction.WEST);
        boolean up = this.canConnectTo(level, pos, Direction.UP);
        boolean down = this.canConnectTo(level, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    private boolean canConnectTo(Level level, BlockPos pos, Direction direction) {
        BlockPos neighborPos = pos.m_121945_(direction);
        BlockState neighborState = level.m_8055_(neighborPos);
        Block neighborBlock = neighborState.m_60734_();
        return neighborBlock == this || neighborBlock == ModBlocks.INDEXER_CONTROLLER.get() || neighborBlock == ModBlocks.INDEXER_CONNECTOR.get() || neighborBlock == ModBlocks.INDEXER_MANAGER.get() || neighborBlock == ModBlocks.DROP_BOX.get() || neighborBlock == ModBlocks.EXTRACTOR.get();
    }

    public static BooleanProperty getPropertyForDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = CORE_SHAPE;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_SHAPE);
        }
        return shape;
    }

    public BlockState m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        creativeModeBreaks.put(pos, player.m_150110_().f_35937_);
        return super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            boolean isCreativeBreak;
            Boolean wasCreativeBreak = creativeModeBreaks.remove(pos);
            boolean bl = isCreativeBreak = wasCreativeBreak != null && wasCreativeBreak != false;
            if (!isCreativeBreak) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

