/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.block.entity;

import com.agustinbenitez.indexer.block.DropBoxBlock;
import com.agustinbenitez.indexer.block.IndexerConnectorBlock;
import com.agustinbenitez.indexer.block.IndexerControllerBlock;
import com.agustinbenitez.indexer.block.IndexerManagerBlock;
import com.agustinbenitez.indexer.block.IndexerPipeBlock;
import com.agustinbenitez.indexer.block.entity.DropBoxBlockEntity;
import com.agustinbenitez.indexer.block.entity.IndexerConnectorBlockEntity;
import com.agustinbenitez.indexer.block.entity.IndexerManagerBlockEntity;
import com.agustinbenitez.indexer.init.ModBlockEntities;
import com.agustinbenitez.indexer.menu.IndexerControllerNetworkMenu;
import com.agustinbenitez.indexer.util.FilterUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class IndexerControllerBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int TRANSFER_COOLDOWN_MAX = 8;
    private static final int DEFAULT_ITEMS_PER_TRANSFER = 1;
    private static final int SEARCH_RANGE = 250;
    private int itemsPerTransfer = 1;
    private int currentUpgradeLevel = 0;
    private boolean enabled = true;
    private int transferCooldown = 0;
    private BlockPos dropContainerPos = null;
    private int previousConnectorCount = 0;
    private boolean hasNotifiedConnection = false;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> {
                    if (IndexerControllerBlockEntity.this.enabled) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> {
                    if (IndexerControllerBlockEntity.this.hasDropContainer()) {
                        yield 1;
                    }
                    yield 0;
                }
                case 2 -> IndexerControllerBlockEntity.this.getConnectedContainersCount();
                case 3 -> IndexerControllerBlockEntity.this.getTotalAvailableSlots();
                case 4 -> IndexerControllerBlockEntity.this.getItemsPerTransfer();
                case 5 -> IndexerControllerBlockEntity.this.getTotalCapacity();
                case 6 -> IndexerControllerBlockEntity.this.getOccupiedSlots();
                case 7 -> IndexerControllerBlockEntity.this.getCurrentUpgradeLevel();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    IndexerControllerBlockEntity.this.enabled = value == 1;
                }
            }
        }

        public int m_6499_() {
            return 8;
        }
    };
    private boolean isBeingUsed = false;
    private boolean networkChanged = true;
    private boolean dropBoxHasItems = false;
    private BlockEntity dropContainerEntity;
    private Set<BlockPos> uniqueContainersCache = null;
    private int totalAvailableSlotsCache = -1;
    private int totalCapacityCache = -1;
    private int occupiedSlotsCache = -1;
    private List<IndexerConnectorBlockEntity> connectorCache = null;

    public IndexerControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.INDEXER_CONTROLLER.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.indexer.controller.network");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new IndexerControllerNetworkMenu(id, inventory, this, this.data);
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    protected void m_318667_(CompoundTag tag, HolderLookup.Provider registries) {
        super.m_318667_(tag, registries);
        this.enabled = tag.m_128471_("Enabled");
        this.transferCooldown = tag.m_128451_("TransferCooldown");
        this.previousConnectorCount = tag.m_128451_("PreviousConnectorCount");
        this.hasNotifiedConnection = tag.m_128471_("HasNotifiedConnection");
        this.itemsPerTransfer = tag.m_128441_("ItemsPerTransfer") ? tag.m_128451_("ItemsPerTransfer") : 1;
        this.currentUpgradeLevel = tag.m_128441_("CurrentUpgradeLevel") ? tag.m_128451_("CurrentUpgradeLevel") : 0;
        if (tag.m_128441_("DropContainerX")) {
            this.dropContainerPos = new BlockPos(tag.m_128451_("DropContainerX"), tag.m_128451_("DropContainerY"), tag.m_128451_("DropContainerZ"));
        }
    }

    protected void m_183515_(CompoundTag tag, HolderLookup.Provider registries) {
        super.m_183515_(tag, registries);
        tag.m_128379_("Enabled", this.enabled);
        tag.m_128405_("TransferCooldown", this.transferCooldown);
        tag.m_128405_("PreviousConnectorCount", this.previousConnectorCount);
        tag.m_128379_("HasNotifiedConnection", this.hasNotifiedConnection);
        tag.m_128405_("ItemsPerTransfer", this.itemsPerTransfer);
        tag.m_128405_("CurrentUpgradeLevel", this.currentUpgradeLevel);
        if (this.dropContainerPos != null) {
            tag.m_128405_("DropContainerX", this.dropContainerPos.m_123341_());
            tag.m_128405_("DropContainerY", this.dropContainerPos.m_123342_());
            tag.m_128405_("DropContainerZ", this.dropContainerPos.m_123343_());
        }
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
        this.m_6596_();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getItemsPerTransfer() {
        return this.itemsPerTransfer;
    }

    public void setItemsPerTransfer(int value) {
        this.itemsPerTransfer = Math.max(1, value);
        this.m_6596_();
    }

    public int getCurrentUpgradeLevel() {
        return this.currentUpgradeLevel;
    }

    public void setCurrentUpgradeLevel(int level) {
        this.currentUpgradeLevel = Math.max(0, Math.min(5, level));
        this.m_6596_();
    }

    public boolean hasDropContainer() {
        if (this.dropContainerPos == null) {
            this.updateDropContainer();
        }
        if (this.dropContainerPos != null && this.f_58857_ != null) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.dropContainerPos);
            return blockEntity instanceof Container && !(blockEntity instanceof IndexerConnectorBlockEntity);
        }
        return false;
    }

    public void updateDropContainer() {
        Level level = this.f_58857_;
        if (level == null) {
            return;
        }
        BlockPos oldDropContainerPos = this.dropContainerPos;
        this.dropContainerPos = null;
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockEntity blockEntity = level.m_7702_(adjacentPos);
            if (!(blockEntity instanceof Container) || blockEntity instanceof IndexerConnectorBlockEntity) continue;
            this.dropContainerPos = adjacentPos;
            if (!adjacentPos.equals((Object)oldDropContainerPos)) {
                this.m_6596_();
                if (this.isBeingUsed) {
                    // empty if block
                }
            }
            return;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (!(adjacentState.m_60734_() instanceof IndexerPipeBlock) || !((Boolean)adjacentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()))).booleanValue()) continue;
            queue.add(adjacentPos);
            visited.add(adjacentPos);
            if (!this.isBeingUsed) continue;
        }
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = level.m_8055_(currentPos);
            BlockEntity blockEntity = level.m_7702_(currentPos);
            if (blockEntity instanceof DropBoxBlockEntity) {
                this.dropContainerPos = currentPos;
                if (!currentPos.equals((Object)oldDropContainerPos)) {
                    this.m_6596_();
                    if (this.isBeingUsed) {
                        // empty if block
                    }
                }
                return;
            }
            for (Direction direction : Direction.values()) {
                boolean currentPipeConnected;
                BlockPos nextPos = currentPos.m_121945_(direction);
                if (visited.contains(nextPos)) continue;
                BlockState nextState = level.m_8055_(nextPos);
                Block nextBlock = nextState.m_60734_();
                if (nextBlock instanceof IndexerPipeBlock) {
                    currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                    boolean nextPipeConnected = (Boolean)nextState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()));
                    if (!currentPipeConnected || !nextPipeConnected) continue;
                    queue.add(nextPos);
                    visited.add(nextPos);
                    continue;
                }
                if (!(nextBlock instanceof DropBoxBlock)) continue;
                boolean bl = currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                if (!currentPipeConnected) continue;
                this.dropContainerPos = nextPos;
                if (!nextPos.equals((Object)oldDropContainerPos)) {
                    this.m_6596_();
                    if (this.isBeingUsed) {
                        // empty if block
                    }
                }
                return;
            }
        }
    }

    public void setDropContainerPos(BlockPos pos) {
        this.dropContainerPos = pos;
        this.m_6596_();
    }

    public void setBeingUsed(boolean beingUsed) {
        this.isBeingUsed = beingUsed;
        if (beingUsed) {
            this.networkChanged = true;
        }
    }

    public void markNetworkChanged() {
        this.networkChanged = true;
        this.connectorCache = null;
        this.uniqueContainersCache = null;
        this.totalAvailableSlotsCache = -1;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, IndexerControllerBlockEntity entity) {
        boolean checkFurnaces;
        if (level.m_5776_()) {
            return;
        }
        boolean checkNetwork = false;
        if (entity.isBeingUsed || entity.networkChanged || level.m_46467_() % 200L == 0L) {
            checkNetwork = true;
            entity.checkConnectionStatus(level);
            entity.updateDropContainer();
            if (entity.dropContainerPos != null) {
                BlockEntity blockEntity = level.m_7702_(entity.dropContainerPos);
                if (!(blockEntity instanceof Container) || blockEntity instanceof IndexerConnectorBlockEntity) {
                    entity.dropContainerPos = null;
                    entity.m_6596_();
                } else if (blockEntity instanceof DropBoxBlockEntity) {
                    DropBoxBlockEntity dropBox = (DropBoxBlockEntity)blockEntity;
                    entity.dropBoxHasItems = dropBox.hasItems();
                }
            }
            entity.networkChanged = false;
        }
        if (!entity.enabled) {
            return;
        }
        if (entity.transferCooldown > 0) {
            --entity.transferCooldown;
            return;
        }
        boolean bl = checkFurnaces = level.m_46467_() % 40L == 0L;
        if (entity.dropBoxHasItems || checkNetwork || checkFurnaces) {
            boolean didTransfer = false;
            if (entity.hasDropContainer()) {
                didTransfer = entity.transferItemsFromDropContainer();
            } else if (checkFurnaces) {
                entity.checkFurnacesOnly();
            }
            if (didTransfer) {
                entity.transferCooldown = 8;
                entity.m_6596_();
            }
        }
    }

    private boolean transferItemsFromDropContainer() {
        Container dropContainer;
        block25: {
            block24: {
                if (this.f_58857_ == null || !this.hasDropContainer()) {
                    return false;
                }
                this.dropContainerEntity = this.f_58857_.m_7702_(this.dropContainerPos);
                BlockEntity blockEntity = this.dropContainerEntity;
                if (!(blockEntity instanceof Container)) break block24;
                dropContainer = (Container)blockEntity;
                if (!(this.dropContainerEntity instanceof IndexerConnectorBlockEntity)) break block25;
            }
            return false;
        }
        List<IndexerConnectorBlockEntity> connectors = this.findConnectors();
        if (connectors.isEmpty()) {
            if (this.isBeingUsed) {
                // empty if block
            }
            return false;
        }
        if (this.isBeingUsed) {
            // empty if block
        }
        boolean transferred = false;
        transferred = this.checkAndRefillFurnaceFuel(connectors, dropContainer) || transferred;
        transferred = this.checkAndRefillFurnaceInput(connectors, dropContainer) || transferred;
        int itemsTransferredThisCycle = 0;
        block0: for (int i = 0; i < dropContainer.m_6643_() && itemsTransferredThisCycle < this.itemsPerTransfer; ++i) {
            int itemsTransferred;
            ItemStack newRemainder;
            int itemsToTransfer;
            ItemStack transferStack;
            ItemStack stack = dropContainer.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.isBeingUsed) {
                // empty if block
            }
            ArrayList<IndexerConnectorBlockEntity> connectorsWithFilter = new ArrayList<IndexerConnectorBlockEntity>();
            ArrayList<IndexerConnectorBlockEntity> connectorsWithoutFilter = new ArrayList<IndexerConnectorBlockEntity>();
            for (IndexerConnectorBlockEntity connector : connectors) {
                if (connector.isItemBlocked(stack) || !connector.canAcceptItem(stack)) continue;
                boolean hasSpecificFilter = false;
                for (ItemStack filterItem : connector.getFilterItems()) {
                    if (filterItem.m_41619_()) continue;
                    hasSpecificFilter = true;
                    break;
                }
                if (hasSpecificFilter) {
                    connectorsWithFilter.add(connector);
                    continue;
                }
                connectorsWithoutFilter.add(connector);
            }
            if (this.isBeingUsed) {
                // empty if block
            }
            boolean itemTransferred = false;
            ItemStack remainder = stack.m_41777_();
            for (IndexerConnectorBlockEntity connector : connectorsWithFilter) {
                if (this.isBeingUsed) {
                    // empty if block
                }
                transferStack = remainder.m_41777_();
                itemsToTransfer = Math.min(transferStack.m_41613_(), this.itemsPerTransfer);
                transferStack.m_41764_(itemsToTransfer);
                newRemainder = connector.insertItem(transferStack);
                if (newRemainder.m_41613_() < transferStack.m_41613_()) {
                    itemsTransferred = transferStack.m_41613_() - newRemainder.m_41613_();
                    remainder.m_41774_(itemsTransferred);
                    dropContainer.m_6836_(i, remainder);
                    if (this.isBeingUsed) {
                        // empty if block
                    }
                    transferred = true;
                    itemTransferred = true;
                    itemsTransferredThisCycle += itemsTransferred;
                    if (remainder.m_41619_()) break;
                }
                if (itemsTransferredThisCycle < this.itemsPerTransfer) continue;
                break;
            }
            if (remainder.m_41619_() || connectorsWithoutFilter.isEmpty() || !connectorsWithFilter.isEmpty() || itemsTransferredThisCycle >= this.itemsPerTransfer) continue;
            for (IndexerConnectorBlockEntity connector : connectorsWithoutFilter) {
                if (this.isBeingUsed) {
                    // empty if block
                }
                transferStack = remainder.m_41777_();
                itemsToTransfer = Math.min(transferStack.m_41613_(), this.itemsPerTransfer);
                transferStack.m_41764_(itemsToTransfer);
                newRemainder = connector.insertItem(transferStack);
                if (newRemainder.m_41613_() < transferStack.m_41613_()) {
                    itemsTransferred = transferStack.m_41613_() - newRemainder.m_41613_();
                    remainder.m_41774_(itemsTransferred);
                    dropContainer.m_6836_(i, remainder);
                    if (this.isBeingUsed) {
                        // empty if block
                    }
                    transferred = true;
                    itemTransferred = true;
                    itemsTransferredThisCycle += itemsTransferred;
                    if (remainder.m_41619_()) continue block0;
                }
                if (itemsTransferredThisCycle < this.itemsPerTransfer) continue;
                continue block0;
            }
        }
        if (transferred && this.dropContainerEntity instanceof DropBoxBlockEntity) {
            this.dropBoxHasItems = ((DropBoxBlockEntity)this.dropContainerEntity).hasItems();
        }
        if (transferred) {
            this.markNetworkChanged();
            for (IndexerManagerBlockEntity manager : this.findManagers()) {
                manager.syncOpenPlayers();
            }
        }
        return transferred;
    }

    public int getConnectedContainersCount() {
        if (!this.networkChanged && this.uniqueContainersCache != null) {
            return this.uniqueContainersCache.size();
        }
        this.updateContainerCache();
        return this.uniqueContainersCache.size();
    }

    public int getTotalAvailableSlots() {
        if (!this.networkChanged && this.totalAvailableSlotsCache >= 0) {
            return this.totalAvailableSlotsCache;
        }
        this.updateContainerCache();
        return this.totalAvailableSlotsCache;
    }

    public int getTotalCapacity() {
        if (!this.networkChanged && this.totalCapacityCache >= 0) {
            return this.totalCapacityCache;
        }
        this.updateContainerCache();
        return this.totalCapacityCache;
    }

    public int getOccupiedSlots() {
        if (!this.networkChanged && this.occupiedSlotsCache >= 0) {
            return this.occupiedSlotsCache;
        }
        this.updateContainerCache();
        return this.occupiedSlotsCache;
    }

    private void updateContainerCache() {
        List<IndexerConnectorBlockEntity> connectors = this.findConnectors();
        HashSet<BlockPos> uniqueContainers = new HashSet<BlockPos>();
        int totalSlots = 0;
        int totalCapacity = 0;
        int occupiedSlots = 0;
        for (IndexerConnectorBlockEntity connector : connectors) {
            BlockPos containerPos = connector.getConnectedContainerPos();
            if (containerPos == null || uniqueContainers.contains(containerPos)) continue;
            uniqueContainers.add(containerPos);
            BlockEntity containerEntity = this.f_58857_.m_7702_(containerPos);
            if (!(containerEntity instanceof Container)) continue;
            Container container = (Container)containerEntity;
            int containerSize = container.m_6643_();
            totalCapacity += containerSize;
            for (int i = 0; i < containerSize; ++i) {
                if (container.m_8020_(i).m_41619_()) {
                    ++totalSlots;
                    continue;
                }
                ++occupiedSlots;
            }
        }
        this.uniqueContainersCache = uniqueContainers;
        this.totalAvailableSlotsCache = totalSlots;
        this.totalCapacityCache = totalCapacity;
        this.occupiedSlotsCache = occupiedSlots;
    }

    private boolean checkAndRefillFurnaceFuel(List<IndexerConnectorBlockEntity> connectors, Container dropContainer) {
        if (this.f_58857_ == null) {
            return false;
        }
        boolean transferred = false;
        block0: for (IndexerConnectorBlockEntity connector : connectors) {
            ItemStack fuelSlotStack;
            boolean needsRefill;
            BlockEntity containerEntity;
            BlockPos containerPos = connector.getConnectedContainerPos();
            if (containerPos == null || (containerEntity = this.f_58857_.m_7702_(containerPos)) == null || !containerEntity.getClass().getName().contains("FurnaceBlockEntity") || !(containerEntity instanceof Container)) continue;
            Container furnace = (Container)containerEntity;
            boolean FURNACE_FUEL_SLOT = true;
            if (1 >= furnace.m_6643_() || !(needsRefill = (fuelSlotStack = furnace.m_8020_(1)).m_41619_() || (fuelSlotStack.m_41720_().m_5524_().equals("item.minecraft.coal") || fuelSlotStack.m_41720_().m_5524_().equals("item.minecraft.charcoal")) && fuelSlotStack.m_41613_() < 64)) continue;
            if (this.isBeingUsed) {
                // empty if block
            }
            boolean foundFuelInDropBox = false;
            if (dropContainer != null) {
                for (int i = 0; i < dropContainer.m_6643_(); ++i) {
                    ItemStack stack = dropContainer.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    boolean isCoalOrCharcoal = stack.m_41720_().m_5524_().equals("item.minecraft.coal") || stack.m_41720_().m_5524_().equals("item.minecraft.charcoal");
                    boolean isLavaBucket = stack.m_41720_().m_5524_().equals("item.minecraft.lava_bucket");
                    if (!isCoalOrCharcoal && !isLavaBucket) continue;
                    if (isLavaBucket) {
                        if (!fuelSlotStack.m_41619_()) continue;
                        ItemStack newStack = stack.m_41777_();
                        newStack.m_41764_(1);
                        furnace.m_6836_(1, newStack);
                        stack.m_41774_(1);
                        if (stack.m_41619_()) {
                            dropContainer.m_6836_(i, ItemStack.f_41583_);
                        } else {
                            dropContainer.m_6836_(i, stack);
                        }
                        if (containerEntity instanceof BlockEntity) {
                            containerEntity.m_6596_();
                        }
                        if (this.dropContainerEntity instanceof BlockEntity) {
                            this.dropContainerEntity.m_6596_();
                        }
                        if (this.isBeingUsed) {
                            // empty if block
                        }
                        transferred = true;
                        foundFuelInDropBox = true;
                        break;
                    }
                    if (!isCoalOrCharcoal) continue;
                    int spaceInFurnace = fuelSlotStack.m_41619_() ? 64 : 64 - fuelSlotStack.m_41613_();
                    int toTransfer = Math.min(stack.m_41613_(), spaceInFurnace);
                    if (toTransfer <= 0) continue;
                    if (fuelSlotStack.m_41619_()) {
                        ItemStack newStack = stack.m_41777_();
                        newStack.m_41764_(toTransfer);
                        furnace.m_6836_(1, newStack);
                    } else {
                        fuelSlotStack.m_41769_(toTransfer);
                    }
                    stack.m_41774_(toTransfer);
                    if (stack.m_41619_()) {
                        dropContainer.m_6836_(i, ItemStack.f_41583_);
                    } else {
                        dropContainer.m_6836_(i, stack);
                    }
                    if (containerEntity instanceof BlockEntity) {
                        containerEntity.m_6596_();
                    }
                    if (this.dropContainerEntity instanceof BlockEntity) {
                        this.dropContainerEntity.m_6596_();
                    }
                    if (this.isBeingUsed) {
                        // empty if block
                    }
                    transferred = true;
                    foundFuelInDropBox = true;
                    break;
                }
            }
            if (foundFuelInDropBox) continue;
            for (IndexerConnectorBlockEntity chestConnector : connectors) {
                BlockEntity chestEntity;
                BlockPos chestPos = chestConnector.getConnectedContainerPos();
                if (chestPos == null || (chestEntity = this.f_58857_.m_7702_(chestPos)) == null || !(chestEntity instanceof Container)) continue;
                Container chest = (Container)chestEntity;
                if (chestEntity.getClass().getName().contains("FurnaceBlockEntity")) continue;
                for (int i = 0; i < chest.m_6643_(); ++i) {
                    ItemStack stack = chest.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    boolean isCoalOrCharcoal = stack.m_41720_().m_5524_().equals("item.minecraft.coal") || stack.m_41720_().m_5524_().equals("item.minecraft.charcoal");
                    boolean isLavaBucket = stack.m_41720_().m_5524_().equals("item.minecraft.lava_bucket");
                    if (!isCoalOrCharcoal && !isLavaBucket) continue;
                    if (isLavaBucket) {
                        if (!fuelSlotStack.m_41619_()) continue;
                        ItemStack newStack = stack.m_41777_();
                        newStack.m_41764_(1);
                        furnace.m_6836_(1, newStack);
                        stack.m_41774_(1);
                        if (stack.m_41619_()) {
                            chest.m_6836_(i, ItemStack.f_41583_);
                        } else {
                            chest.m_6836_(i, stack);
                        }
                        if (containerEntity instanceof BlockEntity) {
                            containerEntity.m_6596_();
                        }
                        if (chestEntity instanceof BlockEntity) {
                            chestEntity.m_6596_();
                        }
                        if (this.isBeingUsed) {
                            // empty if block
                        }
                        transferred = true;
                        break;
                    }
                    if (!isCoalOrCharcoal) continue;
                    int spaceInFurnace = fuelSlotStack.m_41619_() ? 64 : 64 - fuelSlotStack.m_41613_();
                    int toTransfer = Math.min(stack.m_41613_(), spaceInFurnace);
                    if (toTransfer <= 0) continue;
                    if (fuelSlotStack.m_41619_()) {
                        ItemStack newStack = stack.m_41777_();
                        newStack.m_41764_(toTransfer);
                        furnace.m_6836_(1, newStack);
                    } else {
                        fuelSlotStack.m_41769_(toTransfer);
                    }
                    stack.m_41774_(toTransfer);
                    if (stack.m_41619_()) {
                        chest.m_6836_(i, ItemStack.f_41583_);
                    } else {
                        chest.m_6836_(i, stack);
                    }
                    if (containerEntity instanceof BlockEntity) {
                        containerEntity.m_6596_();
                    }
                    if (chestEntity instanceof BlockEntity) {
                        chestEntity.m_6596_();
                    }
                    if (this.isBeingUsed) {
                        // empty if block
                    }
                    transferred = true;
                    break;
                }
                if (!transferred) continue;
                continue block0;
            }
        }
        if (transferred && this.dropContainerEntity instanceof DropBoxBlockEntity) {
            this.dropBoxHasItems = ((DropBoxBlockEntity)this.dropContainerEntity).hasItems();
        }
        return transferred;
    }

    private boolean checkAndRefillFurnaceInput(List<IndexerConnectorBlockEntity> connectors, Container dropContainer) {
        if (this.f_58857_ == null) {
            return false;
        }
        boolean transferred = false;
        block0: for (IndexerConnectorBlockEntity furnaceConnector : connectors) {
            boolean hasSpace;
            BlockEntity furnaceEntity;
            BlockPos furnacePos = furnaceConnector.getConnectedContainerPos();
            if (furnacePos == null || (furnaceEntity = this.f_58857_.m_7702_(furnacePos)) == null || !furnaceEntity.getClass().getName().contains("FurnaceBlockEntity") || !(furnaceEntity instanceof Container)) continue;
            Container furnace = (Container)furnaceEntity;
            boolean FURNACE_INPUT_SLOT = false;
            if (0 >= furnace.m_6643_()) continue;
            ItemStack inputSlotStack = furnace.m_8020_(0);
            ItemStack filterItem = furnaceConnector.getFilterItem(0);
            if (filterItem.m_41619_()) continue;
            boolean bl = hasSpace = inputSlotStack.m_41619_() || FilterUtils.passesFilter(inputSlotStack, filterItem) && inputSlotStack.m_41613_() < inputSlotStack.m_41741_();
            if (!hasSpace) continue;
            boolean filledFromDropBox = false;
            if (dropContainer != null) {
                for (int i = 0; i < dropContainer.m_6643_(); ++i) {
                    ItemStack stack = dropContainer.m_8020_(i);
                    if (stack.m_41619_() || !FilterUtils.passesFilter(stack, filterItem)) continue;
                    int spaceInFurnace = inputSlotStack.m_41619_() ? stack.m_41741_() : inputSlotStack.m_41741_() - inputSlotStack.m_41613_();
                    int toTransfer = Math.min(stack.m_41613_(), spaceInFurnace);
                    if (toTransfer <= 0) continue;
                    if (inputSlotStack.m_41619_()) {
                        ItemStack newStack = stack.m_41777_();
                        newStack.m_41764_(toTransfer);
                        furnace.m_6836_(0, newStack);
                    } else {
                        inputSlotStack.m_41769_(toTransfer);
                    }
                    stack.m_41774_(toTransfer);
                    dropContainer.m_6836_(i, stack.m_41619_() ? ItemStack.f_41583_ : stack);
                    if (furnaceEntity instanceof BlockEntity) {
                        furnaceEntity.m_6596_();
                    }
                    if (this.dropContainerEntity instanceof BlockEntity) {
                        this.dropContainerEntity.m_6596_();
                    }
                    transferred = true;
                    filledFromDropBox = true;
                    break;
                }
            }
            if (filledFromDropBox) continue;
            for (IndexerConnectorBlockEntity chestConnector : connectors) {
                BlockEntity chestEntity;
                BlockPos chestPos = chestConnector.getConnectedContainerPos();
                if (chestPos == null || chestPos.equals((Object)furnacePos) || (chestEntity = this.f_58857_.m_7702_(chestPos)) == null) continue;
                if (chestEntity instanceof Container) {
                    Container chest = (Container)chestEntity;
                    if (!chestEntity.getClass().getName().contains("FurnaceBlockEntity")) {
                        for (int i = 0; i < chest.m_6643_(); ++i) {
                            ItemStack stack = chest.m_8020_(i);
                            if (stack.m_41619_() || !FilterUtils.passesFilter(stack, filterItem)) continue;
                            int spaceInFurnace = inputSlotStack.m_41619_() ? stack.m_41741_() : inputSlotStack.m_41741_() - inputSlotStack.m_41613_();
                            int toTransfer = Math.min(stack.m_41613_(), spaceInFurnace);
                            if (toTransfer <= 0) continue;
                            if (inputSlotStack.m_41619_()) {
                                ItemStack newStack = stack.m_41777_();
                                newStack.m_41764_(toTransfer);
                                furnace.m_6836_(0, newStack);
                            } else {
                                inputSlotStack.m_41769_(toTransfer);
                            }
                            stack.m_41774_(toTransfer);
                            chest.m_6836_(i, stack.m_41619_() ? ItemStack.f_41583_ : stack);
                            if (furnaceEntity instanceof BlockEntity) {
                                furnaceEntity.m_6596_();
                            }
                            if (chestEntity instanceof BlockEntity) {
                                chestEntity.m_6596_();
                            }
                            transferred = true;
                            break;
                        }
                    }
                }
                if (!transferred) continue;
                continue block0;
            }
        }
        if (transferred && this.dropContainerEntity instanceof DropBoxBlockEntity) {
            this.dropBoxHasItems = ((DropBoxBlockEntity)this.dropContainerEntity).hasItems();
        }
        return transferred;
    }

    private void checkConnectionStatus(Level level) {
        List<IndexerConnectorBlockEntity> connectors = this.findConnectors();
        int currentConnectorCount = connectors.size();
        if (currentConnectorCount != this.previousConnectorCount) {
            if (currentConnectorCount > this.previousConnectorCount) {
                this.hasNotifiedConnection = true;
            } else if (currentConnectorCount == 0) {
                this.hasNotifiedConnection = false;
            }
            this.previousConnectorCount = currentConnectorCount;
            this.m_6596_();
            this.networkChanged = true;
            if (this.isBeingUsed) {
                // empty if block
            }
        }
    }

    public List<IndexerConnectorBlockEntity> findConnectors() {
        if (!this.networkChanged && this.connectorCache != null) {
            return this.connectorCache;
        }
        ArrayList<IndexerConnectorBlockEntity> connectors = new ArrayList<IndexerConnectorBlockEntity>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity;
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockState adjacentState = this.f_58857_.m_8055_(adjacentPos);
            if (adjacentState.m_60734_() instanceof IndexerPipeBlock) {
                if (!((Boolean)adjacentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()))).booleanValue()) continue;
                queue.add(adjacentPos);
                visited.add(adjacentPos);
                continue;
            }
            if (!(adjacentState.m_60734_() instanceof IndexerConnectorBlock) || !((blockEntity = this.f_58857_.m_7702_(adjacentPos)) instanceof IndexerConnectorBlockEntity)) continue;
            connectors.add((IndexerConnectorBlockEntity)blockEntity);
        }
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = this.f_58857_.m_8055_(currentPos);
            BlockEntity blockEntity = this.f_58857_.m_7702_(currentPos);
            if (blockEntity instanceof IndexerConnectorBlockEntity) {
                connectors.add((IndexerConnectorBlockEntity)blockEntity);
                continue;
            }
            for (Direction direction : Direction.values()) {
                BlockEntity nextEntity;
                boolean currentPipeConnected;
                BlockPos nextPos = currentPos.m_121945_(direction);
                if (visited.contains(nextPos)) continue;
                BlockState nextState = this.f_58857_.m_8055_(nextPos);
                Block nextBlock = nextState.m_60734_();
                if (nextBlock instanceof IndexerPipeBlock) {
                    currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                    boolean nextPipeConnected = (Boolean)nextState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()));
                    if (!currentPipeConnected || !nextPipeConnected) continue;
                    queue.add(nextPos);
                    visited.add(nextPos);
                    if (!this.isBeingUsed) continue;
                }
                if (!(nextBlock instanceof IndexerConnectorBlock)) continue;
                boolean bl = currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                if (!currentPipeConnected || !((nextEntity = this.f_58857_.m_7702_(nextPos)) instanceof IndexerConnectorBlockEntity)) continue;
                connectors.add((IndexerConnectorBlockEntity)nextEntity);
                visited.add(nextPos);
            }
        }
        this.connectorCache = connectors;
        return connectors;
    }

    private List<IndexerManagerBlockEntity> findManagers() {
        if (this.f_58857_ == null) {
            return new ArrayList<IndexerManagerBlockEntity>();
        }
        ArrayList<IndexerManagerBlockEntity> managers = new ArrayList<IndexerManagerBlockEntity>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockEntity be;
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockState adjacentState = this.f_58857_.m_8055_(adjacentPos);
            if (adjacentState.m_60734_() instanceof IndexerPipeBlock) {
                if (!((Boolean)adjacentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()))).booleanValue()) continue;
                queue.add(adjacentPos);
                visited.add(adjacentPos);
                continue;
            }
            if (!(adjacentState.m_60734_() instanceof IndexerManagerBlock) || !((be = this.f_58857_.m_7702_(adjacentPos)) instanceof IndexerManagerBlockEntity)) continue;
            managers.add((IndexerManagerBlockEntity)be);
        }
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = this.f_58857_.m_8055_(currentPos);
            BlockEntity blockEntity = this.f_58857_.m_7702_(currentPos);
            if (blockEntity instanceof IndexerManagerBlockEntity) {
                managers.add((IndexerManagerBlockEntity)blockEntity);
                continue;
            }
            for (Direction direction : Direction.values()) {
                BlockEntity nextEntity;
                boolean currentPipeConnected;
                BlockPos nextPos = currentPos.m_121945_(direction);
                if (visited.contains(nextPos)) continue;
                BlockState nextState = this.f_58857_.m_8055_(nextPos);
                Block nextBlock = nextState.m_60734_();
                if (nextBlock instanceof IndexerPipeBlock) {
                    currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                    boolean nextPipeConnected = (Boolean)nextState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()));
                    if (!currentPipeConnected || !nextPipeConnected) continue;
                    queue.add(nextPos);
                    visited.add(nextPos);
                    continue;
                }
                if (!(nextBlock instanceof IndexerManagerBlock)) continue;
                boolean bl = currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                if (!currentPipeConnected || !((nextEntity = this.f_58857_.m_7702_(nextPos)) instanceof IndexerManagerBlockEntity)) continue;
                managers.add((IndexerManagerBlockEntity)nextEntity);
                visited.add(nextPos);
            }
        }
        return managers;
    }

    private void checkFurnacesOnly() {
        if (this.f_58857_ == null) {
            return;
        }
        List<IndexerConnectorBlockEntity> connectors = this.findConnectors();
        if (connectors.isEmpty()) {
            return;
        }
        this.checkAndRefillFurnaceFuel(connectors, null);
        this.checkAndRefillFurnaceInput(connectors, null);
    }

    public List<IndexerControllerBlockEntity> findOtherControllers() {
        if (this.f_58857_ == null) {
            return new ArrayList<IndexerControllerBlockEntity>();
        }
        ArrayList<IndexerControllerBlockEntity> otherControllers = new ArrayList<IndexerControllerBlockEntity>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockEntity entity;
            BlockPos adjacentPos = this.f_58858_.m_121945_(direction);
            BlockState adjacentState = this.f_58857_.m_8055_(adjacentPos);
            if (adjacentState.m_60734_() instanceof IndexerControllerBlock && !adjacentPos.equals((Object)this.f_58858_) && (entity = this.f_58857_.m_7702_(adjacentPos)) instanceof IndexerControllerBlockEntity) {
                otherControllers.add((IndexerControllerBlockEntity)entity);
            }
            if (!(adjacentState.m_60734_() instanceof IndexerPipeBlock) || !((Boolean)adjacentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()))).booleanValue()) continue;
            queue.add(adjacentPos);
            visited.add(adjacentPos);
        }
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            BlockState currentState = this.f_58857_.m_8055_(currentPos);
            for (Direction direction : Direction.values()) {
                BlockEntity entity;
                BlockPos nextPos = currentPos.m_121945_(direction);
                if (visited.contains(nextPos) || nextPos.equals((Object)this.f_58858_)) continue;
                BlockState nextState = this.f_58857_.m_8055_(nextPos);
                Block nextBlock = nextState.m_60734_();
                if (nextBlock instanceof IndexerControllerBlock && (entity = this.f_58857_.m_7702_(nextPos)) instanceof IndexerControllerBlockEntity) {
                    otherControllers.add((IndexerControllerBlockEntity)entity);
                    visited.add(nextPos);
                }
                if (!(nextBlock instanceof IndexerPipeBlock)) continue;
                boolean currentPipeConnected = currentState.m_60734_() instanceof IndexerPipeBlock && (Boolean)currentState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction)) != false;
                boolean nextPipeConnected = (Boolean)nextState.m_61143_((Property)IndexerPipeBlock.getPropertyForDirection(direction.m_122424_()));
                if (!currentPipeConnected || !nextPipeConnected) continue;
                queue.add(nextPos);
                visited.add(nextPos);
            }
        }
        return otherControllers;
    }

    public void forceNetworkRefresh() {
        this.connectorCache = null;
        this.uniqueContainersCache = null;
        this.totalAvailableSlotsCache = -1;
        this.totalCapacityCache = -1;
        this.occupiedSlotsCache = -1;
        this.markNetworkChanged();
        this.m_6596_();
    }

    public List<ContainerNetworkInfo> getNetworkContainers() {
        ArrayList<ContainerNetworkInfo> networkContainers = new ArrayList<ContainerNetworkInfo>();
        List<IndexerConnectorBlockEntity> connectors = this.findConnectors();
        for (IndexerConnectorBlockEntity connector : connectors) {
            BlockEntity blockEntity;
            BlockPos connectedPos = connector.getConnectedContainerPos();
            if (connectedPos == null || this.f_58857_ == null || !((blockEntity = this.f_58857_.m_7702_(connectedPos)) instanceof Container)) continue;
            Container container = (Container)blockEntity;
            ContainerNetworkInfo info = new ContainerNetworkInfo();
            info.position = connectedPos;
            info.containerType = this.getContainerTypeName(blockEntity);
            info.maxSlots = container.m_6643_();
            info.itemCount = this.getOccupiedSlots(container);
            info.filters = this.getContainerFilters(connector);
            info.uniqueItems = this.getUniqueItemsWithQuantities(container);
            networkContainers.add(info);
        }
        return networkContainers;
    }

    private String getContainerTypeName(BlockEntity blockEntity) {
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)blockEntity.m_58900_().m_60734_());
        if (blockId != null) {
            String path;
            switch (path = blockId.m_135815_()) {
                case "chest": {
                    return "chest";
                }
                case "furnace": {
                    return "furnace";
                }
                case "blast_furnace": {
                    return "blast_furnace";
                }
                case "smoker": {
                    return "smoker";
                }
                case "barrel": {
                    return "barrel";
                }
                case "shulker_box": {
                    return "shulker_box";
                }
                case "hopper": {
                    return "hopper";
                }
                case "dropper": {
                    return "dropper";
                }
                case "dispenser": {
                    return "dispenser";
                }
                case "brewing_stand": {
                    return "brewing_stand";
                }
            }
            return path;
        }
        String blockName = blockEntity.m_58900_().m_60734_().m_49954_().getString();
        return blockName.substring(blockName.lastIndexOf(46) + 1);
    }

    private int getOccupiedSlots(Container container) {
        int occupied = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (container.m_8020_(i).m_41619_()) continue;
            ++occupied;
        }
        return occupied;
    }

    private Map<String, Integer> getUniqueItemsWithQuantities(Container container) {
        HashMap<String, Integer> uniqueItems = new HashMap<String, Integer>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ResourceLocation itemLocation;
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || (itemLocation = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) == null) continue;
            String itemKey = itemLocation.toString();
            uniqueItems.put(itemKey, uniqueItems.getOrDefault(itemKey, 0) + stack.m_41613_());
        }
        return uniqueItems;
    }

    private List<ItemStack> getContainerFilters(IndexerConnectorBlockEntity connector) {
        ArrayList<ItemStack> filters = new ArrayList<ItemStack>();
        for (int i = 0; i < connector.m_6643_(); ++i) {
            ItemStack filterItem = connector.m_8020_(i);
            if (filterItem.m_41619_()) continue;
            filters.add(filterItem.m_41777_());
        }
        return filters;
    }

    public void openNetworkScreen(ServerPlayer player, BlockPos pos) {
        player.openMenu(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"gui.indexer.controller.network_title");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                return new IndexerControllerNetworkMenu(id, inventory, IndexerControllerBlockEntity.this, IndexerControllerBlockEntity.this.data);
            }
        }, buf -> buf.m_130064_(pos));
    }

    public static class ContainerNetworkInfo {
        public BlockPos position;
        public String containerType;
        public int itemCount;
        public int maxSlots;
        public List<ItemStack> filters = new ArrayList<ItemStack>();
        public Map<String, Integer> uniqueItems = new HashMap<String, Integer>();
    }
}

