/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.item;

import com.agustinbenitez.indexer.IndexerMod;
import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TransferSpeedUpgradeItem
extends Item {
    private final int upgradeLevel;
    private final int transferRate;

    public TransferSpeedUpgradeItem(Item.Properties properties, int upgradeLevel, int transferRate) {
        super(properties);
        this.upgradeLevel = upgradeLevel;
        this.transferRate = transferRate;
    }

    public void m_7373_(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.indexer.transfer_speed_upgrade.tooltip").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"item.indexer.transfer_speed_upgrade.transfers_info", (Object[])new Object[]{this.transferRate}).m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237115_((String)"item.indexer.transfer_speed_upgrade.usage").m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Component.m_237115_((String)"item.indexer.transfer_speed_upgrade.single_use").m_130940_(ChatFormatting.RED));
        super.m_7373_(stack, context, tooltip, flag);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        if (level.m_5776_() || player == null) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IndexerControllerBlockEntity) {
            IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
            int currentLevel = controller.getCurrentUpgradeLevel();
            int requiredLevel = this.upgradeLevel - 1;
            IndexerMod.LOGGER.info("Aplicando mejora - Nivel actual: {}, Nivel requerido: {}, Nivel de esta mejora: {}", new Object[]{currentLevel, requiredLevel, this.upgradeLevel});
            if (currentLevel == this.upgradeLevel) {
                player.m_213846_((Component)Component.m_237115_((String)"message.indexer.upgrade.already_applied").m_130940_(ChatFormatting.YELLOW));
                return InteractionResult.FAIL;
            }
            if (currentLevel > this.upgradeLevel) {
                player.m_213846_((Component)Component.m_237115_((String)"message.indexer.upgrade.already_applied").m_130940_(ChatFormatting.YELLOW));
                return InteractionResult.FAIL;
            }
            if (currentLevel != requiredLevel) {
                player.m_213846_((Component)Component.m_237110_((String)"message.indexer.upgrade.prerequisite_required", (Object[])new Object[]{switch (this.upgradeLevel) {
                    case 1 -> Component.m_237115_((String)"upgrade.indexer.basic");
                    case 2 -> Component.m_237115_((String)"upgrade.indexer.copper");
                    case 3 -> Component.m_237115_((String)"upgrade.indexer.advanced");
                    case 4 -> Component.m_237115_((String)"upgrade.indexer.elite");
                    case 5 -> Component.m_237115_((String)"upgrade.indexer.definitive");
                    default -> Component.m_237113_((String)("nivel " + this.upgradeLevel));
                }, switch (requiredLevel) {
                    case 0 -> Component.m_237115_((String)"upgrade.indexer.none");
                    case 1 -> Component.m_237115_((String)"upgrade.indexer.basic");
                    case 2 -> Component.m_237115_((String)"upgrade.indexer.copper");
                    case 3 -> Component.m_237115_((String)"upgrade.indexer.advanced");
                    case 4 -> Component.m_237115_((String)"upgrade.indexer.elite");
                    default -> Component.m_237113_((String)("nivel " + requiredLevel));
                }}).m_130940_(ChatFormatting.RED));
                return InteractionResult.FAIL;
            }
            try {
                controller.setItemsPerTransfer(this.transferRate);
                controller.setCurrentUpgradeLevel(this.upgradeLevel);
                Field cooldownField = IndexerControllerBlockEntity.class.getDeclaredField("transferCooldown");
                cooldownField.setAccessible(true);
                cooldownField.setInt((Object)controller, 0);
                controller.m_6596_();
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                IndexerMod.LOGGER.error("Error al aplicar mejora de velocidad: " + e.getMessage());
                player.m_213846_((Component)Component.m_237115_((String)"message.indexer.upgrade.error").m_130940_(ChatFormatting.RED));
                return InteractionResult.FAIL;
            }
            player.m_213846_((Component)Component.m_237110_((String)"message.indexer.upgrade.success", (Object[])new Object[]{this.transferRate}).m_130940_(ChatFormatting.GREEN));
            player.m_213846_((Component)Component.m_237115_((String)"message.indexer.upgrade.transfer_starts").m_130940_(ChatFormatting.AQUA));
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        player.m_213846_((Component)Component.m_237115_((String)"message.indexer.upgrade.controller_only").m_130940_(ChatFormatting.RED));
        return InteractionResult.FAIL;
    }
}

