/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.network;

import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.screen.IndexerControllerNetworkScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.DistExecutor;

public record ContainerListUpdatePacket(List<NetworkContainerData> containers) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ContainerListUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.m_339182_((String)"indexer", (String)"container_list_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ContainerListUpdatePacket> STREAM_CODEC = StreamCodec.m_322204_((StreamCodec)NetworkContainerData.STREAM_CODEC.m_321801_(ByteBufCodecs.m_324765_()), ContainerListUpdatePacket::containers, ContainerListUpdatePacket::new);

    public static ContainerListUpdatePacket create(List<IndexerControllerBlockEntity.ContainerNetworkInfo> networkContainers) {
        return new ContainerListUpdatePacket(ContainerListUpdatePacket.convert(networkContainers));
    }

    private static List<NetworkContainerData> convert(List<IndexerControllerBlockEntity.ContainerNetworkInfo> networkContainers) {
        ArrayList<NetworkContainerData> list = new ArrayList<NetworkContainerData>();
        for (IndexerControllerBlockEntity.ContainerNetworkInfo info : networkContainers) {
            list.add(new NetworkContainerData(info));
        }
        return list;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> m_293297_() {
        return TYPE;
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            Screen patt0$temp = mc.f_91080_;
            if (patt0$temp instanceof IndexerControllerNetworkScreen) {
                IndexerControllerNetworkScreen screen = (IndexerControllerNetworkScreen)patt0$temp;
                screen.updateContainerListFromServer(this.containers);
            }
        }));
    }

    public static class NetworkContainerData {
        public BlockPos position;
        public String containerType;
        public int itemCount;
        public int maxSlots;
        public List<ItemStack> filters;
        public Map<String, Integer> uniqueItems;
        public static final StreamCodec<RegistryFriendlyByteBuf, NetworkContainerData> STREAM_CODEC = StreamCodec.m_320617_((buf, data) -> data.toBuffer((RegistryFriendlyByteBuf)buf), NetworkContainerData::fromBuffer);

        public NetworkContainerData(IndexerControllerBlockEntity.ContainerNetworkInfo info) {
            this.position = info.position;
            this.containerType = info.containerType;
            this.itemCount = info.itemCount;
            this.maxSlots = info.maxSlots;
            this.filters = new ArrayList<ItemStack>(info.filters);
            this.uniqueItems = new HashMap<String, Integer>(info.uniqueItems);
        }

        public NetworkContainerData() {
            this.filters = new ArrayList<ItemStack>();
            this.uniqueItems = new HashMap<String, Integer>();
        }

        public void toBuffer(RegistryFriendlyByteBuf buf) {
            buf.m_130064_(this.position);
            buf.m_130070_(this.containerType);
            buf.writeInt(this.itemCount);
            buf.writeInt(this.maxSlots);
            buf.writeInt(this.filters.size());
            for (ItemStack itemStack : this.filters) {
                ItemStack.f_315801_.m_318638_((Object)buf, (Object)itemStack);
            }
            buf.writeInt(this.uniqueItems.size());
            for (Map.Entry entry : this.uniqueItems.entrySet()) {
                buf.m_130070_((String)entry.getKey());
                buf.writeInt(((Integer)entry.getValue()).intValue());
            }
        }

        public static NetworkContainerData fromBuffer(RegistryFriendlyByteBuf buf) {
            NetworkContainerData data = new NetworkContainerData();
            data.position = buf.m_130135_();
            data.containerType = buf.m_130277_();
            data.itemCount = buf.readInt();
            data.maxSlots = buf.readInt();
            int filterCount = buf.readInt();
            data.filters = new ArrayList<ItemStack>();
            for (int i = 0; i < filterCount; ++i) {
                data.filters.add((ItemStack)ItemStack.f_315801_.m_318688_((Object)buf));
            }
            int uniqueItemsCount = buf.readInt();
            data.uniqueItems = new HashMap<String, Integer>();
            for (int i = 0; i < uniqueItemsCount; ++i) {
                String itemName = buf.m_130277_();
                int quantity = buf.readInt();
                data.uniqueItems.put(itemName, quantity);
            }
            return data;
        }
    }
}

