/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.network;

import com.agustinbenitez.indexer.block.entity.IndexerManagerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;

public record ExtractItemFromManagerPacket(BlockPos managerPos, ResourceLocation itemId, int count, ItemStack variantStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ExtractItemFromManagerPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.m_339182_((String)"indexer", (String)"extract_item_from_manager"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ExtractItemFromManagerPacket> STREAM_CODEC = StreamCodec.m_319980_((StreamCodec)BlockPos.f_316462_, ExtractItemFromManagerPacket::managerPos, (StreamCodec)ResourceLocation.f_314488_, ExtractItemFromManagerPacket::itemId, (StreamCodec)ByteBufCodecs.f_316612_, ExtractItemFromManagerPacket::count, (StreamCodec)ItemStack.f_315801_, ExtractItemFromManagerPacket::variantStack, ExtractItemFromManagerPacket::new);

    public static ExtractItemFromManagerPacket create(BlockPos managerPos, ResourceLocation itemId, int count, ItemStack variantStack) {
        ItemStack copy = variantStack.m_41777_();
        copy.m_41764_(1);
        return new ExtractItemFromManagerPacket(managerPos, itemId, count, copy);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> m_293297_() {
        return TYPE;
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            BlockEntity be;
            ServerPlayer player = context.getSender();
            if (player != null && (be = player.m_9236_().m_7702_(this.managerPos)) instanceof IndexerManagerBlockEntity) {
                IndexerManagerBlockEntity manager = (IndexerManagerBlockEntity)be;
                int moved = manager.extractImmediately(this.itemId, this.count, this.variantStack);
                int remaining = Math.max(0, this.count - moved);
                if (remaining > 0 && !manager.isInventoryFull()) {
                    manager.queueExtraction(this.itemId, remaining, this.variantStack);
                }
                manager.sendItemsTo(player);
            }
        });
    }
}

