/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.network;

import com.agustinbenitez.indexer.block.entity.IndexerControllerBlockEntity;
import com.agustinbenitez.indexer.network.ContainerListUpdatePacket;
import com.agustinbenitez.indexer.network.ModNetworking;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;

public record RefreshNetworkPacket(BlockPos controllerPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RefreshNetworkPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.m_339182_((String)"indexer", (String)"refresh_network"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RefreshNetworkPacket> STREAM_CODEC = StreamCodec.m_322204_((StreamCodec)BlockPos.f_316462_, RefreshNetworkPacket::controllerPos, RefreshNetworkPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> m_293297_() {
        return TYPE;
    }

    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = context.getSender();
            if (player != null && (blockEntity = player.m_9236_().m_7702_(this.controllerPos)) instanceof IndexerControllerBlockEntity) {
                IndexerControllerBlockEntity controller = (IndexerControllerBlockEntity)blockEntity;
                controller.forceNetworkRefresh();
                List<IndexerControllerBlockEntity.ContainerNetworkInfo> containers = controller.getNetworkContainers();
                ModNetworking.sendToPlayer(ContainerListUpdatePacket.create(containers), player);
            }
        });
    }
}

