/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.screen;

import com.agustinbenitez.indexer.init.ModItems;
import com.agustinbenitez.indexer.menu.IndexerManagerMenu;
import com.agustinbenitez.indexer.network.CancelExtractionFromManagerPacket;
import com.agustinbenitez.indexer.network.ExtractItemFromManagerPacket;
import com.agustinbenitez.indexer.network.ManagerItemsUpdatePacket;
import com.agustinbenitez.indexer.network.ModNetworking;
import com.agustinbenitez.indexer.network.RequestManagerItemsPacket;
import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;

public class IndexerManagerScreen
extends AbstractContainerScreen<IndexerManagerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/indexer_manager.png");
    private static final ResourceLocation FILTER_CUANTITY_ICON = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/filter_cuantity.png");
    private static final ResourceLocation FILTER_AZ_ICON = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/filter_az.png");
    private static final ResourceLocation FILTER_BLOCK_ICON = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/filter_block.png");
    private static final ResourceLocation FILTER_ITEM_ICON = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/filter_item.png");
    private static final ResourceLocation FILTER_MOD_ICON = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/filter_mods.png");
    private static final ResourceLocation CONTROL_STACK_ICON = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/controllstack.png");
    private static final ResourceLocation CONTROL_CLICK_ICON = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/controllclick.png");
    private static final ResourceLocation CONTROL_CLICK_RIGHT_ICON = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/controllclickright.png");
    private static final int STATS_PANEL_WIDTH = 100;
    private EditBox searchBox;
    private final List<ItemVariantEntry> items = new ArrayList<ItemVariantEntry>();
    private final List<ItemVariantEntry> filtered = new ArrayList<ItemVariantEntry>();
    private int scrollRowOffset = 0;
    private boolean draggingScrollbar = false;
    private String searchPlaceholder = "";
    private int failX = -1;
    private int failY = -1;
    private int failTicks = 0;
    private boolean sortMenuOpen = false;
    private SortMode currentSort = SortMode.NONE;
    private int filterBtnX = 0;
    private int filterBtnY = 0;

    public IndexerManagerScreen(IndexerManagerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 276;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        int x = this.f_97735_ + 8;
        int y = this.f_97736_ + 6;
        this.searchBox = new EditBox(this.f_96547_, x, y, 120, 12, (Component)Component.m_237113_((String)""));
        this.searchPlaceholder = Component.m_237115_((String)"gui.indexer.manager.search_placeholder").getString();
        this.searchBox.m_94167_(this.searchPlaceholder);
        this.searchBox.m_94151_(s -> this.updateSuggestion());
        this.m_142416_((GuiEventListener)this.searchBox);
        ModNetworking.sendToServer(new RequestManagerItemsPacket(((IndexerManagerMenu)this.f_97732_).getBlockEntity().m_58899_()));
        this.filterBtnX = x + 124;
        this.filterBtnY = y;
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, 176, this.f_97727_);
        int statsX = this.f_97735_ + 176;
        int panelBottom = this.f_97736_ + (int)((float)this.f_97727_ * 0.8f);
        graphics.m_280509_(statsX, this.f_97736_, statsX + 100, panelBottom, -1072689136);
        this.renderStats(graphics, mouseX, mouseY);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int maxRowOffset;
        this.m_280273_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        boolean isConnected = ((IndexerManagerMenu)this.f_97732_).isControllerConnected();
        if (this.searchBox != null) {
            this.searchBox.m_94194_(isConnected);
        }
        if (!isConnected) {
            this.filtered.clear();
            int areaX = this.f_97735_ + 8;
            int areaW = 160;
            int areaY = this.f_97736_ + 24;
            MutableComponent errorText = Component.m_237115_((String)"gui.indexer.manager.controller_not_found");
            int textWidth = this.f_96547_.m_92852_((FormattedText)errorText);
            int tx = areaX + (areaW - textWidth) / 2;
            int ty = areaY + 20;
            graphics.m_280614_(this.f_96547_, (Component)errorText, tx, ty, 0xFF5555, false);
            super.m_280072_(graphics, mouseX, mouseY);
            return;
        }
        String query = this.searchBox.m_94155_() == null ? "" : this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        this.filtered.clear();
        for (ItemVariantEntry e : this.items) {
            String name = Component.m_237115_((String)e.stack.m_41720_().m_5524_()).getString().toLowerCase(Locale.ROOT);
            String idStr = BuiltInRegistries.f_257033_.m_7981_((Object)e.stack.m_41720_()).toString();
            String enchTokens = this.getEnchantSearchTokens(e.stack);
            if (!query.isEmpty() && !idStr.toLowerCase(Locale.ROOT).contains(query) && !name.contains(query) && !enchTokens.contains(query)) continue;
            this.filtered.add(e);
        }
        this.sortFiltered();
        int areaX = this.f_97735_ + 8;
        int areaY = this.f_97736_ + 24;
        int areaW = 160;
        if (this.filtered.isEmpty()) {
            MutableComponent emptyText = Component.m_237115_((String)"gui.indexer.controller.container_empty");
            int textWidth = this.f_96547_.m_92852_((FormattedText)emptyText);
            int tx = areaX + (areaW - textWidth) / 2;
            int ty = areaY + 5;
            graphics.m_280614_(this.f_96547_, (Component)emptyText, tx, ty, 0xFFFFFF, false);
        }
        int areaH = 60;
        int itemSpacing = 20;
        int itemsPerRow = Math.max(1, areaW / itemSpacing);
        int visibleRows = Math.max(1, areaH / itemSpacing);
        int totalRows = (int)Math.ceil((double)this.filtered.size() / (double)itemsPerRow);
        if (this.scrollRowOffset < 0) {
            this.scrollRowOffset = 0;
        }
        if (this.scrollRowOffset > (maxRowOffset = Math.max(0, totalRows - visibleRows))) {
            this.scrollRowOffset = maxRowOffset;
        }
        int startIndex = this.scrollRowOffset * itemsPerRow;
        int endIndex = Math.min(this.filtered.size(), startIndex + visibleRows * itemsPerRow);
        int idx = 0;
        boolean overMenu = false;
        if (this.sortMenuOpen) {
            int menuX = this.filterBtnX - 2;
            int itemH = 12;
            int itemsCount = 5;
            int menuW = 120;
            int menuH = itemH * itemsCount + 6;
            int belowY = this.filterBtnY + 18;
            int aboveY = this.filterBtnY - menuH - 2;
            int menuY = belowY;
            if (menuY + menuH > this.f_97736_ + this.f_97727_ - 8) {
                menuY = aboveY;
            }
            overMenu = mouseX >= menuX && mouseX <= menuX + menuW && mouseY >= menuY && mouseY <= menuY + menuH;
        }
        ArrayList<MutableComponent> tooltipToRender = null;
        for (int i = startIndex; i < endIndex; ++i) {
            ItemVariantEntry e = this.filtered.get(i);
            int col = idx % itemsPerRow;
            int row = idx / itemsPerRow;
            int ix = areaX + col * itemSpacing;
            int iy = areaY + row * itemSpacing;
            ItemStack stack = e.stack.m_41777_();
            graphics.m_280480_(stack, ix, iy);
            if (e.pending && !overMenu) {
                long gt = Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_46467_() : System.currentTimeMillis() / 50L;
                int animPeriod = 20;
                int offset = (int)((double)(gt % (long)animPeriod) * (16.0 / (double)animPeriod));
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, 190.0f);
                graphics.m_280509_(ix, iy, ix + 16, iy + 16, 0x40202020);
                int fillHeight = Math.min(16, offset);
                graphics.m_280509_(ix + 1, iy + 15 - fillHeight, ix + 15, iy + 15, -2144097537);
                graphics.m_280168_().m_85849_();
            }
            String countStr = this.formatCount(e.count);
            graphics.m_280302_(this.f_96547_, stack, ix, iy, countStr);
            if (!overMenu && mouseX >= ix && mouseX < ix + 16 && mouseY >= iy && mouseY < iy + 16) {
                List items;
                ItemContainerContents container;
                ItemEnchantments storedEnchantments;
                tooltipToRender = new ArrayList<MutableComponent>();
                boolean full = this.isManagerInventoryFull();
                if (!stack.m_41619_()) {
                    MutableComponent name = Component.m_237113_((String)Component.m_237115_((String)stack.m_41720_().m_5524_()).getString());
                    tooltipToRender.add(full ? name.m_130940_(ChatFormatting.RED) : name);
                }
                tooltipToRender.add(Component.m_237113_((String)("x" + e.count)));
                ItemEnchantments enchantments = (ItemEnchantments)stack.m_323252_(DataComponents.f_314658_);
                if (enchantments != null) {
                    for (Object2IntMap.Entry entry : enchantments.m_320130_()) {
                        Holder holder = (Holder)entry.getKey();
                        int lvl = entry.getIntValue();
                        String nameTxt = ((Enchantment)holder.m_203334_()).f_337607_().getString();
                        String lvlTxt = Component.m_237115_((String)("enchantment.level." + lvl)).getString();
                        tooltipToRender.add(Component.m_237113_((String)(nameTxt + " " + lvlTxt)));
                    }
                }
                if ((storedEnchantments = (ItemEnchantments)stack.m_323252_(DataComponents.f_314515_)) != null) {
                    for (Object2IntMap.Entry entry : storedEnchantments.m_320130_()) {
                        Holder holder = (Holder)entry.getKey();
                        int lvl = entry.getIntValue();
                        String nameTxt = ((Enchantment)holder.m_203334_()).f_337607_().getString();
                        String lvlTxt = Component.m_237115_((String)("enchantment.level." + lvl)).getString();
                        tooltipToRender.add(Component.m_237113_((String)(nameTxt + " " + lvlTxt)));
                    }
                }
                if ((container = (ItemContainerContents)stack.m_323252_(DataComponents.f_316065_)) != null && !(items = container.m_324244_().toList()).isEmpty()) {
                    tooltipToRender.add(Component.m_237113_((String)"Contents:").m_130940_(ChatFormatting.GRAY));
                    int limit = 5;
                    int countShown = 0;
                    for (ItemStack itemStack : items) {
                        if (itemStack.m_41619_()) continue;
                        if (countShown >= limit) {
                            tooltipToRender.add(Component.m_237113_((String)("... and " + (items.size() - limit) + " more")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
                            break;
                        }
                        MutableComponent line = Component.m_237113_((String)"- ");
                        line.m_7220_((Component)Component.m_237115_((String)itemStack.m_41778_())).m_130946_(" x" + itemStack.m_41613_());
                        tooltipToRender.add(line.m_130940_(ChatFormatting.GRAY));
                        ++countShown;
                    }
                }
            }
            ++idx;
        }
        if (totalRows > visibleRows) {
            int scrollbarWidth = 6;
            int scrollbarX = areaX + areaW - scrollbarWidth + 2;
            int scrollbarY = areaY;
            int scrollbarHeight = areaH;
            graphics.m_280509_(scrollbarX, scrollbarY, scrollbarX + scrollbarWidth, scrollbarY + scrollbarHeight, -15263977);
            int thumbHeight = Math.max(10, visibleRows * scrollbarHeight / totalRows);
            int thumbY = scrollbarY + this.scrollRowOffset * (scrollbarHeight - thumbHeight) / Math.max(1, totalRows - visibleRows);
            graphics.m_280509_(scrollbarX + 1, thumbY, scrollbarX + scrollbarWidth - 1, thumbY + thumbHeight, -13738640);
        }
        if (this.failTicks > 0 && this.failX >= 0 && this.failY >= 0) {
            graphics.m_280137_(this.f_96547_, "X", this.failX, this.failY, 0xFF0000);
            --this.failTicks;
        }
        graphics.m_280163_(switch (this.currentSort.ordinal()) {
            case 2 -> FILTER_AZ_ICON;
            case 3 -> FILTER_BLOCK_ICON;
            case 4 -> FILTER_ITEM_ICON;
            case 5 -> FILTER_MOD_ICON;
            default -> FILTER_CUANTITY_ICON;
        }, this.filterBtnX, this.filterBtnY, 0.0f, 0.0f, 16, 16, 16, 16);
        if (this.sortMenuOpen) {
            int menuX = this.filterBtnX - 2;
            int itemH = 12;
            int itemsCount = 5;
            int menuW = 120;
            int menuH = itemH * itemsCount + 6;
            int belowY = this.filterBtnY + 18;
            int aboveY = this.filterBtnY - menuH - 2;
            int menuY = belowY;
            if (menuY + menuH > this.f_97736_ + this.f_97727_ - 8) {
                menuY = aboveY;
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            graphics.m_280509_(menuX, menuY, menuX + menuW, menuY + menuH, -232775648);
            graphics.m_280509_(menuX, menuY, menuX + menuW, menuY + 1, -13738640);
            graphics.m_280509_(menuX, menuY + menuH - 1, menuX + menuW, menuY + menuH, -13738640);
            int ty = menuY + 4;
            boolean hoverCantidad = mouseX >= menuX && mouseX <= menuX + menuW && mouseY >= ty && mouseY <= ty + itemH;
            this.drawMenuItem(graphics, (Component)Component.m_237115_((String)"gui.indexer.manager.sort_cantidad"), menuX + 6, ty, this.currentSort == SortMode.CANTIDAD, hoverCantidad);
            boolean hoverAlfabeto = mouseX >= menuX && mouseX <= menuX + menuW && mouseY >= (ty += itemH) && mouseY <= ty + itemH;
            this.drawMenuItem(graphics, (Component)Component.m_237115_((String)"gui.indexer.manager.sort_alfabeto"), menuX + 6, ty, this.currentSort == SortMode.ALFABETO, hoverAlfabeto);
            boolean hoverBlock = mouseX >= menuX && mouseX <= menuX + menuW && mouseY >= (ty += itemH) && mouseY <= ty + itemH;
            this.drawMenuItem(graphics, (Component)Component.m_237115_((String)"gui.indexer.manager.sort_block"), menuX + 6, ty, this.currentSort == SortMode.BLOCK, hoverBlock);
            boolean hoverItem = mouseX >= menuX && mouseX <= menuX + menuW && mouseY >= (ty += itemH) && mouseY <= ty + itemH;
            this.drawMenuItem(graphics, (Component)Component.m_237115_((String)"gui.indexer.manager.sort_item"), menuX + 6, ty, this.currentSort == SortMode.ITEM, hoverItem);
            boolean hoverMod = mouseX >= menuX && mouseX <= menuX + menuW && mouseY >= (ty += itemH) && mouseY <= ty + itemH;
            this.drawMenuItem(graphics, (Component)Component.m_237115_((String)"gui.indexer.manager.sort_mod"), menuX + 6, ty, this.currentSort == SortMode.MOD, hoverMod);
            graphics.m_280168_().m_85849_();
        }
        if (tooltipToRender != null) {
            graphics.m_280666_(this.f_96547_, tooltipToRender, mouseX, mouseY);
        }
        super.m_280072_(graphics, mouseX, mouseY);
    }

    private void renderStats(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack upgradeItem;
        int statsX = this.f_97735_ + 176 + 6;
        int statsY = this.f_97736_ + 8;
        MutableComponent statsTitle = Component.m_237115_((String)"gui.indexer.stats");
        guiGraphics.m_280614_(this.f_96547_, (Component)statsTitle, statsX, statsY, 0xFFFFFF, false);
        if (!((IndexerManagerMenu)this.f_97732_).isControllerConnected()) {
            MutableComponent errorText = Component.m_237115_((String)"gui.indexer.manager.controller_not_found");
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)errorText, statsX, statsY += 20, 88, 0xFF5555);
            return;
        }
        int occupiedSlots = ((IndexerManagerMenu)this.f_97732_).getOccupiedSlots();
        int totalCapacity = ((IndexerManagerMenu)this.f_97732_).getTotalCapacity();
        int connectedContainers = ((IndexerManagerMenu)this.f_97732_).getConnectedContainersCount();
        int upgradeLevel = ((IndexerManagerMenu)this.f_97732_).getUpgradeLevel();
        statsY += 15;
        MutableComponent speedText = Component.m_237113_((String)("Speed: " + (switch (upgradeLevel) {
            case 1 -> "x5";
            case 2 -> "x10";
            case 3 -> "x20";
            case 4 -> "x64";
            case 5 -> "x256";
            default -> "x1";
        })));
        int speedColor = upgradeLevel > 0 ? 0x55FF55 : 0xCCCCCC;
        guiGraphics.m_280614_(this.f_96547_, (Component)speedText, statsX, statsY, speedColor, false);
        if (upgradeLevel > 0 && !(upgradeItem = this.getUpgradeItemForLevel(upgradeLevel)).m_41619_()) {
            int textWidth = this.f_96547_.m_92895_(speedText.getString());
            guiGraphics.m_280480_(upgradeItem, statsX + textWidth + 6, statsY - 2);
        }
        MutableComponent capacityTitle = Component.m_237115_((String)"gui.indexer.capacity");
        guiGraphics.m_280614_(this.f_96547_, (Component)capacityTitle, statsX, statsY += 20, 0xFFFFFF, false);
        int barWidth = 88;
        int barHeight = 6;
        guiGraphics.m_280509_(statsX, statsY += 12, statsX + barWidth, statsY + barHeight, -13421773);
        if (totalCapacity > 0) {
            float fillPercentage = (float)occupiedSlots / (float)totalCapacity;
            int fillWidth = (int)((float)barWidth * fillPercentage);
            int barColor = fillPercentage < 0.5f ? -11141291 : (fillPercentage < 0.8f ? -22016 : -43691);
            guiGraphics.m_280509_(statsX, statsY, statsX + fillWidth, statsY + barHeight, barColor);
        }
        statsY += 10;
        String capacityText = occupiedSlots + " / " + totalCapacity;
        if (totalCapacity > 0) {
            int percentage = (int)((float)occupiedSlots / (float)totalCapacity * 100.0f);
            capacityText = capacityText + " (" + percentage + "%)";
        }
        guiGraphics.m_280056_(this.f_96547_, capacityText, statsX, statsY, 0xCCCCCC, false);
        MutableComponent containersTitle = Component.m_237115_((String)"gui.indexer.connected_containers");
        guiGraphics.m_280614_(this.f_96547_, (Component)containersTitle, statsX, statsY += 20, 0xFFFFFF, false);
        MutableComponent containersCount = Component.m_237113_((String)String.valueOf(connectedContainers));
        guiGraphics.m_280614_(this.f_96547_, (Component)containersCount, statsX, statsY += 12, 0xCCCCCC, false);
        statsY += 20;
        float scale = 0.65f;
        int clickW = 16;
        int clickH = 16;
        int stackW = 32;
        int stackH = 16;
        guiGraphics.m_280163_(CONTROL_STACK_ICON, statsX, statsY, 0.0f, 0.0f, stackW, stackH, 32, 16);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.indexer.control.move_stack"), (int)((float)(statsX + stackW + 6) / scale), (int)((float)(statsY + 2) / scale), 0xFFFFFF, false);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280163_(CONTROL_CLICK_ICON, statsX, statsY += stackH + 6, 0.0f, 0.0f, clickW, clickH, 16, 16);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.indexer.control.move_one"), (int)((float)(statsX + clickW + 6) / scale), (int)((float)(statsY + 2) / scale), 0xFFFFFF, false);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280163_(CONTROL_CLICK_RIGHT_ICON, statsX, statsY += clickH + 6, 0.0f, 0.0f, clickW, clickH, 16, 16);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.indexer.control.cancel_stack"), (int)((float)(statsX + clickW + 6) / scale), (int)((float)(statsY + 2) / scale), 0xFFFFFF, false);
        guiGraphics.m_280168_().m_85849_();
    }

    private ItemStack getUpgradeItemForLevel(int level) {
        switch (level) {
            case 0: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_ZERO.get());
            }
            case 1: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_BASIC.get());
            }
            case 2: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_COPPER.get());
            }
            case 3: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_ADVANCED.get());
            }
            case 4: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_ELITE.get());
            }
            case 5: {
                return new ItemStack((ItemLike)ModItems.TRANSFER_SPEED_UPGRADE_DEFINITIVE.get());
            }
        }
        return ItemStack.f_41583_;
    }

    private String formatCount(int value) {
        double base;
        String suffix;
        if (value < 1000) {
            return String.valueOf(value);
        }
        if (value >= 1000000000) {
            suffix = "B";
            base = 1.0E9;
        } else if (value >= 1000000) {
            suffix = "M";
            base = 1000000.0;
        } else {
            suffix = "k";
            base = 1000.0;
        }
        double v = (double)value / base;
        DecimalFormat df = new DecimalFormat(v >= 100.0 ? "#0" : "#.#");
        return df.format(v) + suffix;
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateSuggestion();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_93696_()) {
            if (keyCode == 256 || keyCode == 257 || keyCode == 335) {
                this.searchBox.m_93692_(false);
                this.updateSuggestion();
                return true;
            }
            if (Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
                return true;
            }
            this.searchBox.m_7933_(keyCode, scanCode, modifiers);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void updateSuggestion() {
        if (this.searchBox == null) {
            return;
        }
        boolean show = !this.searchBox.m_93696_() && (this.searchBox.m_94155_() == null || this.searchBox.m_94155_().isEmpty());
        this.searchBox.m_94167_(show ? this.searchPlaceholder : "");
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.filterBtnX && mouseX <= (double)(this.filterBtnX + 12) && mouseY >= (double)this.filterBtnY && mouseY <= (double)(this.filterBtnY + 12)) {
            this.sortMenuOpen = !this.sortMenuOpen;
            return true;
        }
        if (this.sortMenuOpen) {
            int menuX = this.filterBtnX - 2;
            int itemH = 12;
            int itemsCount = 5;
            int menuW = 120;
            int menuH = itemH * itemsCount + 6;
            int belowY = this.filterBtnY + 18;
            int aboveY = this.filterBtnY - menuH - 2;
            int menuY = belowY;
            if (menuY + menuH > this.f_97736_ + this.f_97727_ - 8) {
                menuY = aboveY;
            }
            if (mouseX >= (double)menuX && mouseX <= (double)(menuX + menuW) && mouseY >= (double)menuY && mouseY <= (double)(menuY + menuH)) {
                int idx = (int)((mouseY - (double)(menuY + 4)) / (double)itemH);
                if (idx == 0) {
                    this.currentSort = SortMode.CANTIDAD;
                } else if (idx == 1) {
                    this.currentSort = SortMode.ALFABETO;
                } else if (idx == 2) {
                    this.currentSort = SortMode.BLOCK;
                } else if (idx == 3) {
                    this.currentSort = SortMode.ITEM;
                } else if (idx == 4) {
                    this.currentSort = SortMode.MOD;
                }
                this.sortMenuOpen = false;
                return true;
            }
            this.sortMenuOpen = false;
            return true;
        }
        int areaX = this.f_97735_ + 8;
        int areaY = this.f_97736_ + 24;
        int areaW = 160;
        int areaH = 60;
        int itemSpacing = 20;
        int itemsPerRow = Math.max(1, areaW / itemSpacing);
        int visibleRows = Math.max(1, areaH / itemSpacing);
        int totalRows = (int)Math.ceil((double)this.filtered.size() / (double)itemsPerRow);
        int startIndex = this.scrollRowOffset * itemsPerRow;
        int endIndex = Math.min(this.filtered.size(), startIndex + visibleRows * itemsPerRow);
        int idx = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            int col = idx % itemsPerRow;
            int row = idx / itemsPerRow;
            int ix = areaX + col * itemSpacing;
            int iy = areaY + row * itemSpacing;
            if (mouseX >= (double)ix && mouseX < (double)(ix + 16) && mouseY >= (double)iy && mouseY < (double)(iy + 16)) {
                ItemVariantEntry e = this.filtered.get(i);
                if (e.pending) {
                    ModNetworking.sendToServer(new CancelExtractionFromManagerPacket(((IndexerManagerMenu)this.f_97732_).getBlockEntity().m_58899_(), e.stack));
                    return true;
                }
                if (this.isManagerInventoryFull()) {
                    this.failX = ix + 8;
                    this.failY = iy + 8;
                    this.failTicks = 10;
                    return true;
                }
                int amount = IndexerManagerScreen.m_96638_() ? Math.min(64, e.count) : Math.min(1, e.count);
                this.requestExtract(e.stack, amount);
                return true;
            }
            ++idx;
        }
        if (totalRows > visibleRows) {
            int scrollbarWidth = 6;
            int scrollbarX = areaX + areaW - scrollbarWidth + 2;
            int scrollbarY = areaY;
            int scrollbarHeight = areaH;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                int thumbHeight = Math.max(10, visibleRows * scrollbarHeight / totalRows);
                int track = Math.max(1, scrollbarHeight - thumbHeight);
                int pos = (int)Math.max(0.0, Math.min((double)track, mouseY - (double)scrollbarY - (double)(thumbHeight / 2)));
                this.scrollRowOffset = pos * Math.max(1, totalRows - visibleRows) / track;
                this.draggingScrollbar = true;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollX, double scrollY) {
        double delta = scrollY;
        if (delta < 0.0) {
            ++this.scrollRowOffset;
        }
        if (delta > 0.0) {
            --this.scrollRowOffset;
        }
        return true;
    }

    private boolean isManagerInventoryFull() {
        int managerSlots = 9;
        for (int i = 0; i < managerSlots && i < ((IndexerManagerMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((IndexerManagerMenu)this.f_97732_).f_38839_.get(i);
            ItemStack s = slot.m_7993_();
            if (s.m_41619_()) {
                return false;
            }
            if (s.m_41613_() >= s.m_41741_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScrollbar) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        int areaX = this.f_97735_ + 8;
        int areaY = this.f_97736_ + 24;
        int areaW = 160;
        int areaH = 60;
        int itemSpacing = 20;
        int itemsPerRow = Math.max(1, areaW / itemSpacing);
        int visibleRows = Math.max(1, areaH / itemSpacing);
        int totalRows = (int)Math.ceil((double)this.filtered.size() / (double)itemsPerRow);
        if (totalRows <= visibleRows) {
            return true;
        }
        int scrollbarWidth = 6;
        int scrollbarX = areaX + areaW - scrollbarWidth + 2;
        int scrollbarY = areaY;
        int scrollbarHeight = areaH;
        if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth)) {
            int thumbHeight = Math.max(10, visibleRows * scrollbarHeight / totalRows);
            int track = Math.max(1, scrollbarHeight - thumbHeight);
            int pos = (int)Math.max(0.0, Math.min((double)track, mouseY - (double)scrollbarY - (double)(thumbHeight / 2)));
            this.scrollRowOffset = pos * Math.max(1, totalRows - visibleRows) / track;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.draggingScrollbar = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void updateItemListFromServer(List<ManagerItemsUpdatePacket.Entry> data) {
        this.items.clear();
        for (ManagerItemsUpdatePacket.Entry entry : data) {
            this.items.add(new ItemVariantEntry(entry.stackVariant().m_41777_(), entry.count(), entry.pending()));
        }
    }

    public void requestExtract(ItemStack stackVariant, int count) {
        ModNetworking.sendToServer(new ExtractItemFromManagerPacket(((IndexerManagerMenu)this.f_97732_).getBlockEntity().m_58899_(), BuiltInRegistries.f_257033_.m_7981_((Object)stackVariant.m_41720_()), count, stackVariant));
    }

    private void sortFiltered() {
        switch (this.currentSort.ordinal()) {
            case 1: {
                this.filtered.sort((a, b) -> Integer.compare(b.count, a.count));
                break;
            }
            case 2: {
                this.filtered.sort(Comparator.comparing(this::getItemName, String.CASE_INSENSITIVE_ORDER));
                break;
            }
            case 3: {
                this.filtered.sort(Comparator.comparingInt(e -> this.isConstruction((ItemVariantEntry)e) ? 0 : 1).thenComparing(e -> this.getItemName((ItemVariantEntry)e), String.CASE_INSENSITIVE_ORDER));
                break;
            }
            case 4: {
                this.filtered.sort(Comparator.comparingInt(e -> this.isConstruction((ItemVariantEntry)e) ? 1 : 0).thenComparing(e -> this.getItemName((ItemVariantEntry)e), String.CASE_INSENSITIVE_ORDER));
                break;
            }
            case 5: {
                this.filtered.sort(Comparator.comparing(e -> {
                    ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)e.stack.m_41720_());
                    return key == null ? "" : key.m_135827_();
                }, String.CASE_INSENSITIVE_ORDER).thenComparing(e -> this.getItemName((ItemVariantEntry)e), String.CASE_INSENSITIVE_ORDER));
                break;
            }
        }
    }

    private String getItemName(ItemVariantEntry e) {
        return Component.m_237115_((String)e.stack.m_41720_().m_5524_()).getString();
    }

    private String getEnchantSearchTokens(ItemStack stack) {
        ItemEnchantments storedEnchantments;
        StringBuilder sb = new StringBuilder();
        ItemEnchantments enchantments = (ItemEnchantments)stack.m_323252_(DataComponents.f_314658_);
        if (enchantments != null) {
            for (Object2IntMap.Entry entry : enchantments.m_320130_()) {
                Holder holder = (Holder)entry.getKey();
                int lvl = entry.getIntValue();
                sb.append(holder.m_203543_().map(k -> k.m_135782_().toString()).orElse("").toLowerCase(Locale.ROOT)).append(" ");
                sb.append(((Enchantment)holder.m_203334_()).f_337607_().getString().toLowerCase(Locale.ROOT)).append(" ");
                sb.append(Component.m_237115_((String)("enchantment.level." + lvl)).getString().toLowerCase(Locale.ROOT)).append(" ");
            }
        }
        if ((storedEnchantments = (ItemEnchantments)stack.m_323252_(DataComponents.f_314515_)) != null) {
            for (Object2IntMap.Entry entry : storedEnchantments.m_320130_()) {
                Holder holder = (Holder)entry.getKey();
                int lvl = entry.getIntValue();
                sb.append(holder.m_203543_().map(k -> k.m_135782_().toString()).orElse("").toLowerCase(Locale.ROOT)).append(" ");
                sb.append(((Enchantment)holder.m_203334_()).f_337607_().getString().toLowerCase(Locale.ROOT)).append(" ");
                sb.append(Component.m_237115_((String)("enchantment.level." + lvl)).getString().toLowerCase(Locale.ROOT)).append(" ");
            }
        }
        return sb.toString();
    }

    private boolean isConstruction(ItemVariantEntry e) {
        return e.stack.m_41720_() instanceof BlockItem;
    }

    private boolean isTool(ItemVariantEntry e) {
        Item item = e.stack.m_41720_();
        return item instanceof TieredItem || item instanceof SwordItem || item instanceof ShearsItem;
    }

    private void drawMenuItem(GuiGraphics g, Component text, int x, int y, boolean selected, boolean hovered) {
        if (selected) {
            g.m_280509_(x - 4, y - 2, x + this.f_96547_.m_92852_((FormattedText)text) + 4, y + 10, 1076780400);
        }
        int color = hovered ? 0xCCCCCC : 0xFFFFFF;
        g.m_280614_(this.f_96547_, text, x, y, color, false);
    }

    private static enum SortMode {
        NONE,
        CANTIDAD,
        ALFABETO,
        BLOCK,
        ITEM,
        MOD;

    }

    public static class ItemVariantEntry {
        public final ItemStack stack;
        public final int count;
        public final boolean pending;

        public ItemVariantEntry(ItemStack stack, int count, boolean pending) {
            this.stack = stack;
            this.count = count;
            this.pending = pending;
        }
    }
}

