/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.screen;

import com.agustinbenitez.indexer.IndexerMod;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IndexerManualScreen
extends Screen {
    private static final int SCREEN_WIDTH = 271;
    private static final int SCREEN_HEIGHT = 180;
    private static final ResourceLocation BACKGROUND = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/manual/manualgui.png");
    private static final ResourceLocation LOGO = ResourceLocation.m_339182_((String)"indexer", (String)"textures/block/indexer_controller_top.png");
    private static final String WIKI_URL = "https://agustinbeniteez.github.io/Wikimods/mod/index.html?id=indexer&game=minecraft";
    private Button nextButton;
    private Button prevButton;
    private Button closeButton;
    private Button menuButton;
    private Button craftingButton;
    private Button tutorialButton;
    private Button wikiButton;
    private EditBox searchBox;
    private int currentPage = 0;
    private final int totalPages = 13;
    private final ResourceLocation[] pageImages = new ResourceLocation[13];
    private ViewMode currentView = ViewMode.MENU;
    private boolean inSplash = true;
    private long splashEndMillis = 0L;
    private static final ResourceLocation MENU_CRAFT_TEXTURE = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/manual/menu/menucraft.png");
    private static final ResourceLocation MENU_TUTORIAL_TEXTURE = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/manual/menu/menututorial.png");
    private static final ResourceLocation MENU_WIKI_TEXTURE = ResourceLocation.m_339182_((String)"indexer", (String)"textures/gui/manual/menu/menuwiki.png");
    private List<ManualRecipe> allManualRecipes = Collections.emptyList();
    private List<ManualRecipe> filteredRecipes = Collections.emptyList();
    private int craftingPage = 0;
    private static final int recipesPerPage = 2;

    public IndexerManualScreen() {
        super((Component)Component.m_237115_((String)"item.indexer.indexer_manual"));
        for (int i = 0; i < 13; ++i) {
            this.pageImages[i] = ResourceLocation.m_339182_((String)"indexer", (String)("textures/gui/manual/manual" + (i + 1) + ".png"));
        }
        this.splashEndMillis = System.currentTimeMillis() + 1000L;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int leftPos = centerX - 135;
        int topPos = centerY - 90;
        this.prevButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.previousPage()).m_252987_(leftPos + 10, topPos + 180 - 30, 20, 20).m_253136_();
        this.nextButton = Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.nextPage()).m_252987_(leftPos + 271 - 30, topPos + 180 - 30, 20, 20).m_253136_();
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"X"), button -> this.m_7379_()).m_252987_(leftPos + 271 - 25, topPos + 5, 20, 20).m_253136_();
        this.menuButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.indexer.manual.menu"), b -> this.switchToMenu()).m_252987_(leftPos + 5, topPos + 5, 40, 20).m_253136_();
        int menuBtnWidth = 80;
        int menuBtnHeight = 70;
        int menuStartX = centerX - (menuBtnWidth * 3 + 20) / 2;
        int menuY = topPos + 60;
        this.craftingButton = new TexturedMenuButton(menuStartX, menuY, menuBtnWidth, menuBtnHeight, (Component)Component.m_237115_((String)"gui.indexer.manual.crafting"), b -> this.switchToCrafting(), MENU_CRAFT_TEXTURE);
        this.tutorialButton = new TexturedMenuButton(menuStartX + menuBtnWidth + 10, menuY, menuBtnWidth, menuBtnHeight, (Component)Component.m_237115_((String)"gui.indexer.manual.tutorial"), b -> this.switchToTutorial(), MENU_TUTORIAL_TEXTURE);
        this.wikiButton = new TexturedMenuButton(menuStartX + (menuBtnWidth + 10) * 2, menuY, menuBtnWidth, menuBtnHeight, (Component)Component.m_237115_((String)"gui.indexer.manual.wiki"), b -> this.openWiki(), MENU_WIKI_TEXTURE);
        this.searchBox = new EditBox(this.f_96547_, leftPos + 20, topPos + 30, 231, 18, (Component)Component.m_237115_((String)"gui.indexer.manual.search_placeholder"));
        this.searchBox.m_94199_(64);
        this.searchBox.m_94151_(s -> this.applyCraftingFilter((String)s));
        this.m_142416_((GuiEventListener)this.prevButton);
        this.m_142416_((GuiEventListener)this.nextButton);
        this.m_142416_((GuiEventListener)this.closeButton);
        this.m_142416_((GuiEventListener)this.menuButton);
        this.m_142416_((GuiEventListener)this.craftingButton);
        this.m_142416_((GuiEventListener)this.tutorialButton);
        this.m_142416_((GuiEventListener)this.wikiButton);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.loadManualRecipesFromFile();
        this.updateButtonStates();
        this.updateVisibilityForView();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, 0x44000000);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int leftPos = centerX - 135;
        int topPos = centerY - 90;
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 10.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
        GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
        guiGraphics.m_280163_(BACKGROUND, leftPos, topPos, 0.0f, 0.0f, 271, 180, 271, 180);
        if (this.inSplash) {
            long now = System.currentTimeMillis();
            if (now < this.splashEndMillis) {
                int logoSize = 80;
                long elapsed = Math.max(0L, 1000L - (this.splashEndMillis - now));
                float angle = (float)elapsed * 180.0f / 1000.0f;
                pose.m_85836_();
                pose.m_252880_((float)centerX, (float)(topPos + 90), 50.0f);
                pose.m_252781_(Axis.f_252403_.m_252977_(angle));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOGO);
                guiGraphics.m_280163_(LOGO, -(logoSize / 2), -(logoSize / 2), 0.0f, 0.0f, logoSize, logoSize, logoSize, logoSize);
                pose.m_85849_();
                pose.m_85849_();
                return;
            }
            this.inSplash = false;
            this.currentView = ViewMode.MENU;
            this.updateVisibilityForView();
        }
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 30.0f);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 100.0f);
        switch (this.currentView.ordinal()) {
            case 0: {
                String title = I18n.m_118938_((String)"item.indexer.indexer_manual", (Object[])new Object[0]);
                guiGraphics.m_280056_(this.f_96547_, title, centerX - this.f_96547_.m_92895_(title) / 2, topPos + 30, 0x404040, false);
                break;
            }
            case 1: {
                String pageText = this.currentPage + 1 + "/13";
                guiGraphics.m_280056_(this.f_96547_, pageText, centerX - this.f_96547_.m_92895_(pageText) / 2, topPos + 180 - 17, 0x404040, false);
                try {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.pageImages[this.currentPage]);
                    GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
                    GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
                    guiGraphics.m_280163_(this.pageImages[this.currentPage], leftPos + 35, topPos + 30, 0.0f, 0.0f, 200, 120, 200, 120);
                }
                catch (Exception e) {
                    guiGraphics.m_280056_(this.f_96547_, I18n.m_118938_((String)"gui.indexer.manual.error_image", (Object[])new Object[0]), leftPos + 50, topPos + 70, 0xAA0000, false);
                }
                break;
            }
            case 2: {
                this.renderCraftingList(guiGraphics, leftPos, topPos, mouseX, mouseY);
            }
        }
        pose.m_85849_();
        pose.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderCraftingList(GuiGraphics g, int leftPos, int topPos, int mouseX, int mouseY) {
        String title = I18n.m_118938_((String)"gui.indexer.manual.crafting", (Object[])new Object[0]);
        int centerX = this.f_96543_ / 2;
        g.m_280056_(this.f_96547_, title, centerX - this.f_96547_.m_92895_(title) / 2, topPos + 12, 0xFFFFFF, false);
        if (this.filteredRecipes.isEmpty()) {
            String noRecipes = "No recipes found";
            g.m_280056_(this.f_96547_, noRecipes, centerX - this.f_96547_.m_92895_(noRecipes) / 2, topPos + 80, 0xFFFFFF, false);
        } else {
            int startIndex = this.craftingPage * 2;
            int endIndex = Math.min(startIndex + 2, this.filteredRecipes.size());
            int baseY = topPos + 55;
            int columnWidth = 105;
            int columnGap = 10;
            int rowHeight = 70;
            for (int i = startIndex; i < endIndex; ++i) {
                int localIndex = i - startIndex;
                int col = localIndex % 2;
                int row = localIndex / 2;
                int baseX = leftPos + 25 + col * (columnWidth + columnGap);
                int y = baseY + row * rowHeight;
                ManualRecipe recipe = this.filteredRecipes.get(i);
                g.m_280480_(recipe.result, baseX, y);
                String name = I18n.m_118938_((String)recipe.result.m_41778_(), (Object[])new Object[0]);
                String shownName = this.ellipsize(name, columnWidth - 20);
                g.m_280056_(this.f_96547_, shownName, baseX + 20, y + 4, 0xFFFFFF, false);
                int gridX = baseX;
                int gridY = y + 20;
                this.renderRecipeGrid(g, recipe, gridX, gridY);
            }
        }
        String pageText = (this.filteredRecipes.isEmpty() ? 0 : this.craftingPage + 1) + "/" + Math.max(1, (int)Math.ceil((double)this.filteredRecipes.size() / 2.0));
        g.m_280056_(this.f_96547_, pageText, centerX - this.f_96547_.m_92895_(pageText) / 2, topPos + 180 - 17, 0xFFFFFF, false);
    }

    private void renderRecipeGrid(GuiGraphics g, ManualRecipe recipe, int gridX, int gridY) {
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                int idx = r * 3 + c;
                int slotX = gridX + c * 18;
                int slotY = gridY + r * 18;
                if (idx < recipe.ingredients.size()) {
                    ItemStack stack = recipe.ingredients.get(idx);
                    if (!stack.m_41619_()) {
                        g.m_280480_(stack, slotX, slotY);
                        continue;
                    }
                    this.drawEmptySlot(g, slotX, slotY);
                    continue;
                }
                this.drawEmptySlot(g, slotX, slotY);
            }
        }
    }

    private void drawEmptySlot(GuiGraphics g, int x, int y) {
        g.m_280509_(x, y, x + 16, y + 16, -13750738);
        g.m_280509_(x, y, x + 16, y + 1, -15066598);
        g.m_280509_(x, y, x + 1, y + 16, -15066598);
    }

    private void nextPage() {
        int maxPage;
        if (this.currentView == ViewMode.TUTORIAL) {
            if (this.currentPage < 12) {
                ++this.currentPage;
            }
        } else if (this.currentView == ViewMode.CRAFTING && this.craftingPage < (maxPage = Math.max(0, (int)Math.ceil((double)this.filteredRecipes.size() / 2.0) - 1))) {
            ++this.craftingPage;
        }
        this.updateButtonStates();
    }

    private void previousPage() {
        if (this.currentView == ViewMode.TUTORIAL) {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        } else if (this.currentView == ViewMode.CRAFTING && this.craftingPage > 0) {
            --this.craftingPage;
        }
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.currentView == ViewMode.TUTORIAL) {
            this.prevButton.f_93623_ = this.currentPage > 0;
            this.nextButton.f_93623_ = this.currentPage < 12;
        } else if (this.currentView == ViewMode.CRAFTING) {
            int maxPage = Math.max(0, (int)Math.ceil((double)this.filteredRecipes.size() / 2.0) - 1);
            this.prevButton.f_93623_ = this.craftingPage > 0;
            this.nextButton.f_93623_ = this.craftingPage < maxPage;
        } else {
            this.nextButton.f_93623_ = false;
            this.prevButton.f_93623_ = false;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void switchToMenu() {
        this.currentView = ViewMode.MENU;
        this.updateVisibilityForView();
    }

    private void switchToTutorial() {
        this.currentView = ViewMode.TUTORIAL;
        this.updateVisibilityForView();
    }

    private void switchToCrafting() {
        this.currentView = ViewMode.CRAFTING;
        this.applyCraftingFilter(this.searchBox.m_94155_());
        this.craftingPage = 0;
        this.updateVisibilityForView();
    }

    private void openWiki() {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(accepted -> {
            if (accepted) {
                Util.m_137581_().m_137646_(WIKI_URL);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, WIKI_URL, true));
    }

    private void updateVisibilityForView() {
        if (this.inSplash) {
            this.searchBox.f_93624_ = false;
            this.wikiButton.f_93624_ = false;
            this.tutorialButton.f_93624_ = false;
            this.craftingButton.f_93624_ = false;
            this.menuButton.f_93624_ = false;
            this.nextButton.f_93624_ = false;
            this.prevButton.f_93624_ = false;
            return;
        }
        boolean isMenu = this.currentView == ViewMode.MENU;
        boolean isTutorial = this.currentView == ViewMode.TUTORIAL;
        boolean isCrafting = this.currentView == ViewMode.CRAFTING;
        this.nextButton.f_93624_ = isTutorial || isCrafting;
        this.prevButton.f_93624_ = this.nextButton.f_93624_;
        this.menuButton.f_93624_ = !isMenu;
        this.tutorialButton.f_93624_ = this.wikiButton.f_93624_ = isMenu;
        this.craftingButton.f_93624_ = this.wikiButton.f_93624_;
        this.searchBox.f_93624_ = isCrafting;
        this.updateButtonStates();
    }

    private void loadManualRecipesFromFile() {
        ArrayList<ManualRecipe> loaded;
        block11: {
            if (this.f_96541_ == null) {
                return;
            }
            loaded = new ArrayList<ManualRecipe>();
            try {
                ResourceLocation jsonLoc = ResourceLocation.m_339182_((String)"indexer", (String)"manual_recipes.json");
                Optional resource = this.f_96541_.m_91098_().m_213713_(jsonLoc);
                if (resource.isPresent()) {
                    try (InputStreamReader reader = new InputStreamReader(((Resource)resource.get()).m_215507_());){
                        JsonElement root = JsonParser.parseReader((Reader)reader);
                        if (root.isJsonArray()) {
                            JsonArray arr = root.getAsJsonArray();
                            for (JsonElement el : arr) {
                                ManualRecipe r = this.parseRecipe(el.getAsJsonObject());
                                if (r == null) continue;
                                loaded.add(r);
                            }
                        }
                        break block11;
                    }
                }
                IndexerMod.LOGGER.error("Manual JSON not found at: " + String.valueOf(jsonLoc));
            }
            catch (Exception e) {
                IndexerMod.LOGGER.error("Error loading manual recipes JSON", (Throwable)e);
            }
        }
        this.allManualRecipes = loaded;
        this.filteredRecipes = new ArrayList<ManualRecipe>(loaded);
        IndexerMod.LOGGER.info("Manual loaded {} recipes from JSON.", (Object)loaded.size());
    }

    private ManualRecipe parseRecipe(JsonObject json) {
        try {
            JsonObject resObj = json.getAsJsonObject("result");
            String itemId = resObj.get("item").getAsString();
            int count = resObj.has("count") ? resObj.get("count").getAsInt() : 1;
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_338530_((String)itemId));
            if (item == Items.f_41852_) {
                return null;
            }
            ManualRecipe recipe = new ManualRecipe(new ItemStack((ItemLike)item, count));
            String type = json.get("type").getAsString();
            if (type.equals("minecraft:crafting_shaped")) {
                JsonArray pattern = json.getAsJsonArray("pattern");
                JsonObject keyMap = json.getAsJsonObject("key");
                int height = pattern.size();
                int width = pattern.get(0).getAsString().length();
                HashMap<Character, ItemStack> charMap = new HashMap<Character, ItemStack>();
                for (String k : keyMap.keySet()) {
                    JsonObject entry = keyMap.getAsJsonObject(k);
                    charMap.put(Character.valueOf(k.charAt(0)), this.parseIngredient(entry));
                }
                charMap.put(Character.valueOf(' '), ItemStack.f_41583_);
                for (int r = 0; r < height; ++r) {
                    String rowStr = pattern.get(r).getAsString();
                    for (int c = 0; c < width; ++c) {
                        char ch = rowStr.charAt(c);
                        ItemStack stack = charMap.getOrDefault(Character.valueOf(ch), ItemStack.f_41583_);
                        if (r >= 3 || c >= 3) continue;
                        recipe.ingredients.set(r * 3 + c, stack);
                    }
                }
            } else if (type.equals("minecraft:crafting_shapeless")) {
                JsonArray ings = json.getAsJsonArray("ingredients");
                for (int i = 0; i < Math.min(ings.size(), 9); ++i) {
                    JsonObject entry = ings.get(i).getAsJsonObject();
                    recipe.ingredients.set(i, this.parseIngredient(entry));
                }
            }
            return recipe;
        }
        catch (Exception e) {
            IndexerMod.LOGGER.warn("Failed to parse manual recipe", (Throwable)e);
            return null;
        }
    }

    private ItemStack parseIngredient(JsonObject obj) {
        if (obj.has("item")) {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_338530_((String)obj.get("item").getAsString()));
            return new ItemStack((ItemLike)item);
        }
        if (obj.has("tag")) {
            Optional first;
            String tagName = obj.get("tag").getAsString();
            if (tagName.equals("forge:ingots/iron")) {
                return new ItemStack((ItemLike)Items.f_42416_);
            }
            if (tagName.equals("forge:nuggets/gold")) {
                return new ItemStack((ItemLike)Items.f_42587_);
            }
            TagKey key = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)ResourceLocation.m_338530_((String)tagName));
            Optional tag = BuiltInRegistries.f_257033_.m_203431_(key);
            if (tag.isPresent() && (first = ((HolderSet.Named)tag.get()).m_203614_().findFirst()).isPresent()) {
                return new ItemStack((ItemLike)((Holder)first.get()).m_203334_());
            }
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    private void applyCraftingFilter(String query) {
        String q;
        String string = q = query == null ? "" : query.trim().toLowerCase();
        if (q.isEmpty()) {
            this.filteredRecipes = this.allManualRecipes;
        } else {
            ArrayList<ManualRecipe> filtered = new ArrayList<ManualRecipe>();
            for (ManualRecipe r : this.allManualRecipes) {
                String localeName = I18n.m_118938_((String)r.result.m_41778_(), (Object[])new Object[0]).toLowerCase();
                if (!localeName.contains(q)) continue;
                filtered.add(r);
            }
            this.filteredRecipes = filtered;
        }
        this.craftingPage = 0;
        this.updateButtonStates();
    }

    private String ellipsize(String text, int maxWidth) {
        int cut;
        if (this.f_96547_.m_92895_(text) <= maxWidth) {
            return text;
        }
        String ell = "...";
        for (cut = text.length(); cut > 0 && this.f_96547_.m_92895_(text.substring(0, cut) + ell) > maxWidth; --cut) {
        }
        return cut <= 0 ? ell : text.substring(0, cut) + ell;
    }

    private static enum ViewMode {
        MENU,
        TUTORIAL,
        CRAFTING;

    }

    private static class TexturedMenuButton
    extends Button {
        private final ResourceLocation texture;

        public TexturedMenuButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, ResourceLocation texture) {
            super(x, y, width, height, message, onPress, f_252438_);
            this.texture = texture;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int x = this.m_252754_();
            int y = this.m_252907_();
            int w = this.m_5711_();
            int h = this.m_93694_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
            if (this.m_198029_()) {
                int dw = (int)Math.round((double)w * 1.06);
                int dh = (int)Math.round((double)h * 1.06);
                int dx = x - (dw - w) / 2;
                int dy = y - (dh - h) / 2;
                guiGraphics.m_280163_(this.texture, dx, dy, 0.0f, 0.0f, dw, dh, w, h);
                guiGraphics.m_280509_(x, y, x + w, y + h, 0x66000000);
                guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), x + w / 2, y + (h - 8) / 2, 0xFFFFFF);
            } else {
                guiGraphics.m_280163_(this.texture, x, y, 0.0f, 0.0f, w, h, w, h);
            }
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
        }
    }

    private static class ManualRecipe {
        ItemStack result;
        List<ItemStack> ingredients = new ArrayList<ItemStack>(9);

        public ManualRecipe(ItemStack result) {
            this.result = result;
            for (int i = 0; i < 9; ++i) {
                this.ingredients.add(ItemStack.f_41583_);
            }
        }
    }
}

