/*
 * Decompiled with CFR 0.152.
 */
package com.agustinbenitez.indexer.util;

import com.agustinbenitez.indexer.init.ModDataComponents;
import com.agustinbenitez.indexer.init.ModItems;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;

public class FilterUtils {
    public static boolean passesFilter(ItemStack itemToCheck, ItemStack filterItem) {
        if (itemToCheck.m_41619_() || filterItem.m_41619_()) {
            return false;
        }
        Item filterType = filterItem.m_41720_();
        if (filterType == ModItems.TOOLS_FILTER.get()) {
            return FilterUtils.isToolItem(itemToCheck);
        }
        if (filterType == ModItems.FOOD_FILTER.get()) {
            return itemToCheck.m_319951_(DataComponents.f_315399_);
        }
        if (filterType == ModItems.FUEL_FILTER.get()) {
            return FilterUtils.isFuelItem(itemToCheck);
        }
        if (filterType == ModItems.CUSTOM_TAG_BLOCKER.get()) {
            return FilterUtils.passesCustomTagFilter(itemToCheck, filterItem);
        }
        if (filterType == ModItems.ATTRIBUTE_FILTER.get()) {
            return FilterUtils.passesAttributeFilter(itemToCheck, filterItem);
        }
        if (filterType == ModItems.NAME_FILTER.get()) {
            return FilterUtils.passesNameFilter(itemToCheck, filterItem);
        }
        return itemToCheck.m_41720_() == filterItem.m_41720_();
    }

    public static boolean isBlockingFilter(ItemStack filterItem) {
        if (filterItem.m_41619_()) {
            return false;
        }
        return filterItem.m_41720_() == ModItems.CUSTOM_TAG_BLOCKER.get();
    }

    private static boolean isToolItem(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof PickaxeItem || item instanceof AxeItem || item instanceof ShovelItem || item instanceof HoeItem || item instanceof SwordItem;
    }

    private static boolean isFuelItem(ItemStack stack) {
        String itemId = stack.m_41720_().m_5524_();
        return itemId.equals("item.minecraft.coal") || itemId.equals("item.minecraft.charcoal") || itemId.equals("item.minecraft.lava_bucket") || itemId.equals("block.minecraft.coal_block") || itemId.equals("block.minecraft.dried_kelp_block");
    }

    private static boolean passesCustomTagFilter(ItemStack itemToCheck, ItemStack filterItem) {
        String filterItemName;
        if (!filterItem.m_319951_((DataComponentType)ModDataComponents.CUSTOM_TAG.get())) {
            return true;
        }
        String customTag = (String)filterItem.m_323252_((DataComponentType)ModDataComponents.CUSTOM_TAG.get());
        if (customTag == null || customTag.isEmpty()) {
            return true;
        }
        String itemName = itemToCheck.m_41720_().m_5524_();
        if (itemName.equals(filterItemName = customTag)) {
            return false;
        }
        String shortItemName = itemName.replace("item.minecraft.", "").replace("block.minecraft.", "");
        return !shortItemName.equals(filterItemName);
    }

    private static boolean passesAttributeFilter(ItemStack itemToCheck, ItemStack filterItem) {
        if (!filterItem.m_319951_((DataComponentType)ModDataComponents.ATTRIBUTE_FILTER.get())) {
            return false;
        }
        String attributeFilter = (String)filterItem.m_323252_((DataComponentType)ModDataComponents.ATTRIBUTE_FILTER.get());
        if (attributeFilter == null || attributeFilter.isEmpty()) {
            return false;
        }
        if (itemToCheck.m_41793_()) {
            return itemToCheck.m_319737_().m_320130_().stream().anyMatch(entry -> {
                Holder enchantmentHolder = (Holder)entry.getKey();
                ResourceLocation enchantmentKey = enchantmentHolder.m_203543_().map(ResourceKey::m_135782_).orElse(null);
                return ((Enchantment)enchantmentHolder.m_203334_()).f_337607_().getString().contains(attributeFilter) || enchantmentKey != null && enchantmentKey.toString().equals(attributeFilter);
            });
        }
        String itemName = itemToCheck.m_41720_().toString().toLowerCase();
        String displayName = itemToCheck.m_41786_().getString().toLowerCase();
        return itemName.contains(attributeFilter.toLowerCase()) || displayName.contains(attributeFilter.toLowerCase()) || itemToCheck.m_204131_().anyMatch(tag -> tag.f_203868_().toString().contains(attributeFilter));
    }

    private static boolean passesNameFilter(ItemStack itemToCheck, ItemStack filterItem) {
        if (!filterItem.m_319951_((DataComponentType)ModDataComponents.CUSTOM_NAME.get())) {
            return false;
        }
        String nameFilter = (String)filterItem.m_323252_((DataComponentType)ModDataComponents.CUSTOM_NAME.get());
        if (nameFilter == null || nameFilter.isEmpty()) {
            return false;
        }
        if (itemToCheck.m_319951_(DataComponents.f_316016_)) {
            String customName = itemToCheck.m_41786_().getString();
            return customName.equals(nameFilter);
        }
        return false;
    }
}

