/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugScreenDisplayer;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.client.resources.MapTextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.core.BufferAllocatorPool;
import net.raphimc.immediatelyfast.feature.map_atlas_generation.MapAtlasTexture;
import net.raphimc.immediatelyfast.injection.interfaces.IMapTextureManager;

public class ImmediatelyFastDebugHudEntry
implements DebugScreenEntry {
    public static final ResourceLocation ENTRY_ID;
    private static final ResourceLocation SECTION_ID;

    public void display(DebugScreenDisplayer debugHudLines, Level world, LevelChunk clientChunk, LevelChunk chunk) {
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        lines.add((CallSite)((Object)("ImmediatelyFast " + ImmediatelyFast.VERSION)));
        lines.add((CallSite)((Object)("Buffer Pool: " + BufferAllocatorPool.getSize())));
        MapTextureManager mapTextureManager = Minecraft.getInstance().getMapTextureManager();
        if (mapTextureManager instanceof IMapTextureManager) {
            IMapTextureManager mapTextureManager2 = (IMapTextureManager)mapTextureManager;
            Collection<MapAtlasTexture> atlasTextures = mapTextureManager2.immediatelyFast$getAllMapAtlasTextures();
            int totalMapCount = atlasTextures.stream().mapToInt(MapAtlasTexture::getMapCount).sum();
            lines.add((CallSite)((Object)("Map Atlas: " + atlasTextures.size() + "x" + MapAtlasTexture.ATLAS_SIZE + "x" + MapAtlasTexture.ATLAS_SIZE + " (" + totalMapCount + " maps)")));
        }
        if (ImmediatelyFast.signTextCache != null) {
            lines.add((CallSite)((Object)("Sign Text Cache: " + ImmediatelyFast.signTextCache.slotCache.size() + " entries")));
        }
        debugHudLines.addToGroup(SECTION_ID, lines);
    }

    public boolean isAllowed(boolean reducedDebugInfo) {
        return true;
    }

    static {
        SECTION_ID = ENTRY_ID = ResourceLocation.fromNamespaceAndPath((String)"immediatelyfast", (String)"immediatelyfast");
    }
}

