/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.sign_text_buffering;

import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL30C;

public class SignAtlasFramebuffer
extends RenderTarget
implements AutoCloseable {
    public static final int ATLAS_SIZE = 4096;
    private final ResourceLocation textureId;
    private final Slot rootSlot;

    public SignAtlasFramebuffer(int id) {
        super("ImmediatelyFast Sign Atlas FBO", false);
        this.resize(4096, 4096);
        this.textureId = ResourceLocation.fromNamespaceAndPath((String)"immediatelyfast", (String)("sign_atlas/" + id));
        Minecraft.getInstance().getTextureManager().register(this.textureId, (AbstractTexture)new FboTexture(this));
        this.rootSlot = new Slot(null, 0, 0, 4096, 4096);
    }

    public int bind(boolean setViewport) {
        int previousFramebuffer = GL11C.glGetInteger((int)36006);
        int fbo = ((GlTexture)this.colorTexture).getFbo(((GlDevice)RenderSystem.getDevice()).directStateAccess(), null);
        GL30C.glBindFramebuffer((int)36160, (int)fbo);
        if (setViewport) {
            GL11C.glViewport((int)0, (int)0, (int)4096, (int)4096);
        }
        return previousFramebuffer;
    }

    public void unbind(int previousFbo) {
        GL30C.glBindFramebuffer((int)36160, (int)previousFbo);
        GL11C.glViewport((int)0, (int)0, (int)Minecraft.getInstance().getWindow().getWidth(), (int)Minecraft.getInstance().getWindow().getHeight());
    }

    public Slot findSlot(int width, int height) {
        return this.rootSlot.findSlot(width, height);
    }

    public void clear() {
        RenderSystem.getDevice().createCommandEncoder().clearColorTexture(this.getColorTexture(), 0);
        this.rootSlot.subSlot1 = null;
        this.rootSlot.subSlot2 = null;
    }

    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    @Override
    public void close() {
        this.destroyBuffers();
    }

    private class FboTexture
    extends AbstractTexture {
        private FboTexture(SignAtlasFramebuffer signAtlasFramebuffer) {
            this.texture = signAtlasFramebuffer.colorTexture;
            this.textureView = RenderSystem.getDevice().createTextureView(this.texture);
        }

        public void close() {
        }
    }

    public class Slot {
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final Slot parentSlot;
        public Slot subSlot1;
        public Slot subSlot2;
        public boolean occupied;

        public Slot(Slot parentSlot, int x, int y, int width, int height) {
            this.parentSlot = parentSlot;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void markFree() {
            if (this.subSlot1 != null || this.subSlot2 != null) {
                throw new UnsupportedOperationException("Cannot mark slot as free if it has sub slots");
            }
            if (!this.occupied) {
                throw new UnsupportedOperationException("Cannot mark slot as free if it is not occupied");
            }
            this.occupied = false;
            Slot.removeUnoccupiedSubSlots(this);
            GlStateManager._scissorBox((int)this.x, (int)(4096 - this.y - this.height), (int)this.width, (int)this.height);
            GlStateManager._enableScissorTest();
            int previousFbo = SignAtlasFramebuffer.this.bind(false);
            GL11C.glClear((int)16384);
            SignAtlasFramebuffer.this.unbind(previousFbo);
            GlStateManager._disableScissorTest();
        }

        public Slot findSlot(int width, int height) {
            if (this.subSlot1 != null && this.subSlot2 != null) {
                Slot slot = this.subSlot1.findSlot(width, height);
                if (slot == null) {
                    slot = this.subSlot2.findSlot(width, height);
                }
                return slot;
            }
            if (this.occupied) {
                return null;
            }
            if (width > this.width || height > this.height) {
                return null;
            }
            if (width == this.width && height == this.height) {
                this.occupied = true;
                return this;
            }
            int k = this.width - width;
            int l = this.height - height;
            if (k > l) {
                this.subSlot1 = new Slot(this, this.x, this.y, width, this.height);
                this.subSlot2 = new Slot(this, this.x + width, this.y, this.width - width, this.height);
            } else {
                this.subSlot1 = new Slot(this, this.x, this.y, this.width, height);
                this.subSlot2 = new Slot(this, this.x, this.y + height, this.width, this.height - height);
            }
            return this.subSlot1.findSlot(width, height);
        }

        private static void removeUnoccupiedSubSlots(Slot slot) {
            boolean subSlot2Unoccupied;
            if (slot == null) {
                return;
            }
            Slot.removeUnoccupiedSubSlots(slot.parentSlot);
            boolean subSlot1Unoccupied = slot.subSlot1 != null && !Slot.hasOccupiedSlot(slot.subSlot1);
            boolean bl = subSlot2Unoccupied = slot.subSlot2 != null && !Slot.hasOccupiedSlot(slot.subSlot2);
            if (subSlot1Unoccupied && subSlot2Unoccupied) {
                slot.subSlot1 = null;
                slot.subSlot2 = null;
            }
        }

        private static boolean hasOccupiedSlot(Slot slot) {
            if (slot == null) {
                return false;
            }
            if (slot.occupied) {
                return true;
            }
            return Slot.hasOccupiedSlot(slot.subSlot1) || Slot.hasOccupiedSlot(slot.subSlot2);
        }
    }
}

