/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.resource_pack_conflict_handling;

import com.mojang.blaze3d.shaders.ShaderType;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.core.ImmediatelyFastResourcePackMetadata;
import net.raphimc.immediatelyfast.feature.resource_pack_conflict_handling.CoreShaderBlacklist;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderManager.class})
public abstract class MixinShaderLoader {
    @Inject(method={"apply(Lnet/minecraft/client/renderer/ShaderManager$Configs;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="RETURN")})
    private void checkForCoreShaderModifications(ShaderManager.Configs definitions, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        PackResources resourcePackWhichBreaksFontAtlasResizing = null;
        try {
            HashSet<PackResources> breakingResourcePacks = new HashSet<PackResources>();
            for (ResourceLocation shaderIdentifier : CoreShaderBlacklist.getBlacklist()) {
                ResourceLocation fragmentShaderIdentifier;
                PackResources fragmentShaderResourcePack;
                ResourceLocation vertexShaderIdentifier = ShaderType.VERTEX.idConverter().idToFile(shaderIdentifier);
                PackResources vertexShaderResourcePack = resourceManager.getResource(vertexShaderIdentifier).map(Resource::source).orElse(null);
                if (vertexShaderResourcePack != null && !vertexShaderResourcePack.equals((Object)Minecraft.getInstance().getVanillaPackResources())) {
                    breakingResourcePacks.add(vertexShaderResourcePack);
                }
                if ((fragmentShaderResourcePack = (PackResources)resourceManager.getResource(fragmentShaderIdentifier = ShaderType.FRAGMENT.idConverter().idToFile(shaderIdentifier)).map(Resource::source).orElse(null)) == null || fragmentShaderResourcePack.equals((Object)Minecraft.getInstance().getVanillaPackResources())) continue;
                breakingResourcePacks.add(fragmentShaderResourcePack);
            }
            for (PackResources resourcePack : breakingResourcePacks) {
                ImmediatelyFastResourcePackMetadata metadata = (ImmediatelyFastResourcePackMetadata)resourcePack.getMetadataSection(ImmediatelyFastResourcePackMetadata.SERIALIZER);
                if (metadata == null) {
                    metadata = ImmediatelyFastResourcePackMetadata.DEFAULT;
                }
                if (metadata.compatibleFeatures().contains("font_atlas_resizing")) continue;
                resourcePackWhichBreaksFontAtlasResizing = resourcePack;
            }
        }
        catch (IOException e) {
            ImmediatelyFast.LOGGER.error("Failed to check for core shader modifications", (Throwable)e);
        }
        if (ImmediatelyFast.runtimeConfig.font_atlas_resizing && resourcePackWhichBreaksFontAtlasResizing != null) {
            ImmediatelyFast.LOGGER.warn("Resource pack " + resourcePackWhichBreaksFontAtlasResizing.packId() + " is not compatible with font atlas resizing. Temporarily disabling font atlas resizing.");
            ImmediatelyFast.runtimeConfig.font_atlas_resizing = false;
            this.immediatelyFast$reloadFontStorages();
        } else if (!ImmediatelyFast.runtimeConfig.font_atlas_resizing && ImmediatelyFast.config.font_atlas_resizing) {
            ImmediatelyFast.runtimeConfig.font_atlas_resizing = true;
            this.immediatelyFast$reloadFontStorages();
        }
    }

    @Unique
    private void immediatelyFast$reloadFontStorages() {
        Minecraft.getInstance().fontManager.updateOptions(Minecraft.getInstance().options);
    }
}

