/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.sign_text_buffering;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.blockentity.AbstractSignRenderer;
import net.minecraft.client.renderer.blockentity.state.SignRenderState;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.fog.FogRenderer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.phys.Vec3;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.core.BufferAllocatorPool;
import net.raphimc.immediatelyfast.feature.sign_text_buffering.NoTextTransformMatrixStack;
import net.raphimc.immediatelyfast.feature.sign_text_buffering.SignAtlasFramebuffer;
import net.raphimc.immediatelyfast.injection.interfaces.ISignText;
import org.joml.Matrix4fStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractSignRenderer.class})
public abstract class MixinAbstractSignBlockEntityRenderer {
    @Shadow
    @Final
    private Font font;

    @Shadow
    protected abstract void submitSignText(SignRenderState var1, PoseStack var2, SubmitNodeCollector var3, boolean var4);

    @Shadow
    protected abstract void translateSignText(PoseStack var1, boolean var2, Vec3 var3);

    @Shadow
    protected abstract Vec3 getTextOffset();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"submitSignText(Lnet/minecraft/client/renderer/blockentity/state/SignRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderBufferedSignText(SignRenderState renderState, PoseStack matrices, SubmitNodeCollector queue, boolean front, CallbackInfo ci) {
        SignText signText;
        if (matrices instanceof NoTextTransformMatrixStack) {
            return;
        }
        SignText signText2 = signText = front ? renderState.frontText : renderState.backText;
        if (!(signText instanceof ISignText)) {
            return;
        }
        ISignText mixinSignText = (ISignText)signText;
        if (!mixinSignText.immediatelyFast$shouldCache()) {
            return;
        }
        SignAtlasFramebuffer.Slot slot = (SignAtlasFramebuffer.Slot)ImmediatelyFast.signTextCache.slotCache.getIfPresent((Object)signText);
        if (slot == null) {
            int width = this.immediatelyFast$getTextWidth(signText, renderState.isTextFilteringEnabled, renderState.maxTextLineWidth);
            int height = 4 * renderState.textLineHeight;
            if (width <= 0 || height <= 0) {
                mixinSignText.immediatelyFast$setShouldCache(false);
                return;
            }
            int padding = signText.hasGlowingText() ? 2 : 0;
            slot = ImmediatelyFast.signTextCache.signAtlasFramebuffer.findSlot(width + padding, height + padding);
            if (slot != null) {
                RenderSystem.backupProjectionMatrix();
                RenderSystem.setProjectionMatrix((GpuBufferSlice)ImmediatelyFast.signTextCache.signProjectionMatrixBuffer, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
                Matrix4fStack modelViewMatrix = RenderSystem.getModelViewStack();
                modelViewMatrix.pushMatrix();
                modelViewMatrix.identity();
                GpuBufferSlice fog = RenderSystem.getShaderFog();
                RenderSystem.setShaderFog((GpuBufferSlice)Minecraft.getInstance().gameRenderer.fogRenderer.getBuffer(FogRenderer.FogMode.NONE));
                ByteBufferBuilder bufferAllocator = BufferAllocatorPool.borrowBufferAllocator();
                int previousFbo = ImmediatelyFast.signTextCache.signAtlasFramebuffer.bind(true);
                ImmediatelyFast.signTextCache.lockFramebuffer = true;
                ImmediatelyFast.signTextCache.lockViewport = true;
                try {
                    MultiBufferSource.BufferSource immediate = MultiBufferSource.immediate((ByteBufferBuilder)bufferAllocator);
                    SubmitNodeStorage orderedRenderCommandQueue = new SubmitNodeStorage();
                    FeatureRenderDispatcher renderDispatcher = new FeatureRenderDispatcher(orderedRenderCommandQueue, Minecraft.getInstance().getBlockRenderer(), immediate, Minecraft.getInstance().getAtlasManager(), null, null, this.font);
                    NoTextTransformMatrixStack matrixStack = new NoTextTransformMatrixStack();
                    matrixStack.translate(slot.x, slot.y, 0.0f);
                    matrixStack.translate((float)slot.width / 2.0f, (float)slot.height / 2.0f, 0.0f);
                    renderState.drawOutline = true;
                    this.submitSignText(renderState, matrixStack, (SubmitNodeCollector)orderedRenderCommandQueue, front);
                    renderDispatcher.renderAllFeatures();
                    immediate.endBatch();
                    renderDispatcher.close();
                }
                finally {
                    ImmediatelyFast.signTextCache.lockViewport = false;
                    ImmediatelyFast.signTextCache.lockFramebuffer = false;
                    ImmediatelyFast.signTextCache.signAtlasFramebuffer.unbind(previousFbo);
                    BufferAllocatorPool.returnBufferAllocatorSafe(bufferAllocator);
                    RenderSystem.setShaderFog((GpuBufferSlice)fog);
                    modelViewMatrix.popMatrix();
                    RenderSystem.restoreProjectionMatrix();
                }
                ImmediatelyFast.signTextCache.slotCache.put((Object)signText, (Object)slot);
            } else {
                ImmediatelyFast.LOGGER.warn("Failed to find a free slot for sign text (" + ImmediatelyFast.signTextCache.slotCache.size() + " sign texts in atlas). Falling back to immediate mode rendering.");
                mixinSignText.immediatelyFast$setShouldCache(false);
                return;
            }
        }
        float u1 = (float)slot.x / 4096.0f;
        float u2 = ((float)slot.x + (float)slot.width) / 4096.0f;
        float v1 = 1.0f - (float)slot.y / 4096.0f;
        float v2 = 1.0f - ((float)slot.y + (float)slot.height) / 4096.0f;
        int light = signText.hasGlowingText() ? 0xF000F0 : renderState.lightCoords;
        matrices.pushPose();
        this.translateSignText(matrices, front, this.getTextOffset());
        matrices.translate((float)(-slot.width) / 2.0f, (float)(-slot.height) / 2.0f, 0.0f);
        SignAtlasFramebuffer.Slot finalSlot = slot;
        queue.submitCustomGeometry(matrices, ImmediatelyFast.signTextCache.renderLayer, (entry, vertexConsumer) -> {
            vertexConsumer.addVertex(entry, 0.0f, (float)finalSlot.height, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v2).setLight(light);
            vertexConsumer.addVertex(entry, (float)finalSlot.width, (float)finalSlot.height, 0.0f).setColor(255, 255, 255, 255).setUv(u2, v2).setLight(light);
            vertexConsumer.addVertex(entry, (float)finalSlot.width, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u2, v1).setLight(light);
            vertexConsumer.addVertex(entry, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v1).setLight(light);
        });
        matrices.popPose();
        ci.cancel();
    }

    @Redirect(method={"submitSignText(Lnet/minecraft/client/renderer/blockentity/state/SignRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/AbstractSignRenderer;translateSignText(Lcom/mojang/blaze3d/vertex/PoseStack;ZLnet/minecraft/world/phys/Vec3;)V"))
    private void dontApplyTextTransform(AbstractSignRenderer instance, PoseStack matrices, boolean front, Vec3 textOffset) {
        if (matrices instanceof NoTextTransformMatrixStack) {
            return;
        }
        this.translateSignText(matrices, front, textOffset);
    }

    @Unique
    private int immediatelyFast$getTextWidth(SignText signText, boolean filterText, int maxLineWidth) {
        FormattedCharSequence[] orderedTexts = signText.getRenderMessages(filterText, text -> {
            List list = this.font.split((FormattedText)text, maxLineWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        int width = 0;
        for (FormattedCharSequence orderedText : orderedTexts) {
            width = Math.max(width, this.font.width(orderedText));
        }
        if (width % 2 != 0) {
            ++width;
        }
        return width;
    }
}

