/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.batching;

import com.mojang.blaze3d.opengl.GlCommandEncoder;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.raphimc.immediatelyfast.feature.batching.HudBatchingBufferSource;
import net.raphimc.immediatelyfast.feature.batching.RenderSystemState;
import net.raphimc.immediatelyfast.injection.interfaces.IGlResourceManager;

public class BatchingBuffers {
    private static MultiBufferSource.BufferSource nonBatchingEntityVertexConsumers;
    private static HudBatchingBufferSource hudBatchingVertexConsumers;
    private static boolean isHudBatching;

    public static MultiBufferSource.BufferSource getNonBatchingEntityVertexConsumers() {
        if (nonBatchingEntityVertexConsumers == null) {
            SequencedMap<RenderType, ByteBufferBuilder> layerBuffers = BatchingBuffers.createLayerBuffers(Minecraft.getInstance().renderBuffers().bufferSource().fixedBuffers.keySet());
            nonBatchingEntityVertexConsumers = new MultiBufferSource.BufferSource(new ByteBufferBuilder(786432), layerBuffers);
        }
        return nonBatchingEntityVertexConsumers;
    }

    public static MultiBufferSource.BufferSource getHudBatchingVertexConsumers() {
        if (hudBatchingVertexConsumers == null) {
            SequencedMap<RenderType, ByteBufferBuilder> layerBuffers = BatchingBuffers.createLayerBuffers(Minecraft.getInstance().renderBuffers().bufferSource().fixedBuffers.keySet());
            hudBatchingVertexConsumers = new HudBatchingBufferSource(new ByteBufferBuilder(786432), layerBuffers);
        }
        return hudBatchingVertexConsumers;
    }

    public static void runBatched(GuiGraphics drawContext, Runnable runnable) {
        drawContext.flush();
        MultiBufferSource.BufferSource prev = drawContext.bufferSource;
        drawContext.bufferSource = BatchingBuffers.getHudBatchingVertexConsumers();
        isHudBatching = true;
        try {
            runnable.run();
            drawContext.flush();
        }
        finally {
            drawContext.bufferSource = prev;
            isHudBatching = false;
        }
    }

    public static boolean isHudBatching() {
        return isHudBatching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryForceDrawHudBuffers() {
        if (!hudBatchingVertexConsumers.isCurrentlyDrawing() && hudBatchingVertexConsumers.hasActiveLayers()) {
            RenderSystemState renderSystemState = RenderSystemState.current();
            GlCommandEncoder glResourceManager = (GlCommandEncoder)RenderSystem.getDevice().createCommandEncoder();
            boolean prevRenderPassOpen = glResourceManager.inRenderPass;
            RenderPipeline prevRenderPipeline = glResourceManager.lastPipeline;
            glResourceManager.inRenderPass = false;
            glResourceManager.lastPipeline = null;
            ((IGlResourceManager)glResourceManager).immediatelyfast$skipRenderPassClose(true);
            try {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                hudBatchingVertexConsumers.endBatch();
            }
            finally {
                ((IGlResourceManager)glResourceManager).immediatelyfast$skipRenderPassClose(false);
                glResourceManager.lastPipeline = prevRenderPipeline;
                glResourceManager.inRenderPass = prevRenderPassOpen;
                renderSystemState.apply();
            }
        }
    }

    private static SequencedMap<RenderType, ByteBufferBuilder> createLayerBuffers(Set<RenderType> layers) {
        Object2ObjectLinkedOpenHashMap layerBuffers = new Object2ObjectLinkedOpenHashMap(layers.size());
        for (RenderType layer : layers) {
            layerBuffers.put(layer, new ByteBufferBuilder(layer.bufferSize()));
        }
        return layerBuffers;
    }

    public static class WrappedRenderLayer
    extends RenderType {
        private final RenderType renderLayer;
        private final Runnable additionalStartAction;
        private final Runnable additionalEndAction;

        public WrappedRenderLayer(RenderType renderLayer, Runnable additionalStartAction, Runnable additionalEndAction) {
            super(renderLayer.name, renderLayer.bufferSize(), renderLayer.affectsCrumbling(), renderLayer.sortOnUpload(), () -> ((RenderType)renderLayer).setupRenderState(), () -> ((RenderType)renderLayer).clearRenderState());
            this.renderLayer = renderLayer;
            this.additionalStartAction = additionalStartAction;
            this.additionalEndAction = additionalEndAction;
        }

        public void draw(MeshData buffer) {
            this.additionalStartAction.run();
            this.renderLayer.draw(buffer);
            this.additionalEndAction.run();
        }

        public RenderTarget getRenderTarget() {
            return this.renderLayer.getRenderTarget();
        }

        public RenderPipeline getRenderPipeline() {
            return this.renderLayer.getRenderPipeline();
        }

        public VertexFormat format() {
            return this.renderLayer.format();
        }

        public VertexFormat.Mode mode() {
            return this.renderLayer.mode();
        }

        public Optional<RenderType> outline() {
            return this.renderLayer.outline();
        }

        public boolean isOutline() {
            return this.renderLayer.isOutline();
        }
    }
}

