/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.sign_text_buffering;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.AbstractSignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.phys.Vec3;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.core.BufferAllocatorPool;
import net.raphimc.immediatelyfast.feature.sign_text_buffering.NoTextTransformMatrixStack;
import net.raphimc.immediatelyfast.feature.sign_text_buffering.SignAtlasFramebuffer;
import net.raphimc.immediatelyfast.injection.interfaces.ISignText;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractSignRenderer.class})
public abstract class MixinAbstractSignBlockEntityRenderer {
    @Shadow
    @Final
    private Font font;

    @Shadow
    protected abstract void renderSignText(BlockPos var1, SignText var2, PoseStack var3, MultiBufferSource var4, int var5, int var6, int var7, boolean var8);

    @Shadow
    protected abstract void translateSignText(PoseStack var1, boolean var2, Vec3 var3);

    @Shadow
    protected abstract Vec3 getTextOffset();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"renderSignText(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/SignText;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIIZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderBufferedSignText(BlockPos pos, SignText signText, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int lineHeight, int lineWidth, boolean front, CallbackInfo ci) {
        if (matrices instanceof NoTextTransformMatrixStack) {
            return;
        }
        ISignText iSignText = (ISignText)signText;
        if (!iSignText.immediatelyFast$shouldCache()) {
            return;
        }
        SignAtlasFramebuffer.Slot slot = (SignAtlasFramebuffer.Slot)ImmediatelyFast.signTextCache.slotCache.getIfPresent((Object)signText);
        if (slot == null) {
            int width = this.immediatelyFast$getTextWidth(signText, lineWidth);
            int height = 4 * lineHeight;
            if (width <= 0 || height <= 0) {
                iSignText.immediatelyFast$setShouldCache(false);
                return;
            }
            int padding = signText.hasGlowingText() ? 2 : 0;
            slot = ImmediatelyFast.signTextCache.signAtlasFramebuffer.findSlot(width + padding, height + padding);
            if (slot != null) {
                Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, 4096.0f, 4096.0f, 0.0f, -1000.0f, 1000.0f);
                RenderSystem.backupProjectionMatrix();
                RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
                Matrix4fStack modelViewMatrix = RenderSystem.getModelViewStack();
                modelViewMatrix.pushMatrix();
                modelViewMatrix.identity();
                FogParameters fog = RenderSystem.getShaderFog();
                RenderSystem.setShaderFog((FogParameters)FogParameters.NO_FOG);
                ByteBufferBuilder bufferAllocator = BufferAllocatorPool.borrowBufferAllocator();
                int previousFbo = ImmediatelyFast.signTextCache.signAtlasFramebuffer.bind(true);
                ImmediatelyFast.signTextCache.lockFramebuffer = true;
                ImmediatelyFast.signTextCache.lockViewport = true;
                try {
                    MultiBufferSource.BufferSource immediate = MultiBufferSource.immediate((ByteBufferBuilder)bufferAllocator);
                    NoTextTransformMatrixStack matrixStack = new NoTextTransformMatrixStack();
                    matrixStack.translate(slot.x, slot.y, 0.0f);
                    matrixStack.translate((float)slot.width / 2.0f, (float)slot.height / 2.0f, 0.0f);
                    this.renderSignText(Minecraft.getInstance().cameraEntity.blockPosition(), signText, matrixStack, (MultiBufferSource)immediate, light, lineHeight, lineWidth, front);
                    immediate.endBatch();
                }
                finally {
                    ImmediatelyFast.signTextCache.lockViewport = false;
                    ImmediatelyFast.signTextCache.lockFramebuffer = false;
                    ImmediatelyFast.signTextCache.signAtlasFramebuffer.unbind(previousFbo);
                    BufferAllocatorPool.returnBufferAllocatorSafe(bufferAllocator);
                    RenderSystem.setShaderFog((FogParameters)fog);
                    modelViewMatrix.popMatrix();
                    RenderSystem.restoreProjectionMatrix();
                }
                ImmediatelyFast.signTextCache.slotCache.put((Object)signText, (Object)slot);
            } else {
                ImmediatelyFast.LOGGER.warn("Failed to find a free slot for sign text (" + ImmediatelyFast.signTextCache.slotCache.size() + " sign texts in atlas). Falling back to immediate mode rendering.");
                iSignText.immediatelyFast$setShouldCache(false);
                return;
            }
        }
        float u1 = (float)slot.x / 4096.0f;
        float u2 = ((float)slot.x + (float)slot.width) / 4096.0f;
        float v1 = 1.0f - (float)slot.y / 4096.0f;
        float v2 = 1.0f - ((float)slot.y + (float)slot.height) / 4096.0f;
        if (signText.hasGlowingText()) {
            light = 0xF000F0;
        }
        matrices.pushPose();
        this.translateSignText(matrices, front, this.getTextOffset());
        matrices.translate((float)(-slot.width) / 2.0f, (float)(-slot.height) / 2.0f, 0.0f);
        Matrix4f matrix4f = matrices.last().pose();
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(ImmediatelyFast.signTextCache.renderLayer);
        vertexConsumer.addVertex(matrix4f, 0.0f, (float)slot.height, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v2).setLight(light);
        vertexConsumer.addVertex(matrix4f, (float)slot.width, (float)slot.height, 0.0f).setColor(255, 255, 255, 255).setUv(u2, v2).setLight(light);
        vertexConsumer.addVertex(matrix4f, (float)slot.width, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u2, v1).setLight(light);
        vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v1).setLight(light);
        matrices.popPose();
        ci.cancel();
    }

    @Redirect(method={"renderSignText(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/SignText;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIIZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/AbstractSignRenderer;translateSignText(Lcom/mojang/blaze3d/vertex/PoseStack;ZLnet/minecraft/world/phys/Vec3;)V"))
    private void dontApplyTextTransform(AbstractSignRenderer instance, PoseStack matrices, boolean front, Vec3 textOffset) {
        if (matrices instanceof NoTextTransformMatrixStack) {
            return;
        }
        this.translateSignText(matrices, front, textOffset);
    }

    @Unique
    private int immediatelyFast$getTextWidth(SignText signText, int lineWidth) {
        FormattedCharSequence[] orderedTexts = signText.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), text -> {
            List list = this.font.split((FormattedText)text, lineWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        int width = 0;
        for (FormattedCharSequence orderedText : orderedTexts) {
            width = Math.max(width, this.font.width(orderedText));
        }
        if (width % 2 != 0) {
            ++width;
        }
        return width;
    }
}

