/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.core.compat;

import com.mojang.blaze3d.shaders.CompiledShader;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.compat.CoreShaderBlacklist;
import net.raphimc.immediatelyfast.feature.core.ImmediatelyFastResourcePackMetadata;
import net.raphimc.immediatelyfast.injection.interfaces.IShaderProgram;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderManager.class})
public abstract class MixinShaderLoader {
    @Shadow
    private ShaderManager.CompilationCache compilationCache;

    @Inject(method={"apply(Lnet/minecraft/client/renderer/ShaderManager$Configs;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="RETURN")})
    private void checkForCoreShaderModifications(ShaderManager.Configs definitions, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        if (ImmediatelyFast.config.experimental_disable_resource_pack_conflict_handling) {
            return;
        }
        PackResources resourcePackWhichBreaksFontAtlasResizing = null;
        PackResources resourcePackWhichBreaksHudBatching = null;
        PackResources resourcePackWhichBreaksScreenBatching = null;
        try {
            HashSet<PackResources> breakingResourcePacks = new HashSet<PackResources>();
            for (ShaderProgram shaderProgramKey : CoreShaderBlacklist.getBlacklist()) {
                ResourceLocation fragmentShaderIdentifier;
                PackResources fragmentShaderResourcePack;
                IShaderProgram mixinShaderProgram;
                CompiledShaderProgram compiledShaderProgram = this.compilationCache.getOrCompileProgram(shaderProgramKey);
                if (!(compiledShaderProgram instanceof IShaderProgram) || (mixinShaderProgram = (IShaderProgram)compiledShaderProgram).immediatelyFast$getVertexShader() == null || mixinShaderProgram.immediatelyFast$getFragmentShader() == null) continue;
                ResourceLocation vertexShaderIdentifier = CompiledShader.Type.VERTEX.idConverter().idToFile(mixinShaderProgram.immediatelyFast$getVertexShader().getId());
                PackResources vertexShaderResourcePack = resourceManager.getResource(vertexShaderIdentifier).map(Resource::source).orElse(null);
                if (vertexShaderResourcePack != null && !vertexShaderResourcePack.equals((Object)Minecraft.getInstance().getVanillaPackResources())) {
                    breakingResourcePacks.add(vertexShaderResourcePack);
                }
                if ((fragmentShaderResourcePack = (PackResources)resourceManager.getResource(fragmentShaderIdentifier = CompiledShader.Type.FRAGMENT.idConverter().idToFile(mixinShaderProgram.immediatelyFast$getFragmentShader().getId())).map(Resource::source).orElse(null)) == null || fragmentShaderResourcePack.equals((Object)Minecraft.getInstance().getVanillaPackResources())) continue;
                breakingResourcePacks.add(fragmentShaderResourcePack);
            }
            for (PackResources resourcePack : breakingResourcePacks) {
                ImmediatelyFastResourcePackMetadata metadata = (ImmediatelyFastResourcePackMetadata)resourcePack.getMetadataSection(ImmediatelyFastResourcePackMetadata.SERIALIZER);
                if (metadata == null) {
                    metadata = ImmediatelyFastResourcePackMetadata.DEFAULT;
                }
                if (!metadata.compatibleFeatures().contains("font_atlas_resizing")) {
                    resourcePackWhichBreaksFontAtlasResizing = resourcePack;
                }
                if (!metadata.compatibleFeatures().contains("hud_batching")) {
                    resourcePackWhichBreaksHudBatching = resourcePack;
                }
                if (metadata.compatibleFeatures().contains("experimental_screen_batching")) continue;
                resourcePackWhichBreaksScreenBatching = resourcePack;
            }
        }
        catch (IOException | ShaderManager.CompilationException e) {
            ImmediatelyFast.LOGGER.error("Failed to check for core shader modifications", e);
        }
        if (ImmediatelyFast.runtimeConfig.font_atlas_resizing && resourcePackWhichBreaksFontAtlasResizing != null) {
            ImmediatelyFast.LOGGER.warn("Resource pack " + resourcePackWhichBreaksFontAtlasResizing.packId() + " is not compatible with font atlas resizing. Temporarily disabling font atlas resizing.");
            ImmediatelyFast.runtimeConfig.font_atlas_resizing = false;
            this.immediatelyFast$reloadFontStorages();
        } else if (!ImmediatelyFast.runtimeConfig.font_atlas_resizing && ImmediatelyFast.config.font_atlas_resizing) {
            ImmediatelyFast.runtimeConfig.font_atlas_resizing = true;
            this.immediatelyFast$reloadFontStorages();
        }
        if (ImmediatelyFast.runtimeConfig.hud_batching && resourcePackWhichBreaksHudBatching != null) {
            ImmediatelyFast.LOGGER.warn("Resource pack " + resourcePackWhichBreaksHudBatching.packId() + " is not compatible with HUD batching. Temporarily disabling HUD batching.");
            ImmediatelyFast.runtimeConfig.hud_batching = false;
        } else {
            ImmediatelyFast.runtimeConfig.hud_batching = ImmediatelyFast.config.hud_batching;
        }
        if (ImmediatelyFast.runtimeConfig.experimental_screen_batching && resourcePackWhichBreaksScreenBatching != null) {
            ImmediatelyFast.LOGGER.warn("Resource pack " + resourcePackWhichBreaksScreenBatching.packId() + " is not compatible with experimental screen batching. Temporarily disabling experimental screen batching.");
            ImmediatelyFast.runtimeConfig.experimental_screen_batching = false;
        } else {
            ImmediatelyFast.runtimeConfig.experimental_screen_batching = ImmediatelyFast.config.experimental_screen_batching;
        }
    }

    @Unique
    private void immediatelyFast$reloadFontStorages() {
        Minecraft.getInstance().fontManager.updateOptions(Minecraft.getInstance().options);
    }
}

