/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.resources.ResourceLocation;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.compat.IrisCompat;
import net.raphimc.immediatelyfast.feature.core.BufferBuilderPool;

public class BatchableBufferSource
extends MultiBufferSource.BufferSource
implements AutoCloseable {
    private static final BufferBuilder FALLBACK_BUFFER = new BufferBuilder(0);
    protected final Map<RenderType, ReferenceSet<BufferBuilder>> fallbackBuffers = IrisCompat.IRIS_LOADED ? new Object2ObjectLinkedOpenHashMap() : new Reference2ObjectLinkedOpenHashMap();
    protected final Set<RenderType> activeLayers = IrisCompat.IRIS_LOADED ? new ObjectLinkedOpenHashSet() : new ReferenceLinkedOpenHashSet();
    protected boolean drawFallbackLayersFirst = false;

    public BatchableBufferSource() {
        this((Map<RenderType, BufferBuilder>)ImmutableMap.of());
    }

    public BatchableBufferSource(Map<RenderType, BufferBuilder> layerBuffers) {
        this(FALLBACK_BUFFER, layerBuffers);
    }

    public BatchableBufferSource(BufferBuilder fallbackBuffer, Map<RenderType, BufferBuilder> layerBuffers) {
        super(fallbackBuffer, layerBuffers);
    }

    public VertexConsumer getBuffer(RenderType layer) {
        Optional newLayer = layer.asOptional();
        if (!this.drawFallbackLayersFirst && !this.lastState.equals(newLayer) && this.lastState.isPresent() && !this.fixedBuffers.containsKey(this.lastState.get())) {
            this.drawFallbackLayersFirst = true;
        }
        this.lastState = newLayer;
        BufferBuilder bufferBuilder = this.getOrCreateBufferBuilder(layer);
        if (bufferBuilder.building() && !layer.canConsolidateConsecutiveGeometry()) {
            throw new IllegalStateException("Tried to write shared vertices into the same buffer");
        }
        if (!bufferBuilder.building()) {
            if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
                IrisCompat.iris$beginWithoutExtending.accept(bufferBuilder, layer.mode(), layer.format());
            } else {
                bufferBuilder.begin(layer.mode(), layer.format());
            }
            this.activeLayers.add(layer);
        } else if ((ImmediatelyFast.config.debug_only_use_last_usage_for_batch_ordering || layer.name.contains("immediatelyfast:renderlast")) && this.activeLayers.contains(layer)) {
            this.activeLayers.remove(layer);
            this.activeLayers.add(layer);
        }
        return bufferBuilder;
    }

    public void endLastBatch() {
        this.lastState = Optional.empty();
        this.drawFallbackLayersFirst = false;
        int sortedLayersLength = 0;
        RenderType[] sortedLayers = new RenderType[this.activeLayers.size()];
        for (RenderType layer : this.activeLayers) {
            if (this.fixedBuffers.containsKey(layer)) continue;
            sortedLayers[sortedLayersLength++] = layer;
        }
        if (sortedLayersLength == 0) {
            return;
        }
        Arrays.sort(sortedLayers, (l1, l2) -> Integer.compare(this.getLayerOrder((RenderType)l1), this.getLayerOrder((RenderType)l2)));
        for (int i = 0; i < sortedLayersLength; ++i) {
            this.endBatch(sortedLayers[i]);
        }
    }

    public void endBatch() {
        if (this.activeLayers.isEmpty()) {
            this.close();
            return;
        }
        this.endLastBatch();
        for (RenderType layer : this.fixedBuffers.keySet()) {
            this.endBatch(layer);
        }
    }

    public void endBatch(RenderType layer) {
        if (this.drawFallbackLayersFirst) {
            this.endLastBatch();
        }
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(false);
        }
        this.activeLayers.remove(layer);
        for (BufferBuilder bufferBuilder : this.getBufferBuilder(layer)) {
            if (bufferBuilder == null) continue;
            layer.end(bufferBuilder, RenderSystem.getVertexSorting());
        }
        this.fallbackBuffers.remove(layer);
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(true);
        }
    }

    @Override
    public void close() {
        this.lastState = Optional.empty();
        this.drawFallbackLayersFirst = false;
        for (RenderType layer : this.activeLayers) {
            for (BufferBuilder bufferBuilder : this.getBufferBuilder(layer)) {
                bufferBuilder.end().release();
            }
        }
        this.activeLayers.clear();
        this.fallbackBuffers.clear();
    }

    public boolean hasActiveLayers() {
        return !this.activeLayers.isEmpty();
    }

    protected BufferBuilder getOrCreateBufferBuilder(RenderType layer) {
        if (!layer.canConsolidateConsecutiveGeometry()) {
            return this.addNewFallbackBuffer(layer);
        }
        if (this.fixedBuffers.containsKey(layer)) {
            return (BufferBuilder)this.fixedBuffers.get(layer);
        }
        if (this.fallbackBuffers.containsKey(layer)) {
            return (BufferBuilder)this.fallbackBuffers.get(layer).iterator().next();
        }
        return this.addNewFallbackBuffer(layer);
    }

    protected Set<BufferBuilder> getBufferBuilder(RenderType layer) {
        if (this.fallbackBuffers.containsKey(layer)) {
            return (Set)this.fallbackBuffers.get(layer);
        }
        if (this.fixedBuffers.containsKey(layer)) {
            return Collections.singleton((BufferBuilder)this.fixedBuffers.get(layer));
        }
        return Collections.emptySet();
    }

    protected BufferBuilder addNewFallbackBuffer(RenderType layer) {
        BufferBuilder bufferBuilder = BufferBuilderPool.get();
        this.fallbackBuffers.computeIfAbsent(layer, k -> new ReferenceLinkedOpenHashSet()).add((Object)bufferBuilder);
        return bufferBuilder;
    }

    protected int getLayerOrder(RenderType layer) {
        if (layer == null) {
            return Integer.MAX_VALUE;
        }
        if (layer instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType multiPhase = (RenderType.CompositeRenderType)layer;
            ResourceLocation textureId = multiPhase.state().textureState.cutoutTexture().orElse(null);
            if (textureId != null) {
                if (textureId.getPath().startsWith("textures/entity/horse/")) {
                    String horseTexturePath = textureId.getPath().substring("textures/entity/horse/".length());
                    if (horseTexturePath.startsWith("horse_markings")) {
                        return 2;
                    }
                    if (horseTexturePath.startsWith("armor/")) {
                        return 3;
                    }
                    return 1;
                }
                if (textureId.equals((Object)Sheets.ARMOR_TRIMS_SHEET)) {
                    return 1;
                }
                if (layer.name.startsWith("text") || layer.name.startsWith("neoforge_text") || layer.name.startsWith("forge_text")) {
                    if (textureId.getNamespace().equals("minecraft")) {
                        return 2;
                    }
                    return 1;
                }
                if (textureId.getNamespace().equals("cataclysm")) {
                    if (textureId.getPath().equals("textures/entity/maledictus/phantom_halberd.png")) {
                        return 2;
                    }
                    if (textureId.getPath().equals("textures/entity/maledictus/phantom_halberd_discard.png")) {
                        return 1;
                    }
                } else if (textureId.getNamespace().equals("alexscaves")) {
                    if (textureId.getPath().equals("textures/entity/hullbreaker_glow.png")) {
                        return 2;
                    }
                    if (textureId.getPath().equals("textures/entity/hullbreaker.png")) {
                        return 1;
                    }
                    if (textureId.getPath().equals("textures/entity/tremorzilla/tremorzilla_glow_powered.png")) {
                        return 2;
                    }
                    if (textureId.getPath().equals("textures/entity/tremorzilla/tremorzilla.png")) {
                        return 1;
                    }
                }
            }
        }
        if (!layer.sortOnUpload) {
            return Integer.MIN_VALUE;
        }
        return 0x7FFFFFFE;
    }
}

