/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.familiar_friends.entities;

import java.util.Comparator;
import java.util.List;
import net.deadlydiamond98.familiar_friends.entities.abstractcompanionclasses.MockMobEntity;
import net.deadlydiamond98.familiar_friends.entities.abstractcompanionclasses.behaviors.LookAroundBehavior;
import net.deadlydiamond98.familiar_friends.entities.abstractcompanionclasses.behaviors.LookBehavior;
import net.deadlydiamond98.familiar_friends.sounds.CompanionSounds;
import net.deadlydiamond98.familiar_friends.util.TimeUnitHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2945;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerCompanion
extends MockMobEntity
implements class_8046 {
    public static final float SPEED = 1.5f;
    public static final float FOLLOW_DISTANCE = 5.0f;
    private int idleTime;
    private float orbitArc;
    private class_1297 owner;
    private int cooldown;
    private int costClient;
    private boolean enabledClient;
    protected boolean bookRender;
    private LookBehavior currentLookBehavior;

    public PlayerCompanion(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public PlayerCompanion(class_1299<?> type, class_1937 world, class_1657 owner, boolean gui) {
        this(type, world);
        this.costClient = 0;
        this.enabledClient = false;
        this.cooldown = 0;
        this.idleTime = 0;
        this.orbitArc = 0.0f;
        this.field_5960 = true;
        this.owner = owner;
        this.method_33574(owner.method_19538());
        this.bookRender = gui;
    }

    protected void doPassiveAction(class_1657 player, class_1309 nearestHostile) {
    }

    public void doKeyEvent(class_1657 player) {
    }

    public void onAttack(class_1657 player, class_1309 target, float amount) {
    }

    public void onPlayerDeath(class_1657 player) {
    }

    public boolean onDamaged(class_1282 source, float amount, class_1657 player) {
        return false;
    }

    public boolean canClimbWalls() {
        return false;
    }

    public class_1309 findNearestHostile(class_1657 player) {
        List nearbyEntities = player.method_37908().method_8390(class_1309.class, player.method_5829().method_1014(10.0), entity -> entity instanceof class_1569 && entity.method_5805());
        return nearbyEntities.stream().min(Comparator.comparingDouble(entity -> entity.method_5858((class_1297)player))).orElse(null);
    }

    public class_1297 findNearestEntity(class_1657 player) {
        List nearbyEntities = player.method_37908().method_8390(class_1297.class, player.method_5829().method_1014(10.0), entity -> entity.method_5805());
        return nearbyEntities.stream().min(Comparator.comparingDouble(entity -> entity.method_5858((class_1297)player))).orElse(null);
    }

    public abstract int getCost();

    public abstract boolean isEnabled();

    public boolean hasNoHealthLimitation(class_1657 player, int minimum) {
        return this.hasNoLimitationOf(player.method_6032(), minimum, player, (class_2561)class_2561.method_43469((String)"cooldown.familiar_friends.lowstat", (Object[])new Object[]{class_2561.method_43471((String)"cooldown.familiar_friends.health").getString()}), true);
    }

    public boolean hasNoHungerLimitation(class_1657 player, int minimum) {
        return this.hasNoLimitationOf(player.method_7344().method_7586(), minimum, player, (class_2561)class_2561.method_43469((String)"cooldown.familiar_friends.lowstat", (Object[])new Object[]{class_2561.method_43471((String)"cooldown.familiar_friends.hunger").getString()}), true);
    }

    public boolean hasNoLimitationOf(float currentValue, float threshold, class_1657 player, class_2561 translation, boolean trueIfCreative) {
        if (trueIfCreative && (player.method_7337() || player.method_7325())) {
            return true;
        }
        if (currentValue <= threshold) {
            player.method_37908().method_8396(null, player.method_24515(), CompanionSounds.Action_Failed, class_3419.field_15248, 0.5f, 1.0f);
            player.method_7353(translation, true);
        }
        return !(currentValue <= threshold);
    }

    public boolean hasNoCooldown(class_1657 player) {
        String cooldownUnit = TimeUnitHelper.getCooldownUnitText(this.cooldown);
        int time = TimeUnitHelper.calculateCooldownUnit(this.cooldown);
        return this.hasNoLimitationOf(1.0f, this.cooldown, player, (class_2561)class_2561.method_43469((String)"cooldown.familiar_friends.cooldown", (Object[])new Object[]{time, class_2561.method_43471((String)("cooldown.familiar_friends." + cooldownUnit)).getString()}), false);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void setCooldownSeconds(int cooldown) {
        this.cooldown = cooldown * 20;
    }

    public void setCooldownMinutes(int cooldown) {
        this.cooldown = cooldown * 20 * 60;
    }

    @Override
    public void method_5670() {
        if (!this.method_37908().method_8608()) {
            class_1297 class_12972;
            if (this.method_24921() != null && (class_12972 = this.method_24921()) instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                if (!player.method_5805() || player.method_37908() != this.method_37908()) {
                    this.method_31472();
                    return;
                }
            } else {
                this.method_31472();
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        super.method_5670();
    }

    @Override
    protected void tickMovement() {
        class_1297 class_12972;
        this.lookBehavior();
        if (this.method_24921() != null && (class_12972 = this.method_24921()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.moveAround(player);
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        super.tickMovement();
    }

    protected void lookBehavior() {
        if (this.idleTime <= 500) {
            if (this.currentLookBehavior == null || this.currentLookBehavior.isFinished()) {
                this.currentLookBehavior = new LookAroundBehavior(this);
                this.currentLookBehavior.start();
            }
            this.currentLookBehavior.tick();
        }
    }

    private void moveAround(class_1657 player) {
        double distanceToTarget = this.method_19538().method_1022(player.method_19538());
        if (distanceToTarget > 20.0) {
            this.method_33574(player.method_19538());
        } else if (distanceToTarget > 12.5) {
            this.setVelocityTowards(player.method_19538().method_1031(0.0, 2.0, 0.0), 3.0);
            this.idleTime = 0;
        } else if (distanceToTarget > 5.0) {
            this.setVelocityTowards(player.method_19538().method_1031(0.0, 2.0, 0.0), 1.5);
            this.idleTime = 0;
        } else {
            this.handleIdleMovement(player);
        }
        this.doPassiveAction(player, this.findNearestHostile(player));
    }

    protected void handleIdleMovement(class_1657 player) {
        ++this.idleTime;
        if (this.idleTime <= 500) {
            class_243 lookDirection = player.method_5828(1.0f).method_1029();
            double yawRad = Math.toRadians(player.method_36454());
            double offsetFront = -0.6;
            double offsetRight = -1.0;
            double offsetX = offsetRight * (double)class_3532.method_15362((float)((float)yawRad)) - offsetFront * (double)class_3532.method_15374((float)((float)yawRad));
            double offsetZ = offsetRight * (double)class_3532.method_15374((float)((float)yawRad)) + offsetFront * (double)class_3532.method_15362((float)((float)yawRad));
            class_243 shoulderPos = player.method_19538().method_1031(offsetX, (double)player.method_18381(player.method_18376()) + 0.1, offsetZ).method_1019(lookDirection);
            if (this.method_19538().method_1020(shoulderPos).method_37267() > 0.5) {
                this.setVelocityTowards(shoulderPos, 0.15000000000000002);
                this.idleTime = 0;
            } else {
                this.setVelocityTowards(shoulderPos, 0.0);
            }
        } else {
            this.circleAround((class_1297)player, 2.5, 0.1);
        }
    }

    public void circleAround(class_1297 entity, double radius, double speed) {
        double angleVariance = 0.01;
        double positionVariance = 0.01;
        double angleIncrement = 0.5 * speed + (Math.random() * angleVariance - angleVariance / 2.0);
        this.orbitArc = (float)((double)this.orbitArc + angleIncrement);
        if ((double)this.orbitArc > Math.PI * 2) {
            this.orbitArc = (float)((double)this.orbitArc - Math.PI * 2);
        }
        double randomRadiusX = radius + (Math.random() * positionVariance - positionVariance / 2.0);
        double randomRadiusZ = radius + (Math.random() * positionVariance - positionVariance / 2.0);
        double targetX = entity.method_23317() + randomRadiusX * Math.cos(this.orbitArc);
        double targetZ = entity.method_23321() + randomRadiusZ * Math.sin(this.orbitArc);
        double targetY = class_3532.method_16436((double)0.1, (double)this.method_23318(), (double)(entity.method_23320() - 0.75));
        class_243 targetPosition = new class_243(targetX, targetY, targetZ);
        this.setVelocityTowards(targetPosition, speed);
        this.getLookControl().lookAt(targetPosition.method_10216(), targetPosition.method_10214(), targetPosition.method_10215());
    }

    public void setVelocityTowards(class_243 targetPosition, double speed) {
        class_243 direction = targetPosition.method_1020(this.method_19538()).method_1029();
        class_243 desiredVelocity = direction.method_1021(speed);
        class_243 currentVelocity = this.method_18798();
        class_243 interpolatedVelocity = currentVelocity.method_35590(desiredVelocity, 0.1);
        this.method_18799(interpolatedVelocity);
    }

    public class_2561 getDescription(String keybinding) {
        return class_2561.method_43469((String)(this.method_5864().method_5882() + ".description"), (Object[])new Object[]{keybinding});
    }

    public class_2561 getAuthor() {
        return class_2561.method_43471((String)"gui.familiar_friends.author").method_10852((class_2561)class_2561.method_43471((String)(this.method_5864().method_5882() + ".author")));
    }

    public class_2561 getCostLang(int cost) {
        return class_2561.method_43469((String)"gui.familiar_friends.cost", (Object[])new Object[]{cost}).method_54663(4689479);
    }

    public boolean isBookRender() {
        return this.bookRender;
    }

    public boolean isLocked(class_1657 player) {
        return !player.isCompanionUnlocked(this);
    }

    public void syncClientData(int cost, boolean enabledClient) {
        this.costClient = cost;
        this.enabledClient = enabledClient;
    }

    public boolean getEnabledClient() {
        return this.enabledClient;
    }

    public int getCostClient() {
        return this.costClient;
    }

    @Nullable
    public class_1297 method_24921() {
        return this.owner;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
    }
}

