/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.familiar_friends.mixin;

import java.util.ArrayList;
import java.util.List;
import net.deadlydiamond98.familiar_friends.entities.CompanionRegistry;
import net.deadlydiamond98.familiar_friends.entities.PlayerCompanion;
import net.deadlydiamond98.familiar_friends.networking.CompanionServerPackets;
import net.deadlydiamond98.familiar_friends.util.CompanionPlayerData;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
implements CompanionPlayerData {
    @Unique
    private List<String> unlockedCompanions;
    @Unique
    private List<String> lastSyncedUnlockedCompanions;
    @Unique
    @Nullable
    private PlayerCompanion currentCompanion;
    @Unique
    private String backUpCompanionKey;
    @Unique
    private String lastSyncedBackUpCompanionKey;
    @Unique
    private boolean hasCompanion;
    @Unique
    private int companionCooldown;
    @Unique
    private int lastCompanionCooldown;

    @Unique
    public class_1657 familiar_friends$getPlayer() {
        return (class_1657)this;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        String highlyImprobableString;
        this.hasCompanion = false;
        this.unlockedCompanions = new ArrayList<String>();
        this.currentCompanion = null;
        this.backUpCompanionKey = "";
        this.companionCooldown = 0;
        this.lastCompanionCooldown = 0;
        this.lastSyncedBackUpCompanionKey = highlyImprobableString = "42069, Trying to make a string that will never happen so this updates when the player's joins, and so that this isn't mistaken for an entity";
        this.lastSyncedUnlockedCompanions = new ArrayList<String>();
        this.lastSyncedUnlockedCompanions.add(highlyImprobableString);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (!this.familiar_friends$getPlayer().method_37908().method_8608()) {
            if (this.companionCooldown > 0) {
                --this.companionCooldown;
            }
            this.syncCompanionData();
            this.updateCompanionExistance();
            if (this.companionCooldown > 0) {
                --this.lastCompanionCooldown;
            }
        }
    }

    @Unique
    private void syncCompanionData() {
        if (!this.lastSyncedBackUpCompanionKey.equals(this.backUpCompanionKey) || !this.lastSyncedUnlockedCompanions.equals(this.unlockedCompanions) || this.companionCooldown != this.lastCompanionCooldown) {
            CompanionServerPackets.syncCompanionPlayerData((class_3222)this.familiar_friends$getPlayer(), this.unlockedCompanions, this.backUpCompanionKey, this.companionCooldown);
        }
    }

    @Unique
    private void updateCompanionExistance() {
        if (this.hasCompanion && this.isMyFriendDead()) {
            this.currentCompanion = this.getCompanion();
            if (this.currentCompanion != null) {
                this.familiar_friends$getPlayer().method_37908().method_8649((class_1297)this.currentCompanion);
            }
        } else if (!this.hasCompanion && !this.isMyFriendDead()) {
            if (this.currentCompanion != null) {
                this.currentCompanion.method_31745(class_1297.class_5529.field_26999);
            }
            this.currentCompanion = null;
        }
    }

    @Unique
    private boolean isMyFriendDead() {
        if (this.currentCompanion == null) {
            return true;
        }
        return this.currentCompanion.method_31481();
    }

    @Override
    public boolean isCompanionUnlocked(PlayerCompanion companion) {
        return this.unlockedCompanions.contains(companion.method_5864().method_5882());
    }

    @Override
    public void unlockCompanion(String companion) {
        this.unlockedCompanions.add(companion);
    }

    @Override
    public void syncUnlockedList(List<String> unlockedCompanions) {
        this.unlockedCompanions = unlockedCompanions;
    }

    @Override
    public void syncCompanionCooldown(int cooldown) {
        this.companionCooldown = cooldown;
    }

    @Override
    public void lockAllCompanions() {
        this.unlockedCompanions.clear();
        if (this.currentCompanion != null) {
            this.currentCompanion.method_31745(class_1297.class_5529.field_26999);
        }
        this.backUpCompanionKey = "";
        this.hasCompanion = false;
    }

    @Override
    public void lockCompanion(String companion) {
        this.unlockedCompanions.remove(companion);
        if (this.currentCompanion.method_5864().method_5882().equals(companion)) {
            this.hasCompanion = false;
            this.currentCompanion.method_5650(class_1297.class_5529.field_26999);
            this.currentCompanion = null;
            this.backUpCompanionKey = "";
        }
    }

    @Override
    public void equipCompanion(PlayerCompanion companion) {
        if (this.currentCompanion != null && !this.currentCompanion.method_31481()) {
            this.currentCompanion.method_31745(class_1297.class_5529.field_26999);
        }
        this.currentCompanion = companion;
        this.backUpCompanionKey = companion.method_5864().method_5882();
        this.hasCompanion = true;
        this.familiar_friends$getPlayer().method_37908().method_8649((class_1297)companion);
    }

    @Override
    public void unequipCompanion(PlayerCompanion companion) {
        this.hasCompanion = false;
        this.currentCompanion.method_5650(class_1297.class_5529.field_26999);
        this.currentCompanion = null;
        this.backUpCompanionKey = "";
    }

    @Override
    @Nullable
    public String currentCompanion() {
        return this.backUpCompanionKey;
    }

    @Override
    public void syncCurrentCompanion(String companion) {
        this.backUpCompanionKey = companion;
    }

    @Override
    public void doCompanionKeybind() {
        if (this.currentCompanion != null) {
            this.currentCompanion.doKeyEvent(this.familiar_friends$getPlayer());
        }
    }

    @Override
    public PlayerCompanion getCompanion() {
        return CompanionRegistry.createCompanion(this.backUpCompanionKey, this.familiar_friends$getPlayer());
    }

    @Override
    public int getCompanionCooldown() {
        return this.companionCooldown;
    }

    @Override
    public void setCompanionCooldown(int companionCooldown) {
        this.companionCooldown = companionCooldown;
        this.lastCompanionCooldown = companionCooldown;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    public void onSave(class_2487 nbt, CallbackInfo info) {
        nbt.method_10556("hasCompanion", this.hasCompanion);
        nbt.method_10582("backUpCompanionKey", this.backUpCompanionKey);
        nbt.method_10569("companionCooldown", this.companionCooldown);
        nbt.method_10569("lastCompanionCooldown", this.lastCompanionCooldown);
        class_2499 companionList = new class_2499();
        for (String companion : this.unlockedCompanions) {
            companionList.add((Object)class_2519.method_23256((String)companion));
        }
        nbt.method_10566("unlockedCompanions", (class_2520)companionList);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    public void onLoad(class_2487 nbt, CallbackInfo info) {
        if (nbt.method_10545("hasCompanion")) {
            this.hasCompanion = nbt.method_10577("hasCompanion");
        }
        if (nbt.method_10545("backUpCompanionKey")) {
            this.backUpCompanionKey = nbt.method_10558("backUpCompanionKey");
        }
        if (nbt.method_10545("companionCooldown")) {
            this.companionCooldown = nbt.method_10550("companionCooldown");
        }
        if (nbt.method_10545("lastCompanionCooldown")) {
            this.lastCompanionCooldown = nbt.method_10550("lastCompanionCooldown");
        }
        if (nbt.method_10573("unlockedCompanions", 9)) {
            class_2499 companionList = nbt.method_10554("unlockedCompanions", 8);
            this.unlockedCompanions.clear();
            for (int i = 0; i < companionList.size(); ++i) {
                this.unlockedCompanions.add(companionList.method_10608(i));
            }
        }
    }
}

